/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.manager;

import java.util.ArrayList;
import java.util.List;
import org.ccdt.common.manager.DecoupleManager;
import org.ccdt.common.manager.ProjectManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;

public class CocosLaunchManager {
    public static final int PLATFORM_IOS = 1;
    public static final int PLATFORM_MAC = 2;
    public static final int PLATFORM_ANDROID = 3;
    public static final int PLATFORM_WIN32 = 4;
    private static List<ICocosLauncher> launchers = new ArrayList<ICocosLauncher>();

    public static void launchCurrentProject(String mode) {
        IProject project = ProjectManager.getCurrentProject();
        if (project != null) {
            CocosLaunchManager.launchProject(project, mode);
        } else {
            CocosLaunchManager.LaunchLast(mode);
        }
    }

    public static void launchProject(IProject project, String mode) {
        CocosLaunchManager.initLaunchers();
        for (ICocosLauncher launcher : launchers) {
            if (!launcher.canHandle(project)) continue;
            launcher.launchProject(project, mode);
        }
    }

    public static void LaunchLast(String mode) {
        ILaunchConfiguration launchConfig = CocosLaunchManager.getLastLaunch(mode);
        if (launchConfig == null) {
            return;
        }
        DebugUITools.launch((ILaunchConfiguration)launchConfig, (String)mode);
    }

    public static ILaunchConfiguration getLastLaunch(String mode) {
        ILaunchConfiguration launchConfig = null;
        launchConfig = "debug".equals(mode) ? DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch("org.eclipse.debug.ui.launchGroup.debug") : DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch("org.eclipse.debug.ui.launchGroup.run");
        return launchConfig;
    }

    public static String getProjectNameByLaunchConfig(ILaunchConfiguration config) {
        String name = null;
        if (config == null) {
            return null;
        }
        CocosLaunchManager.initLaunchers();
        for (ICocosLauncher launcher : launchers) {
            if (!launcher.canHandle(config)) continue;
            name = launcher.getProjectNameByLaunchConfig(config);
        }
        return name;
    }

    public static int getPlatformByLaunchConfig(ILaunchConfiguration config) {
        int platform = 0;
        if (config == null) {
            return 0;
        }
        CocosLaunchManager.initLaunchers();
        for (ICocosLauncher launcher : launchers) {
            if (!launcher.canHandle(config)) continue;
            platform = launcher.getPlatformByLaunchConfig(config);
        }
        return platform;
    }

    public static ILaunchConfiguration getLaunchConfig(String configName) throws CoreException {
        ILaunchConfiguration[] configs;
        if (configName == null || configName.isEmpty()) {
            return null;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = launchManager.getLaunchConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (configName.equals(config.getName())) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    public static String getTargetProjectName(String mode) {
        IProject project = ProjectManager.getCurrentProject();
        if (project == null) {
            ILaunchConfiguration launchConfig = CocosLaunchManager.getLastLaunch(mode);
            return CocosLaunchManager.getProjectNameByLaunchConfig(launchConfig);
        }
        return project.getName();
    }

    public static void refreshConfigRuntime(IProject project, int platform) {
        CocosLaunchManager.initLaunchers();
        for (ICocosLauncher launcher : launchers) {
            if (!launcher.canHandle(project)) continue;
            try {
                String projectname;
                ILaunchConfiguration config = CocosLaunchManager.getLaunchConfig(project.getName());
                if (config == null) {
                    config = launcher.createLaunchConfig(project);
                }
                if (!launcher.canHandle(config) || (projectname = CocosLaunchManager.getProjectNameByLaunchConfig(config)) == null || !projectname.equals(project.getName())) break;
                launcher.refreshConfigRuntime(config, project, platform);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    static void initLaunchers() {
        if (!launchers.isEmpty()) {
            return;
        }
        launchers.add(DecoupleManager.getInstance("lua").getCocosLauncherManager());
        launchers.add(DecoupleManager.getInstance("js").getCocosLauncherManager());
    }

    public static interface ICocosLauncher {
        public boolean canHandle(IProject var1);

        public boolean canHandle(ILaunchConfiguration var1);

        public void launchProject(IProject var1, String var2);

        public String getProjectNameByLaunchConfig(ILaunchConfiguration var1);

        public int getPlatformByLaunchConfig(ILaunchConfiguration var1);

        public void refreshConfigRuntime(ILaunchConfiguration var1, IProject var2, int var3);

        public ILaunchConfiguration createLaunchConfig(IProject var1) throws CoreException;
    }
}

