/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.favorite;

import java.io.File;
import java.io.IOException;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.ProposalCounter;
import org.ccdt.common.model.ProposalCounterMapping;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ProposalService;

public class ProposalServiceImpl
extends ProposalService {
    private ProposalCounterMapping mappings = null;

    public void insertProposal(ICompletionProposal p, ITextViewer viewer) {
        if (viewer == null) {
            return;
        }
        ProposalCounterMapping mappings = this.getMappings();
        if (mappings == null) {
            CocosLogger.getLogger(((Object)((Object)this)).getClass()).error((Object)("can not get mapping handler, check " + PathManager.instance.getProposalConfigPath()));
            return;
        }
        String key = viewer.getClass().toString();
        ProposalCounter counter = mappings.getMapping(key);
        if (counter == null) {
            counter = new ProposalCounter();
            mappings.addMapping(key, counter);
        }
        counter.addProposal(p.getDisplayString());
    }

    public ProposalCounterMapping getMappings() {
        if (this.mappings == null) {
            File file = new File(PathManager.instance.getProposalConfigPath());
            if (!file.exists()) {
                try {
                    file.createNewFile();
                    file.setWritable(true);
                    file.setReadable(true);
                }
                catch (IOException e) {
                    CocosLogger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage());
                }
                ConfigurationManager.getConfiguration(PathManager.instance.getProposalConfigPath()).save(new ProposalCounterMapping());
            }
            this.mappings = ConfigurationManager.getConfiguration(PathManager.instance.getProposalConfigPath()).getConfig(ProposalCounterMapping.class);
        }
        return this.mappings;
    }

    public void save() {
        if (this.mappings != null) {
            ConfigurationManager.getConfiguration(PathManager.instance.getProposalConfigPath()).save(this.mappings);
        }
    }
}

