/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.document;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public enum RefactorHelper {
    instance;

    private static final String FILE_SEPRARATOR = "/";

    public String refactor(String matchStr, IResource file, String replaceName) {
        String oldFilePath = this.getRelativePathBySegment(file, 1, FILE_SEPRARATOR);
        String result = null;
        if (file instanceof IFile && oldFilePath.equals(matchStr)) {
            String folderName = this.getRelativePathBySegment((IResource)file.getParent(), 1, FILE_SEPRARATOR);
            result = folderName == null ? replaceName : String.valueOf(folderName) + FILE_SEPRARATOR + replaceName;
        }
        if (file instanceof IContainer && this.startWithIgnorecase(matchStr, oldFilePath)) {
            String[] segments = oldFilePath.split(FILE_SEPRARATOR);
            String[] matchSegments = matchStr.split(FILE_SEPRARATOR);
            if (matchSegments.length > segments.length) {
                matchSegments[segments.length - 1] = replaceName;
                result = this.getPath(matchSegments, FILE_SEPRARATOR);
            }
        }
        return result;
    }

    private String getPath(String[] seqments, String fileSeparator) {
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < seqments.length) {
            buff.append(seqments[i]);
            if (i < seqments.length - 1) {
                buff.append(fileSeparator);
            }
            ++i;
        }
        return buff.toString();
    }

    private boolean startWithIgnorecase(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.toLowerCase().startsWith(str2.toLowerCase());
    }

    private String getRelativePathBySegment(IResource container, int startSegment, String separator) {
        String[] seqments = container.getFullPath().segments();
        if (seqments.length <= startSegment) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        int i = startSegment;
        while (i < seqments.length) {
            buff.append(seqments[i]);
            if (i != seqments.length - 1) {
                buff.append(separator);
            }
            ++i;
        }
        return buff.toString();
    }
}

