/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.document;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.ccdt.common.document.DocumentSection;
import org.ccdt.common.logger.CocosLogger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public enum DocumentHandler {
    instance;

    private static final String LINE_SEPARATOR = "line.separator";

    public Document read(String filePath) {
        Document document = new Document(this.readFile(filePath));
        return document;
    }

    public void write(Document document, String filePath) {
        if (document == null) {
            return;
        }
        this.writeFile(document.get(), filePath);
    }

    public void replace(Document document, Map<DocumentSection, String> replaceContent) {
        if (document == null || replaceContent == null || replaceContent.isEmpty()) {
            return;
        }
        Set<Map.Entry<DocumentSection, String>> sets = replaceContent.entrySet();
        Map.Entry[] entrys = sets.toArray(new Map.Entry[0]);
        Arrays.sort(entrys, new Comparator<Map.Entry<DocumentSection, String>>(){

            @Override
            public int compare(Map.Entry<DocumentSection, String> entry1, Map.Entry<DocumentSection, String> entry2) {
                return entry1.getKey().getStart() - entry2.getKey().getStart();
            }
        });
        System.out.println(entrys);
        int i = entrys.length - 1;
        while (i >= 0) {
            this.replace(document, (DocumentSection)entrys[i].getKey(), (String)entrys[i].getValue());
            --i;
        }
    }

    public boolean replace(Document document, DocumentSection section, String replaceContent) {
        if (document == null || section == null || replaceContent == null) {
            return false;
        }
        try {
            document.replace(section.getStart(), section.getLength(), replaceContent);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return true;
    }

    public void writeFile(String content, String filePath) {
        block13: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(filePath));
                    writer.write(content);
                }
                catch (IOException e) {
                    CocosLogger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage());
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                    writer = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                    writer = null;
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
                writer = null;
            }
        }
    }

    public String readFile(String file) {
        StringBuilder stringBuilder;
        block14: {
            BufferedReader reader = null;
            stringBuilder = new StringBuilder();
            try {
                try {
                    reader = new BufferedReader(new FileReader(file));
                    String line = null;
                    String ls = System.getProperty(LINE_SEPARATOR);
                    while ((line = reader.readLine()) != null) {
                        stringBuilder.append(line);
                        stringBuilder.append(ls);
                    }
                }
                catch (Exception exception) {
                    if (reader == null) break block14;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    reader = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    reader = null;
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                reader = null;
            }
        }
        return stringBuilder.toString();
    }
}

