/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.config;

import java.lang.reflect.Field;
import org.ccdt.common.config.IConfiguration;
import org.ccdt.common.config.Require;
import org.ccdt.common.utils.CharacterUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceConfiguration
implements IConfiguration {
    private IPreferenceStore store;

    public PreferenceConfiguration(IPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.store = store;
    }

    @Override
    public <T> T getConfig(Class<T> type) {
        Field[] fields;
        if (type == null) {
            return null;
        }
        T config = null;
        try {
            config = type.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        boolean hasRequire = false;
        Field[] fieldArray = fields = type.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            Field field = fieldArray[n2];
            field.setAccessible(true);
            Require require = field.getAnnotation(Require.class);
            if (require != null && !CharacterUtil.instance.isEmpty(value = require.value())) {
                hasRequire = true;
                try {
                    if (field.getType() == Integer.class) {
                        field.setInt(config, this.store.getInt(value));
                    } else if (field.getType() == Boolean.class) {
                        field.setBoolean(config, this.store.getBoolean(value));
                    } else {
                        field.set(config, this.store.getString(value));
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        if (hasRequire) {
            return config;
        }
        return null;
    }

    @Override
    public boolean save(Object config) {
        Field[] fields;
        if (config == null) {
            return false;
        }
        boolean hasRequire = false;
        Field[] fieldArray = fields = config.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            Require require = field.getAnnotation(Require.class);
            if (require != null) {
                hasRequire = true;
                String value = require.value();
                try {
                    Object result = field.get(config);
                    if (result instanceof Integer) {
                        this.store.setValue(value, ((Integer)result).intValue());
                    } else if (result instanceof Boolean) {
                        this.store.setValue(value, ((Boolean)result).booleanValue());
                    } else if (result instanceof String) {
                        this.store.setValue(value, (String)result);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return hasRequire;
    }
}

