/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import org.ccdt.common.config.IConfiguration;
import org.ccdt.common.config.Require;
import org.ccdt.common.utils.CharacterUtil;
import org.dtools.ini.BasicIniFile;
import org.dtools.ini.IniFile;
import org.dtools.ini.IniFileReader;
import org.dtools.ini.IniFileWriter;
import org.eclipse.core.runtime.Assert;

public class INIConfiguration
implements IConfiguration {
    private String iniFilePath;

    public INIConfiguration(String iniFilePath) {
        Assert.isNotNull((Object)iniFilePath);
        this.iniFilePath = iniFilePath;
    }

    @Override
    public <T> T getConfig(Class<T> type) {
        Field[] fields;
        BasicIniFile iniFile = null;
        try {
            File file = new File(this.iniFilePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            iniFile = new BasicIniFile();
            IniFileReader reader = new IniFileReader((IniFile)iniFile, new File(this.iniFilePath));
            reader.read();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (type == null) {
            return null;
        }
        T config = null;
        try {
            config = type.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        boolean hasRequire = false;
        Field[] fieldArray = fields = type.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            Field field = fieldArray[n2];
            field.setAccessible(true);
            Require require = field.getAnnotation(Require.class);
            if (require != null && !CharacterUtil.instance.isEmpty(value = require.value())) {
                hasRequire = true;
                try {
                    if (field.getType() == IniFile.class) {
                        field.set(config, iniFile);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        if (hasRequire) {
            return config;
        }
        return null;
    }

    @Override
    public boolean save(Object config) {
        Field[] fields;
        if (config == null) {
            return false;
        }
        boolean hasRequire = false;
        Field[] fieldArray = fields = config.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            Require require = field.getAnnotation(Require.class);
            if (require != null) {
                hasRequire = true;
                try {
                    Object result = field.get(config);
                    if (result instanceof IniFile) {
                        IniFile initFile = (IniFile)result;
                        IniFileWriter writer = new IniFileWriter(initFile, new File(this.iniFilePath));
                        writer.write();
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return hasRequire;
    }
}

