/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.config.PreferenceConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;

public class BuffedPreferenceConfiguration
extends PreferenceConfiguration {
    private Map<Class<?>, Object> cache = Collections.synchronizedMap(new HashMap());

    public BuffedPreferenceConfiguration(IPreferenceStore store) {
        super(store);
    }

    @Override
    public <T> T getConfig(Class<T> type) {
        Object config = this.cache.get(type);
        if (config != null && config.getClass() == type) {
            return (T)config;
        }
        T result = super.getConfig(type);
        if (result != null) {
            this.cache.put(type, result);
        }
        return result;
    }

    @Override
    public boolean save(Object config) {
        if (config == null) {
            return false;
        }
        if (super.save(config)) {
            this.cache.put(config.getClass(), config);
        }
        return true;
    }

    public boolean saveAll() {
        for (Object object : this.cache.values()) {
            this.save(object);
        }
        return true;
    }
}

