/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ccconsole;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ccdt.common.ccconsole.CCPacket;
import org.ccdt.common.ccconsole.CCResponsePacket;
import org.ccdt.common.ccconsole.HandShakePacket;
import org.ccdt.common.ccconsole.JSON;
import org.ccdt.common.ccconsole.Tracing;
import org.ccdt.common.utils.ConsoleFactory;
import org.ccdt.transport.packet.Packet;
import org.ccdt.transport.socket.SocketConnection;

public class CCSocketConnection
extends SocketConnection {
    private static int HEAD_NUMBER = 1;

    public CCSocketConnection(Socket socket) throws IOException {
        super(socket);
    }

    public void writePacket(Packet packet) throws IOException {
        String serialized = JSON.serialize((CCPacket)packet);
        if (CCPacket.TRACE) {
            Tracing.writeString("WRITE PACKET: " + serialized);
        }
        Writer writer = this.getWriter();
        writer.write(serialized);
        writer.flush();
    }

    public void writeHandShake(String[] tools) throws IOException {
    }

    public CCPacket readHandShake() throws IOException {
        StringBuffer buffer = new StringBuffer();
        Reader reader = this.getReader();
        if (reader.read() == 62 && reader.read() == 32) {
            HandShakePacket ack = new HandShakePacket();
            return ack;
        }
        throw new IOException("Did not get correct CCConsole handshake: " + buffer.toString());
    }

    public List<Packet> readPacket() throws IOException {
        ArrayList<Packet> packets = new ArrayList<Packet>();
        StringBuffer logBuffer = new StringBuffer();
        int c = -1;
        boolean r = false;
        String len = null;
        Reader reader = this.getReader();
        while (!r && (c = reader.read()) > -1) {
            if (c >= 32 || c == 10 || c == 13) {
                logBuffer.append((char)c);
            }
            boolean bl = r = c == HEAD_NUMBER || c == 10;
        }
        if (c == -1) {
            throw new IOException("The end of the socket stream has been reached");
        }
        String str = this.grabAttrib(logBuffer.toString());
        if (str.length() > 0) {
            ConsoleFactory.showMessage(str, false);
        }
        if (c == HEAD_NUMBER) {
            StringBuffer raw = new StringBuffer();
            StringBuffer buffer = new StringBuffer();
            while ((c = reader.read()) > -1 && c != 58) {
                if (CCPacket.TRACE) {
                    raw.append((char)c);
                }
                buffer.append((char)c);
            }
            len = this.grabAttrib(buffer.toString());
            int length = 0;
            try {
                length = Integer.parseInt(len.trim());
            }
            catch (Exception exception) {
                if (CCPacket.TRACE) {
                    Tracing.writeString("[SOCKET] failed to read content length: " + raw.toString());
                }
                throw new IOException("Failed to parse content length: " + raw.toString());
            }
            char[] message = new char[length];
            int n = 0;
            int off = 0;
            while (n < length) {
                int count = reader.read(message, off + n, length - n);
                if (count < 0) {
                    throw new EOFException();
                }
                n += count;
            }
            if (CCPacket.TRACE) {
                raw.append(message);
                Tracing.writeString("READ PACKET: " + raw.toString());
            }
            Map json = (Map)JSON.read(new String(message));
            json.put("type", "response");
            packets.add(new CCResponsePacket(json));
        }
        return packets;
    }

    String grabAttrib(String str) {
        if (str != null) {
            str = str.replace(CCPacket.PROMPT, "");
        }
        return str;
    }
}

