/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ccconsole;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.ccconsole.CCPacket;
import org.ccdt.common.ccconsole.JSON;
import org.ccdt.transport.packet.Response;

public class CCResponsePacket
extends CCPacket
implements Response {
    public static final String RESPONSE = "response";
    public static final int CODE_OK = 0;
    public static final int CODE_FAILED = 1;
    static final Map<String, Object> failed_attributes = new HashMap<String, Object>();
    public static final CCResponsePacket FAILED;
    private String command;
    private int requestSequence;
    private Map body = Collections.synchronizedMap(new HashMap());
    private volatile int code = 0;

    static {
        Integer value = new Integer(-1);
        failed_attributes.put("seq", value);
        failed_attributes.put("code", 1);
        failed_attributes.put("cmd", "failed");
        failed_attributes.put("type", RESPONSE);
        FAILED = new CCResponsePacket(failed_attributes);
    }

    public CCResponsePacket(int requestSequence, String command) {
        super(RESPONSE);
        if (command == null) {
            throw new IllegalArgumentException("The command string for a response packet cannot be null");
        }
        this.requestSequence = requestSequence;
        this.command = command.intern();
    }

    public CCResponsePacket(Map json) {
        super(json);
        Object bdy;
        Number packetRequestSeq = (Number)json.get("seq");
        this.requestSequence = packetRequestSeq.intValue();
        String packetCommand = (String)json.get("cmd");
        this.command = packetCommand.intern();
        Number packetCode = (Number)json.get("code");
        if (packetCode != null) {
            this.code = packetCode.intValue();
        }
        if ((bdy = json.get("body")) instanceof Map) {
            Map packetBody = (Map)bdy;
            this.body.putAll(packetBody);
        }
    }

    public int getRequestSequence() {
        return this.requestSequence;
    }

    public boolean isResponseFor(String command) {
        return command.equals(this.command);
    }

    public boolean isResponseFor(int requestSequence) {
        return requestSequence == this.requestSequence;
    }

    public Map getBody() {
        return this.body;
    }

    public boolean isSuccess() {
        return this.code == 0;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isRunning() {
        return false;
    }

    public void setRunning(boolean running) {
    }

    @Override
    public Map toJSON() {
        Map json = super.toJSON();
        json.put("seq", new Integer(this.requestSequence));
        json.put("cmd", this.command);
        json.put("code", this.code);
        if (this.body != null && this.body.size() > 0) {
            json.put("body", this.body);
        }
        return json;
    }

    @Override
    public String serialize() {
        StringBuffer buffer = new StringBuffer();
        Map json = this.toJSON();
        JSON.writeValue(json, buffer);
        return buffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Map json = this.toJSON();
        buffer.append("CCResponsePacket: ");
        JSON.writeValue(json, buffer);
        return buffer.toString();
    }
}

