/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ccconsole;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.ccconsole.CCPacket;
import org.ccdt.common.ccconsole.JSON;
import org.ccdt.transport.packet.Request;

public class CCRequestPacket
extends CCPacket
implements Request {
    public static final String REQUEST = "request";
    private final String command;
    private final Map arguments = Collections.synchronizedMap(new HashMap());
    private final Map params = Collections.synchronizedMap(new HashMap());
    private static int currentSequence = 0;
    private final int sequence;

    public CCRequestPacket(String command) {
        super(REQUEST);
        if (command == null) {
            throw new IllegalArgumentException("The request command kind cannot be null");
        }
        this.sequence = CCRequestPacket.nextSequence();
        this.command = command.intern();
    }

    public CCRequestPacket(Map json) {
        super(json);
        if (json == null) {
            throw new IllegalArgumentException("The JSON map for a request packet cannot be null");
        }
        String value = (String)json.get("cmd");
        this.command = value.intern();
        Map packetArguments = (Map)json.get("arguments");
        this.arguments.putAll(packetArguments);
        Number packetSeq = (Number)json.get("seq");
        this.sequence = packetSeq.intValue();
    }

    private static synchronized int nextSequence() {
        return ++currentSequence;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void addAdditionalParam(String key, Object value) {
        this.params.put(key, value);
    }

    public String getCommand() {
        return this.command;
    }

    public Map getArguments() {
        return this.arguments;
    }

    public void setArgument(String key, Object argument) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key cannot be null");
        }
        this.arguments.put(key, argument);
    }

    @Override
    public Map toJSON() {
        Map json = super.toJSON();
        json.put("seq", new Integer(this.sequence));
        json.put("cmd", this.command);
        if (!this.arguments.isEmpty()) {
            json.put("arguments", this.arguments);
        }
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : this.params.entrySet()) {
            json.put(entry2.getKey(), entry2.getValue());
        }
        return json;
    }

    @Override
    public String serialize() {
        StringBuffer buffer = new StringBuffer();
        Map json = this.toJSON();
        JSON.writeValue(json, buffer);
        return "sendrequest " + buffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Map json = this.toJSON();
        buffer.append("CCRequestPacket: ");
        JSON.writeValue(json, buffer);
        return buffer.toString();
    }
}

