/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ccconsole;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ccdt.common.ccconsole.CCCommandPacket;
import org.ccdt.common.ccconsole.CCRequestPacket;
import org.ccdt.common.ccconsole.CCResponsePacket;
import org.ccdt.common.ccconsole.CCTransportService;
import org.ccdt.transport.ConnectSession;
import org.ccdt.transport.Connection;
import org.ccdt.transport.exception.DisconnectedException;
import org.ccdt.transport.exception.TimeoutException;
import org.ccdt.transport.packet.Packet;

public class CCConsole {
    static Connection connection = null;
    private static String host = null;
    private static int port = 0;
    private final ConnectSession session;
    private boolean disconnected = false;
    private static CCConsole console = null;

    public static CCConsole getCCConsole() {
        if (console == null || !console.ready()) {
            console = null;
        }
        return console;
    }

    public static CCConsole getCCConsole(String console_host, int console_port, long timeout) {
        if (console != null) {
            console.disconnect();
            console = null;
        }
        host = console_host;
        port = console_port;
        try {
            ConnectRunnable runnable = new ConnectRunnable(timeout);
            Thread thread = new Thread((Runnable)runnable, "connect runtime");
            thread.setDaemon(true);
            thread.start();
            long start = System.currentTimeMillis();
            do {
                try {
                    if (runnable.exception != null) {
                        thread.interrupt();
                        continue;
                    }
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            } while (thread.isAlive() && System.currentTimeMillis() < start + timeout);
            console = runnable.console;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return console;
    }

    private CCConsole(ConnectSession session) {
        this.session = session;
    }

    public boolean ready() {
        return !this.disconnected;
    }

    public boolean isDisconnected() {
        return !connection.isOpen();
    }

    public void startLogic() {
        CCRequestPacket request = new CCRequestPacket("start-logic");
        console.sendRequestWithoutResp(request);
    }

    public void startLogic(String debugcfg) {
        CCRequestPacket request = new CCRequestPacket("start-logic");
        request.addAdditionalParam("debugcfg", debugcfg);
        console.sendRequestWithoutResp(request);
    }

    public void shutdownRuntime() throws InterruptedException {
        CCRequestPacket request = new CCRequestPacket("shutdownapp");
        if (console != null) {
            console.sendRequestWithoutResp(request);
            Thread.sleep(1000L);
        }
        if (console != null) {
            console.disconnect();
        }
    }

    public void reload(List<String> fileList) {
        CCRequestPacket request = new CCRequestPacket("reload");
        request.addAdditionalParam("modulefiles", fileList);
        console.sendRequestWithoutResp(request);
    }

    public void reloadAll() {
        CCRequestPacket request = new CCRequestPacket("reload");
        ArrayList fileList = new ArrayList();
        request.addAdditionalParam("modulefiles", fileList);
        console.sendRequestWithoutResp(request);
    }

    public String getRuntimeVersion() throws Exception {
        CCRequestPacket request = new CCRequestPacket("getversion");
        CCResponsePacket resp = console.sendRequest(request);
        if (!resp.isSuccess()) {
            throw new Exception("getversion error, result code:" + resp.getCode());
        }
        Map body = resp.getBody();
        return (String)body.get("version");
    }

    public Map getFileInfo() throws Exception {
        CCRequestPacket request = new CCRequestPacket("getfileinfo");
        CCResponsePacket resp = console.sendRequest(request);
        if (!resp.isSuccess()) {
            throw new Exception("Command:getfileinfo error, result code:" + resp.getCode());
        }
        return resp.getBody();
    }

    public Map removeFiles(ArrayList<String> fileList) throws Exception {
        CCRequestPacket request = new CCRequestPacket("remove");
        request.addAdditionalParam("files", fileList);
        CCResponsePacket resp = console.sendRequest(request);
        if (!resp.isSuccess()) {
            throw new Exception("Command:removefile error, result code:" + resp.getCode());
        }
        return resp.getBody();
    }

    public Map getRuntimeIP() throws Exception {
        CCRequestPacket request = new CCRequestPacket("getIP");
        CCResponsePacket resp = console.sendRequest(request);
        if (!resp.isSuccess()) {
            throw new Exception("Command:getruntimeip error, result code:" + resp.getCode());
        }
        return resp.getBody();
    }

    public synchronized void sendCommand(CCCommandPacket command) {
        try {
            this.session.send((Packet)command);
        }
        catch (DisconnectedException de) {
            this.disconnect();
            this.handleException(de.getMessage(), de.getCause() == null ? de : de.getCause());
        }
    }

    public synchronized CCResponsePacket sendRequest(CCRequestPacket request) {
        try {
            this.session.send((Packet)request);
            return (CCResponsePacket)this.session.receiveResponse(request.getSequence(), 3000);
        }
        catch (DisconnectedException de) {
            this.disconnect();
            this.handleException(de.getMessage(), de.getCause() == null ? de : de.getCause());
        }
        catch (TimeoutException te) {
            this.handleException(te.getMessage(), te.getCause() == null ? te : te.getCause());
        }
        return CCResponsePacket.FAILED;
    }

    public void sendRequestWithoutResp(CCRequestPacket request) {
        try {
            this.session.send((Packet)request);
        }
        catch (DisconnectedException disconnectedException) {
            this.disconnect();
        }
    }

    public synchronized void disconnect() {
        this.disconnected = true;
        this.session.dispose();
    }

    private void handleException(String message, Throwable t) {
        throw new RuntimeException(message, t);
    }

    /* synthetic */ CCConsole(ConnectSession connectSession, CCConsole cCConsole) {
        this(connectSession);
    }

    static class ConnectRunnable
    implements Runnable {
        CCConsole console = null;
        long timeout = 0L;
        Exception exception = null;

        ConnectRunnable(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                Exception inner = null;
                do {
                    try {
                        CCTransportService service = new CCTransportService();
                        connection = service.attach(String.valueOf(host) + ":" + port, 5000L, 5000L);
                        ConnectSession session = new ConnectSession(connection, "CCConsole Session");
                        this.console = new CCConsole(session, null);
                    }
                    catch (Exception e) {
                        inner = e;
                    }
                } while (this.console == null && System.currentTimeMillis() < start + this.timeout);
                if (this.console == null) {
                    throw inner;
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

