/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccdt.common.CommonConsole;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.ParameterInfo;

public class CommoniOS {
    public static String[] getDistributionCertificates() {
        final ArrayList certificates = new ArrayList();
        final Pattern pattern = Pattern.compile("\"iPhone Distribution:((\\S)|(\\s))*\"");
        ParameterInfo[] parameters = new ParameterInfo[]{new ParameterInfo("find-identity"), new ParameterInfo("-v"), new ParameterInfo("-p"), new ParameterInfo("codesigning")};
        CommandHelper.executeInSynchronous("security", parameters, null, new CommandHelper.ProcessListener(){

            @Override
            public void readLine(String line) {
                Matcher mathcer = pattern.matcher(line);
                boolean result = mathcer.find();
                if (result) {
                    String content = mathcer.group();
                    certificates.add(content.substring(1, content.length() - 1));
                }
            }

            @Override
            public void processFailed() {
            }

            @Override
            public void processComplete() {
            }
        }, null, false, null);
        String[] array = new String[certificates.size()];
        return certificates.toArray(array);
    }

    public static String[] getTargetsWithProject(String iOSProjectPath) {
        String[] ts;
        File f = new File(String.valueOf(iOSProjectPath) + File.separator + "project.pbxproj");
        if (!f.exists()) {
            return new String[0];
        }
        byte[] buffer = null;
        try {
            FileInputStream in = new FileInputStream(f);
            int size = in.available();
            buffer = new byte[size];
            in.read(buffer);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> targets = new ArrayList<String>();
        String data = new String(buffer);
        Pattern section = Pattern.compile("Begin PBXProject section.*End PBXProject section", 40);
        Matcher sectionResult = section.matcher(data);
        if (!sectionResult.find()) {
            return new String[0];
        }
        Matcher targetsResult = Pattern.compile("targets = \\(.*\\);", 40).matcher(sectionResult.group());
        if (!targetsResult.find()) {
            return new String[0];
        }
        String[] stringArray = ts = targetsResult.group().split(",");
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher nameResult = Pattern.compile("/\\*((\\S)|(\\s))*\\*/", 40).matcher(line);
            if (nameResult.find()) {
                String name = nameResult.group();
                name = name.substring(2, nameResult.group().length() - 2);
                targets.add(name.trim());
            }
            ++n2;
        }
        String[] array = new String[targets.size()];
        return targets.toArray(array);
    }

    public static boolean checkXCodeVersion() {
        String version = CommoniOS.getXCodeVersion();
        if (version.length() == 0) {
            return false;
        }
        String[] vers = version.split("\\.");
        if (vers.length == 0) {
            return false;
        }
        int number = Integer.parseInt(vers[0]);
        return number >= 5;
    }

    public static String getXCodeBuild() {
        return CommandHelper.getPath("xcodebuild");
    }

    public static String getXCodeVersion() {
        String xcode = CommoniOS.getXCodeBuild();
        if (xcode.length() == 0) {
            return "";
        }
        ArrayList<String> infos = new ArrayList<String>();
        CommonConsole.getInstance().commandInSynchronous(xcode, new ParameterInfo[]{new ParameterInfo(1, "-version")}, null, infos);
        if (infos.size() == 0) {
            return "";
        }
        String[] verInfo = infos.get(0).split(" ");
        if (verInfo.length == 0 || !verInfo[0].equals("Xcode")) {
            return "";
        }
        return verInfo[1];
    }

    public static String getXCRun() {
        return CommandHelper.getPath("xcrun");
    }
}

