/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.ParameterInfo;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.common.utils.WinRegistry;

public class CommonPython {
    public static String getPython() {
        String path = PathManager.instance.getPythonPath();
        if (path.length() == 0) {
            return "";
        }
        if (SystemInfo.isWindows) {
            path = String.valueOf(path) + File.separator + "python.exe";
        } else if (SystemInfo.isMac) {
            path = String.valueOf(path) + File.separator + "python";
        }
        return path;
    }

    public static boolean checkPython() {
        String path = CommonPython.getPython();
        if (path.length() == 0) {
            return false;
        }
        File f = new File(path);
        return f.exists();
    }

    public static float getPythonVersion(String pythonPath) {
        if (pythonPath == null || pythonPath.length() == 0) {
            return 0.0f;
        }
        File f = new File(pythonPath);
        if (!f.exists()) {
            return 0.0f;
        }
        final ArrayList vers = new ArrayList();
        CommandHelper.executeInSynchronous(pythonPath, new ParameterInfo[]{new ParameterInfo("-V")}, null, new CommandHelper.ProcessListener(){

            @Override
            public void readLine(String line) {
                String[] data = line.split(" ");
                String[] num = data[1].split("\\.");
                vers.add(Float.valueOf(Float.parseFloat(String.valueOf(num[0]) + "." + num[1])));
            }

            @Override
            public void processFailed() {
            }

            @Override
            public void processComplete() {
            }
        }, null, false, null);
        return ((Float)vers.get(0)).floatValue();
    }

    public static List<String[]> loadSystemPython() {
        HashMap<String, String[]> pythons = new HashMap<String, String[]>();
        if (SystemInfo.isWindows) {
            if (SystemInfo.is64Bit) {
                CommonPython.readPythonPathFromReg("SOFTWARE\\Wow6432Node\\Python\\PythonCore", pythons);
            }
            CommonPython.readPythonPathFromReg("SOFTWARE\\Python\\PythonCore", pythons);
        }
        CommonPython.readPythonPathFromPath(pythons);
        return new ArrayList<String[]>(pythons.values());
    }

    private static void readPythonPathFromPath(final HashMap<String, String[]> ps) {
        if (ps == null) {
            return;
        }
        String cmd = "which";
        if (SystemInfo.isWindows) {
            cmd = "where";
        }
        CommandHelper.executeInSynchronous(cmd, new ParameterInfo[]{new ParameterInfo("python")}, null, new CommandHelper.ProcessListener(){

            @Override
            public void readLine(String line) {
                float ver;
                File f = new File(line);
                if (f.exists() && (ver = CommonPython.getPythonVersion(f.getAbsolutePath())) >= 2.7f && ver < 3.0f) {
                    ps.put(f.getAbsolutePath(), new String[]{"", f.getParent()});
                }
            }

            @Override
            public void processFailed() {
            }

            @Override
            public void processComplete() {
            }
        }, null, false, null);
    }

    private static void readPythonPathFromReg(String reg, HashMap<String, String[]> ps) {
        try {
            List<String> values = WinRegistry.readStringSubKeys(-2147483646, reg);
            if (values == null) {
                return;
            }
            int i = 0;
            while (i < values.size()) {
                try {
                    float ver;
                    File f;
                    String kp = String.valueOf(reg) + "\\" + values.get(i) + "\\InstallPath";
                    String path = WinRegistry.readString(-2147483646, kp, "");
                    if (path != null && (f = new File(String.valueOf(path) + File.separator + "python.exe")).exists() && (ver = CommonPython.getPythonVersion(f.getAbsolutePath())) >= 2.7f && ver < 3.0f) {
                        ps.put(f.getAbsolutePath(), new String[]{"", f.getParent()});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

