/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common;

import java.io.File;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.manager.ProjectManager;
import org.ccdt.common.model.CocosProjectConfig;
import org.eclipse.core.resources.IProject;

public class CommonProject {
    public static boolean checkHasNative(IProject proj) {
        if (proj == null) {
            return false;
        }
        CocosProjectConfig cocosProjectConfig = ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(proj)).getConfig(CocosProjectConfig.class);
        return cocosProjectConfig.isHasNative();
    }

    public static String getNativeProjectPathByPlatform(IProject proj, PlatformMode mode) {
        if (proj == null || mode == null) {
            return "";
        }
        if (!CommonProject.checkHasNative(proj)) {
            return "";
        }
        String root = CommonProject.getProjectPath(proj);
        String frameworkPath = String.valueOf(root) + File.separator + "frameworks";
        String platformPath = String.valueOf(frameworkPath) + File.separator + "runtime-src" + File.separator + mode.getValue();
        File f = new File(platformPath);
        if (!f.exists()) {
            return "";
        }
        return platformPath;
    }

    public static String getPublishPathByPlatform(IProject proj, PlatformMode mode) {
        if (proj == null || mode == null) {
            return "";
        }
        String pf = "";
        switch (mode) {
            case IOS_MAC_PLATFORM: {
                pf = "ios";
                break;
            }
            case ANDROID_PLATFORM: {
                pf = "android";
                break;
            }
            case WIN32_PLATFORM: {
                pf = "win32";
                break;
            }
        }
        String root = CommonProject.getProjectPath(proj);
        String publish = String.valueOf(root) + File.separator + "publish" + File.separator + pf;
        return publish;
    }

    public static String getProjectPath(IProject proj) {
        if (proj == null) {
            return "";
        }
        return proj.getProject().getLocation().toString();
    }

    public static String getProjectName(IProject proj) {
        if (proj == null) {
            return "";
        }
        return proj.getProject().getName();
    }

    public static int checkVersionBeforeAddNativeSource(IProject project) {
        File projRoot = project.getLocation().toFile();
        String projTempVer = ProjectManager.getProjectTemplateVersion(projRoot);
        String engineTempVer = null;
        if (ProjectManager.isCocosJSProject(projRoot)) {
            engineTempVer = ProjectManager.getJSEngineTemplateVersion();
        } else if (ProjectManager.isCocosLuaProject(projRoot)) {
            engineTempVer = ProjectManager.getLuaEngineTemplateVersion();
        }
        if (projTempVer == null && engineTempVer == null) {
            return CheckVersionResult.Unknown.getValue();
        }
        if (projTempVer == null && engineTempVer != null) {
            return CheckVersionResult.Lower.getValue();
        }
        if (projTempVer != null && engineTempVer == null) {
            return CheckVersionResult.Higher.getValue();
        }
        String[] projvers = projTempVer.split("\\.");
        String[] enginevers = engineTempVer.split("\\.");
        int i = 0;
        while (i < enginevers.length && i < projvers.length) {
            int v1 = -1;
            int v2 = -1;
            try {
                v1 = Integer.parseInt(projvers[i]);
            }
            catch (NumberFormatException numberFormatException) {
                v1 = -1;
            }
            try {
                v2 = Integer.parseInt(enginevers[i]);
            }
            catch (NumberFormatException numberFormatException) {
                v2 = -1;
            }
            if (v1 < v2) {
                return CheckVersionResult.Lower.getValue();
            }
            if (v1 > v2) {
                return CheckVersionResult.Higher.getValue();
            }
            ++i;
        }
        if (projvers.length > enginevers.length) {
            return CheckVersionResult.Higher.getValue();
        }
        if (projvers.length < enginevers.length) {
            return CheckVersionResult.Lower.getValue();
        }
        return CheckVersionResult.Equal.getValue();
    }

    public static enum CheckVersionResult {
        Equal(1),
        Higher(2),
        Lower(3),
        Unknown(4);

        private int value;

        private CheckVersionResult(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum PlatformMode {
        IOS_MAC_PLATFORM("proj.ios_mac"),
        ANDROID_PLATFORM("proj.android"),
        WIN32_PLATFORM("proj.win32");

        private String value = "";

        private PlatformMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

