/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common;

import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.ccdt.common.favorite.ProposalServiceImpl;
import org.ccdt.common.manager.ResourceManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ProposalService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CommonPlugin
extends AbstractUIPlugin
implements IWorkbenchListener {
    public static final String PLUGIN_ID = "org.ccdt.common";
    public static final String EDITOR_ID = "org.ccdt.js.ui.editor.JSEditor";
    private static CommonPlugin plugin;
    String oldEditorID;
    public static ProposalServiceImpl proposalService;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Properties prop = new Properties();
        try {
            prop.load(CommonPlugin.class.getResourceAsStream("log4j.properties"));
        }
        catch (IOException iOException) {}
        PropertyConfigurator.configure((Properties)prop);
        proposalService = new ProposalServiceImpl();
        ProposalService.register((ProposalService)proposalService);
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("*.js");
        if (editorDescriptor != null) {
            this.oldEditorID = editorDescriptor.getId();
            PlatformUI.getWorkbench().getEditorRegistry().setDefaultEditor("*.js", EDITOR_ID);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (proposalService != null) {
            proposalService.save();
        }
        ResourceManager.instance.dispose();
        super.stop(context);
    }

    public static CommonPlugin getDefault() {
        return plugin;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        PlatformUI.getWorkbench().getEditorRegistry().setDefaultEditor("*.js", this.oldEditorID);
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public static void logError(String message, Throwable throwable) {
        Status status = new Status(4, PLUGIN_ID, message, throwable);
        CommonPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void logWarning(String message) {
        Status status = new Status(2, PLUGIN_ID, message);
        CommonPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void logWarning(String message, Throwable throwable) {
        Status status = new Status(2, PLUGIN_ID, message, throwable);
        CommonPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

