/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.ParameterInfo;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.common.utils.WinRegistry;

public class CommonJDK {
    private CommonJDK() {
    }

    public static String getJDK() {
        return PathManager.instance.getJDKPath();
    }

    public static boolean checkJDK() {
        String path = PathManager.instance.getJDKPath();
        return path.length() != 0;
    }

    public static List<String[]> loadSystemJDK() {
        TreeMap<String, String[]> sdkMap = new TreeMap<String, String[]>();
        if (SystemInfo.isWindows) {
            if (SystemInfo.is64Bit) {
                CommonJDK.readRegPathToMap("SOFTWARE\\Wow6432Node\\JavaSoft\\Java Development Kit", sdkMap);
            }
            CommonJDK.readRegPathToMap("SOFTWARE\\JavaSoft\\Java Development Kit", sdkMap);
        }
        CommonJDK.readRegPathFromPathToMap(sdkMap);
        return new ArrayList<String[]>(sdkMap.values());
    }

    private static void readRegPathToMap(String regKey, TreeMap<String, String[]> sdkMap) {
        try {
            List<String> values = WinRegistry.readStringSubKeys(-2147483646, regKey);
            if (values == null) {
                return;
            }
            int i = 0;
            while (i < values.size()) {
                String jdkVersionKey = String.valueOf(regKey) + "\\" + values.get(i);
                try {
                    File f;
                    String javaHome = WinRegistry.readString(-2147483646, jdkVersionKey, "JavaHome");
                    if (javaHome != null && (f = new File(String.valueOf(javaHome) + File.separator + "bin" + File.separator + "javac.exe")).exists()) {
                        sdkMap.put(f.getAbsolutePath(), new String[]{"", f.getParent()});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readRegPathFromPathToMap(final TreeMap<String, String[]> sdkMap) {
        String which = "which";
        if (SystemInfo.isWindows) {
            which = "where";
        }
        CommandHelper.executeInSynchronous(which, new ParameterInfo[]{new ParameterInfo("javac")}, null, new CommandHelper.ProcessListener(){

            @Override
            public void readLine(String line) {
                File f = new File(line);
                if (f.exists()) {
                    sdkMap.put(f.getAbsolutePath(), new String[]{"", f.getParent()});
                }
            }

            @Override
            public void processFailed() {
            }

            @Override
            public void processComplete() {
            }
        }, null, false, null);
    }
}

