/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common;

import java.io.File;
import java.util.ArrayList;
import org.ccdt.common.CommonConstants;
import org.ccdt.common.CommonPython;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.ParameterInfo;
import org.ccdt.common.utils.SystemInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CommonConsole {
    private static CommonConsole commonConsole = null;

    private CommonConsole() {
    }

    public static CommonConsole getInstance() {
        if (commonConsole == null) {
            commonConsole = new CommonConsole();
        }
        return commonConsole;
    }

    public float getConsoleVersion() {
        String console = this.getEngineConsolePath();
        File f = new File(console);
        if (!f.exists()) {
            return 0.0f;
        }
        ArrayList<String> res = new ArrayList<String>();
        this.python(new ParameterInfo[]{new ParameterInfo(0, console), new ParameterInfo("-v")}, null, res, true);
        if (res.size() == 0) {
            return 0.0f;
        }
        try {
            float version = Float.parseFloat(res.get(0));
            return version;
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    private String getEngineConsolePath() {
        final ArrayList id = new ArrayList();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                IPerspectiveDescriptor PerspectiveDescriptor = activePage.getPerspective();
                id.add(PerspectiveDescriptor.getId());
            }
        });
        if (((String)id.get(0)).length() == 0) {
            return "";
        }
        String engine = "";
        if (((String)id.get(0)).equals("org.ccdt.lua.ui.perspectives.CocosPerspectives")) {
            engine = PathManager.instance.getLUAEnginePath();
        } else if (((String)id.get(0)).equals("org.ccdt.js.ui.perspectives.CocosPerspective")) {
            engine = PathManager.instance.getJSEnginePath();
        }
        if (engine.length() == 0) {
            return "";
        }
        File f = new File(String.valueOf(engine) + File.separator + CommonConstants.CONSOLE_PATH + File.separator + "cocos.py");
        if (!f.exists()) {
            return "";
        }
        return f.getAbsolutePath();
    }

    public boolean commandInSynchronous(String cmd, ParameterInfo[] parameters, String[] env, final ArrayList<String> res) {
        if (cmd == null || cmd.length() == 0) {
            return false;
        }
        final Result success = new Result(false);
        CommandHelper.executeInSynchronous(cmd, parameters, env, new CommandHelper.ProcessListener(){

            @Override
            public void readLine(String line) {
                if (res != null) {
                    res.add(line);
                }
            }

            @Override
            public void processFailed() {
                success.setSuccess(false);
            }

            @Override
            public void processComplete() {
                success.setSuccess(true);
            }
        }, null, false, null);
        return success.isSuccess();
    }

    public boolean command(String cmd, ParameterInfo[] parameters, String[] env, final ArrayList<String> res) {
        if (cmd == null || cmd.length() == 0) {
            return false;
        }
        final Result success = new Result(false);
        CommandHelper.execute(cmd, parameters, env, new CommandHelper.ProcessListener(){

            @Override
            public void readLine(String line) {
                if (res != null) {
                    res.add(line);
                }
            }

            @Override
            public void processFailed() {
                success.setSuccess(false);
            }

            @Override
            public void processComplete() {
                success.setSuccess(true);
            }
        }, null, true);
        return success.isSuccess();
    }

    public boolean python(ParameterInfo[] script, String[] env, ArrayList<String> res, boolean synchronous) {
        if (script == null || script.length == 0) {
            return false;
        }
        String python = CommonPython.getPython();
        if (python.length() == 0) {
            return false;
        }
        if (synchronous) {
            return this.commandInSynchronous(python, script, env, res);
        }
        return this.command(python, script, env, res);
    }

    public boolean python(ParameterInfo[] script, String[] env, ArrayList<String> res) {
        return this.python(script, env, res, false);
    }

    public boolean chmod(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        String cmd = "chmod";
        return this.command(cmd, new ParameterInfo[]{new ParameterInfo(1, "+x"), new ParameterInfo(0, name)}, null, null);
    }

    public boolean which(String name, ArrayList<String> res) {
        if (name == null || name.length() == 0) {
            return false;
        }
        String cmd = "which";
        if (SystemInfo.isWindows) {
            cmd = "where";
        }
        return this.command(cmd, new ParameterInfo[]{new ParameterInfo(1, name)}, null, res);
    }

    public boolean compile(String path, String platform, String mode, ParameterInfo[] others, String[] env) {
        if (path == null || path.length() == 0 || platform == null || platform.length() == 0 || mode == null || mode.length() == 0) {
            return false;
        }
        ArrayList<ParameterInfo> cmd = new ArrayList<ParameterInfo>();
        cmd.add(new ParameterInfo(0, this.getEngineConsolePath()));
        cmd.add(new ParameterInfo(1, "compile"));
        cmd.add(new ParameterInfo(1, "-s"));
        cmd.add(new ParameterInfo(0, path));
        cmd.add(new ParameterInfo(1, "-p"));
        cmd.add(new ParameterInfo(1, platform));
        cmd.add(new ParameterInfo(1, "-m"));
        cmd.add(new ParameterInfo(1, mode));
        if (others != null) {
            ParameterInfo[] parameterInfoArray = others;
            int n = others.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterInfo o = parameterInfoArray[n2];
                cmd.add(o);
                ++n2;
            }
        }
        return this.python(cmd.toArray(new ParameterInfo[cmd.size()]), env, null);
    }

    public boolean create(String name, String packageName, String path, String language, boolean hasNative) {
        return this.create(name, packageName, null, path, language, hasNative);
    }

    public boolean create(String name, String packageName, String bundleId, String path, String language, boolean hasNative) {
        if (name == null || name.length() == 0 || packageName == null || packageName.length() == 0 || path == null || path.length() == 0 || language == null || language.length() == 0) {
            return false;
        }
        ArrayList<ParameterInfo> cmd = new ArrayList<ParameterInfo>();
        cmd.add(new ParameterInfo(0, this.getEngineConsolePath()));
        cmd.add(new ParameterInfo(1, "new"));
        cmd.add(new ParameterInfo(1, name));
        cmd.add(new ParameterInfo(1, "-p"));
        cmd.add(new ParameterInfo(1, packageName));
        if (bundleId != null) {
            cmd.add(new ParameterInfo(1, "--ios-bundleid"));
            cmd.add(new ParameterInfo(1, bundleId));
            cmd.add(new ParameterInfo(1, "--mac-bundleid"));
            cmd.add(new ParameterInfo(1, bundleId));
        }
        cmd.add(new ParameterInfo(1, "-l"));
        cmd.add(new ParameterInfo(1, language));
        cmd.add(new ParameterInfo(1, "-d"));
        cmd.add(new ParameterInfo(0, path));
        cmd.add(new ParameterInfo(1, "-t"));
        cmd.add(new ParameterInfo(1, "runtime"));
        if (!hasNative) {
            cmd.add(new ParameterInfo(1, "--no-native"));
        }
        return this.python(cmd.toArray(new ParameterInfo[cmd.size()]), null, null);
    }

    private class Result {
        private boolean isSuccess;

        public Result(boolean isSuccess) {
            this.isSuccess = isSuccess;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public void setSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
        }
    }
}

