/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ccdt.common.CommonJDK;
import org.ccdt.common.manager.PathManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommonAndroid {
    private static CommonAndroid commonAndroid = null;

    private CommonAndroid() {
    }

    public static CommonAndroid getInstance() {
        if (commonAndroid == null) {
            commonAndroid = new CommonAndroid();
        }
        return commonAndroid;
    }

    public String getAndroidSDK() {
        return PathManager.instance.getAndroidSDKPath();
    }

    public String getAndroidNDK() {
        return PathManager.instance.getAndroidNDKPath();
    }

    public String getAnt() {
        String path = PathManager.instance.getANTPath();
        File antfile = new File(path);
        String[] fs = antfile.list();
        if (fs == null) {
            return "";
        }
        String[] stringArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            String fn = stringArray[n2];
            if (fn.equals("ant")) {
                return path;
            }
            ++n2;
        }
        return String.valueOf(path) + File.separator + "bin";
    }

    public boolean checkAndroidSDK(String p) {
        if (p.length() == 0) {
            return false;
        }
        File f = new File(p);
        if (!f.isDirectory()) {
            return false;
        }
        File platforms = new File(String.valueOf(p) + File.separator + "platforms");
        if (!platforms.isDirectory()) {
            return false;
        }
        return platforms.list().length != 0;
    }

    public boolean checkAndroidNDK(String p) {
        if (p.length() == 0) {
            return false;
        }
        File f = new File(p);
        if (!f.isDirectory()) {
            return false;
        }
        File ndkbuild = new File(String.valueOf(p) + File.separator + "ndk-build");
        if (!ndkbuild.exists()) {
            return false;
        }
        File toolchains = new File(String.valueOf(p) + File.separator + "toolchains");
        if (!toolchains.exists()) {
            return false;
        }
        String[] fs = toolchains.list();
        return fs.length != 0;
    }

    public boolean checkAnt(String p) {
        File bin;
        if (p.length() == 0) {
            return false;
        }
        File f = new File(p);
        if (!f.isDirectory()) {
            return false;
        }
        File ant = new File(String.valueOf(p) + File.separator + "ant");
        return ant.exists() || (bin = new File(String.valueOf(p) + File.separator + "bin" + File.separator + "ant")).exists();
    }

    public boolean checkSharedObject(IProject proj) {
        if (proj == null) {
            return false;
        }
        String p = proj.getProject().getLocation().toString();
        if (p.length() == 0) {
            return false;
        }
        File f = new File(p);
        if (!f.isDirectory()) {
            return false;
        }
        File manifest = new File(String.valueOf(p) + File.separator + "frameworks" + File.separator + "runtime-src" + File.separator + "proj.android" + File.separator + "AndroidManifest.xml");
        if (!manifest.exists()) {
            return false;
        }
        Document document = null;
        try {
            FileInputStream is = new FileInputStream(manifest);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String sharedObjectName = "";
        Element root = document.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("application");
        int i = 0;
        while (i < nodes.getLength()) {
            Element ele = (Element)nodes.item(i);
            NodeList metadatas = ele.getElementsByTagName("meta-data");
            int j = 0;
            while (j < metadatas.getLength()) {
                Element metadata = (Element)metadatas.item(j);
                String name = metadata.getAttribute("android:name");
                if (name.equals("android.app.lib_name")) {
                    sharedObjectName = metadata.getAttribute("android:value");
                }
                ++j;
            }
            ++i;
        }
        if (sharedObjectName.length() == 0) {
            return false;
        }
        File libs = new File(String.valueOf(p) + File.separator + "frameworks" + File.separator + "runtime-src" + File.separator + "proj.android" + File.separator + "libs");
        if (!libs.isDirectory()) {
            return false;
        }
        sharedObjectName = "lib" + sharedObjectName + ".so";
        String[] fs = libs.list();
        boolean res = false;
        int i2 = 0;
        while (i2 < fs.length) {
            File platform = new File(String.valueOf(libs.getPath()) + File.separator + fs[i2]);
            if (platform.isDirectory()) {
                String[] sfs = platform.list();
                int j = 0;
                while (j < sfs.length) {
                    if (sharedObjectName.equals(sfs[j])) {
                        res = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return res;
    }

    public boolean checkProjectPublishEnv(IProject proj) {
        if (proj == null) {
            return false;
        }
        String ant = this.getAnt();
        String sdk = this.getAndroidSDK();
        String ndk = this.getAndroidNDK();
        String jdk = CommonJDK.getJDK();
        if (ant.length() == 0 || sdk.length() == 0 || jdk.length() == 0) {
            return false;
        }
        boolean so = this.checkSharedObject(proj);
        return so || ndk.length() != 0;
    }

    public String[] getSystemEnvironment() {
        Map<String, String> m = System.getenv();
        String path = System.getenv("PATH");
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.putAll(m);
        String sdkPath = this.getAndroidSDK();
        String ndkPath = this.getAndroidNDK();
        String antPath = this.getAnt();
        String jdkPath = CommonJDK.getJDK();
        jdkPath = jdkPath.indexOf(" ") > -1 ? "\"" + jdkPath + "\"" + ";" : String.valueOf(jdkPath) + ";";
        hm.put("ANDROID_SDK_ROOT", sdkPath);
        hm.put("NDK_ROOT", ndkPath);
        hm.put("ANT_ROOT", antPath);
        hm.put("Path", String.valueOf(jdkPath) + path);
        ArrayList<String> env = new ArrayList<String>();
        for (String key : hm.keySet()) {
            String value = (String)hm.get(key);
            env.add(String.format("%s=%s", key, value));
        }
        String[] se = new String[env.size()];
        return env.toArray(se);
    }

    public IDevice[] getAndroidDevices() {
        String ANDROID_SDK_ROOT = this.getAndroidSDK();
        String adb = String.valueOf(ANDROID_SDK_ROOT) + "/platform-tools/adb";
        try {
            AndroidDebugBridge.init((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {}
        IDevice[] devices = new IDevice[]{};
        try {
            this.waitDeviceConnect(adb);
            devices = this.getDevice(adb);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return devices;
    }

    private void waitDeviceConnect(String adb) throws CoreException {
        AndroidDebugBridge bridge = AndroidDebugBridge.createBridge();
        if (!bridge.isConnected()) {
            Process p = DebugPlugin.exec((String[])new String[]{adb, "devices"}, null);
            try {
                p.waitFor();
            }
            catch (Throwable throwable) {}
        }
        int count = 0;
        while (!bridge.hasInitialDeviceList()) {
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
                ++count;
            }
            catch (InterruptedException interruptedException) {}
            if (count > 15) break;
        }
    }

    private IDevice[] getDevice(String adb) throws CoreException {
        IDevice[] devices = new IDevice[]{};
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null) {
            return devices;
        }
        devices = bridge.getDevices();
        if (devices.length == 0) {
            try {
                Process p = DebugPlugin.exec((String[])new String[]{adb, "kill-server"}, null);
                p.waitFor();
                p = DebugPlugin.exec((String[])new String[]{adb, "devices"}, null);
                p.waitFor();
            }
            catch (Throwable throwable) {}
            devices = bridge.getDevices();
        }
        return devices;
    }
}

