/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.validator;

import com.boothen.jsonedit.core.util.JsonCharUtility;
import com.boothen.jsonedit.core.util.reader.JsonFileReader;
import com.boothen.jsonedit.core.util.reader.JsonReaderException;
import com.boothen.jsonedit.validator.JsonValidationException;
import com.boothen.jsonedit.validator.Location;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTextValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JsonTextValidator.class);
    private final JsonFileReader parser;
    private final String markerId;
    public static final String KEY = "key";
    public static final String VIOLATION = "violation";

    public JsonTextValidator(IFile file, String markerId) throws CoreException {
        this.parser = new JsonFileReader(file);
        this.markerId = markerId;
    }

    public JsonTextValidator(File file) throws FileNotFoundException {
        this.parser = new JsonFileReader(file);
        this.markerId = null;
    }

    public void parse() {
        LOG.info("Validating JSON file");
        try {
            char current = this.parser.getNextClean();
            if (current == '{') {
                this.doJsonObject();
            } else if (current == '[') {
                this.doJsonArray();
            } else {
                this.reportProblemEndValidation("JSON should begin with { or [", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
            }
            if (this.parser.getCurrent() != '\uffff') {
                this.reportProblemEndValidation("Unexpected character", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
            }
        }
        catch (JsonValidationException jsonValidationException) {
        }
        catch (JsonReaderException jsonReaderException) {
            this.reportProblem("Unexpected end of file", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
    }

    private void doJsonObject() throws JsonReaderException, JsonValidationException {
        char ch;
        do {
            if ((ch = this.parser.getNextClean()) == '}' && this.parser.getPrevious() != ',') {
                this.parser.getNextClean();
                break;
            }
            if (ch != '\"') {
                this.reportProblemEndValidation("JSON key should begin with \"", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
            }
            this.doJsonKey();
            ch = this.parser.getNextClean();
            if (ch != ':') {
                this.reportProblemEndValidation("Expected colon key/value delimitor", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
            }
            if ((ch = this.parser.getNextClean()) == '{') {
                this.doJsonObject();
            } else if (ch == '[') {
                this.doJsonArray();
            } else if (ch == 'n') {
                this.doJsonNull();
            } else if (ch == '\"') {
                this.doJsonValue();
            } else if (ch == 't') {
                this.doJsonTrueValue();
            } else if (ch == 'f') {
                this.doJsonFalseValue();
            } else if (Character.isDigit(ch) || ch == '-') {
                this.doJsonNumber();
            } else {
                this.reportProblemEndValidation("Expected JSON value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
            }
            if (this.parser.getCurrent() == ',') continue;
            if (this.parser.getCurrent() == '}' && this.parser.getPrevious() != ',') {
                this.parser.getNextClean();
                break;
            }
            this.reportProblemEndValidation("Unexpected object character:" + ch, new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        } while (ch != '\uffff');
    }

    private void doJsonArray() throws JsonReaderException, JsonValidationException {
        char ch;
        do {
            if ((ch = this.parser.getNextClean()) == ']' && this.parser.getPrevious() != ',') {
                this.parser.getNextClean();
                break;
            }
            if (ch == '{') {
                this.doJsonObject();
            } else if (ch == '[') {
                this.doJsonArray();
            } else if (ch == 'n') {
                this.doJsonNull();
            } else if (ch == '\"') {
                this.doJsonValue();
            } else if (ch == 't') {
                this.doJsonTrueValue();
            } else if (ch == 'f') {
                this.doJsonFalseValue();
            } else if (Character.isDigit(ch) || ch == '-') {
                this.doJsonNumber();
            } else {
                this.reportProblemEndValidation("Expected JSON value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
            }
            ch = this.parser.getCurrent();
            if (ch == ',') continue;
            if (ch == ']' && this.parser.getPrevious() != ',') {
                this.parser.getNextClean();
                break;
            }
            this.reportProblemEndValidation("Unexpected array character:" + ch, new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        } while (ch != '\uffff');
    }

    private void doJsonTrueValue() throws JsonReaderException, JsonValidationException {
        char ch = this.parser.getNextChar();
        if (ch != 'r') {
            this.reportProblemEndValidation("Expect true value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if ((ch = this.parser.getNextChar()) != 'u') {
            this.reportProblemEndValidation("Expect true value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if ((ch = this.parser.getNextChar()) != 'e') {
            this.reportProblemEndValidation("Expect true value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if (JsonCharUtility.isNotClosed((char)(ch = this.parser.getNextClean()))) {
            this.reportProblemEndValidation("Expected end value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
    }

    private void doJsonFalseValue() throws JsonReaderException, JsonValidationException {
        char ch = this.parser.getNextChar();
        if (ch != 'a') {
            this.reportProblemEndValidation("Expect true value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if ((ch = this.parser.getNextChar()) != 'l') {
            this.reportProblemEndValidation("Expect true value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if ((ch = this.parser.getNextChar()) != 's') {
            this.reportProblemEndValidation("Expect true value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if ((ch = this.parser.getNextChar()) != 'e') {
            this.reportProblemEndValidation("Expect true value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if (JsonCharUtility.isNotClosed((char)(ch = this.parser.getNextClean()))) {
            this.reportProblemEndValidation("Expected end value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
    }

    private void doJsonNull() throws JsonReaderException, JsonValidationException {
        char ch = this.parser.getNextChar();
        if (ch != 'u') {
            this.reportProblemEndValidation("Expect null value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if ((ch = this.parser.getNextChar()) != 'l') {
            this.reportProblemEndValidation("Expect null value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if ((ch = this.parser.getNextChar()) != 'l') {
            this.reportProblemEndValidation("Expect null value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
        if (JsonCharUtility.isNotClosed((char)(ch = this.parser.getNextClean()))) {
            this.reportProblemEndValidation("Expected end value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        }
    }

    private void doJsonValue() throws JsonReaderException, JsonValidationException {
        char ch;
        do {
            if ((ch = this.parser.getNextChar()) == '\uffff') {
                this.reportProblemEndValidation("Expected quotation", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
                break;
            }
            if (ch != '\"' || this.parser.getPrevious() == '\\') continue;
            ch = this.parser.getNextClean();
            break;
        } while (ch != '\uffff');
    }

    private void doJsonNumber() throws JsonReaderException, JsonValidationException {
        char ch;
        boolean decimalPointSet = false;
        boolean exponentialSet = false;
        boolean waitingOnExponential = false;
        do {
            if (Character.isDigit(ch = this.parser.getNextChar())) {
                waitingOnExponential = false;
                continue;
            }
            if (JsonCharUtility.isClosed((char)ch) && !waitingOnExponential) break;
            if (!decimalPointSet && ch == '.') {
                decimalPointSet = true;
                continue;
            }
            if (!(exponentialSet || ch != 'e' && ch != 'E')) {
                exponentialSet = true;
                waitingOnExponential = true;
                continue;
            }
            if ((ch == '+' || ch == '-') && (this.parser.getPrevious() == 'e' || this.parser.getPrevious() == 'E')) continue;
            if (JsonCharUtility.isNotWhiteSpace((char)ch)) {
                this.reportProblemEndValidation("Value " + ch + " not expected here", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
            }
            if (!JsonCharUtility.isNotClosed((char)(ch = this.parser.getNextClean()))) break;
            this.reportProblemEndValidation("Expected end value", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
            break;
        } while (ch != '\uffff');
    }

    private void doJsonKey() throws JsonReaderException, JsonValidationException {
        char ch;
        do {
            if ((ch = this.parser.getNextChar()) != '\uffff') continue;
            this.reportProblemEndValidation("Invalid JSON key, no closing \"", new Location(this.parser.getIFile(), "", this.parser.getPosition()), 0, true);
        } while ((ch != '\"' || this.parser.getPrevious() == '\\') && ch != '\uffff');
    }

    public void reportProblem(String msg, Location loc, int violation, boolean isError) {
        try {
            IMarker marker = loc.file.createMarker(this.markerId);
            marker.setAttribute("message", (Object)msg);
            marker.setAttribute("charStart", loc.charStart);
            marker.setAttribute("charEnd", loc.charEnd);
            marker.setAttribute("severity", isError ? 2 : 1);
            marker.setAttribute(KEY, (Object)loc.key);
            marker.setAttribute(VIOLATION, violation);
        }
        catch (CoreException coreException) {}
    }

    public void reportProblemEndValidation(String msg, Location loc, int violation, boolean isError) throws JsonValidationException {
        this.reportProblem(msg, loc, violation, isError);
        throw new JsonValidationException();
    }
}

