/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.jsbinding.transport;

import java.math.BigDecimal;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ccdt.debug.internal.jsbinding.d;
import org.ccdt.debug.internal.jsbinding.transport.JBPacket;

public final class JSON {
    static boolean TRACE = false;
    public static final String LINE_FEED = "\r\n";

    public static void setTracing(boolean bl) {
        TRACE = bl;
    }

    private JSON() {
    }

    public static void writeKeyValue(String string, Object object, StringBuffer stringBuffer) {
        JSON.writeString(string, stringBuffer);
        stringBuffer.append(':');
        JSON.writeValue(object, stringBuffer);
    }

    public static void writeValue(Object object, StringBuffer stringBuffer) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof Boolean || object instanceof Number) {
            stringBuffer.append(object.toString());
        } else if (object instanceof String) {
            JSON.writeString((String)object, stringBuffer);
        } else if (object instanceof Collection) {
            JSON.a((Collection)object, stringBuffer);
        } else if (object instanceof Map) {
            JSON.writeObject((Map)object, stringBuffer);
        }
    }

    public static void writeString(String string, StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            switch (c2) {
                case '\"': 
                case '/': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                default: {
                    if (Character.isISOControl(c2)) {
                        stringBuffer.append("\\u");
                        String string2 = Integer.toHexString(c2);
                        int n4 = string2.length();
                        while (n4 < 4) {
                            stringBuffer.append('0');
                            ++n4;
                        }
                        stringBuffer.append(string2);
                        break;
                    }
                    stringBuffer.append(c2);
                }
            }
            ++n3;
        }
        stringBuffer.append('\"');
    }

    static void a(Collection collection, StringBuffer stringBuffer) {
        stringBuffer.append('[');
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JSON.writeValue(iterator.next(), stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
    }

    public static void writeObject(Map map, StringBuffer stringBuffer) {
        stringBuffer.append('{');
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JSON.writeString(string, stringBuffer);
            stringBuffer.append(':');
            JSON.writeValue(map.get(string), stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append('}');
    }

    public static void writeContentLength(StringBuffer stringBuffer, int n2) {
        StringBuffer stringBuffer2 = new StringBuffer(18);
        stringBuffer2.append(n2).append(":");
        stringBuffer.insert(0, stringBuffer2.toString());
    }

    public static String serialize(JBPacket jBPacket) {
        Map map = jBPacket.toJSON();
        StringBuffer stringBuffer = new StringBuffer();
        JSON.writeValue(map, stringBuffer);
        int n2 = stringBuffer.length();
        JSON.writeContentLength(stringBuffer, n2);
        stringBuffer.append(LINE_FEED);
        if (TRACE) {
            d.writeString("SERIALIZE: " + jBPacket.getType() + " packet as " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static Object read(String string) {
        return JSON.parse(new StringCharacterIterator(string));
    }

    public static Object parse(CharacterIterator characterIterator) {
        JSON.a(characterIterator);
        Object object = JSON.b(characterIterator);
        JSON.a(characterIterator);
        if (characterIterator.current() != '\uffff') {
            throw JSON.a("should be done", characterIterator);
        }
        return object;
    }

    private static RuntimeException a(String string, CharacterIterator characterIterator) {
        return new IllegalStateException("[" + characterIterator.getIndex() + "] " + string);
    }

    private static void a(CharacterIterator characterIterator) {
        char c2 = characterIterator.current();
        while (Character.isWhitespace(c2)) {
            c2 = characterIterator.next();
        }
    }

    private static Object b(CharacterIterator characterIterator) {
        switch (characterIterator.current()) {
            case '{': {
                return JSON.d(characterIterator);
            }
            case '[': {
                return JSON.e(characterIterator);
            }
            case '\"': {
                return JSON.c(characterIterator);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JSON.f(characterIterator);
            }
            case 't': {
                JSON.b(Boolean.TRUE.toString(), characterIterator);
                return Boolean.TRUE;
            }
            case 'f': {
                JSON.b(Boolean.FALSE.toString(), characterIterator);
                return Boolean.FALSE;
            }
            case 'n': {
                JSON.b("null", characterIterator);
                return null;
            }
            case 'u': {
                JSON.b("undefined", characterIterator);
                return null;
            }
        }
        throw JSON.a("Bad JSON starting character '" + characterIterator.current() + "'", characterIterator);
    }

    private static String c(CharacterIterator characterIterator) {
        char c2 = characterIterator.next();
        if (c2 == '\"') {
            characterIterator.next();
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (c2 != '\uffff' && c2 != '\"') {
            block15: {
                block16: {
                    if (Character.isISOControl(c2)) {
                        c2 = characterIterator.next();
                        continue;
                    }
                    if (c2 != '\\') break block16;
                    c2 = characterIterator.next();
                    switch (c2) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            stringBuffer.append(c2);
                            break block15;
                        }
                        case 'b': {
                            stringBuffer.append('\b');
                            break block15;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            break block15;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            break block15;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            break block15;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            break block15;
                        }
                        case 'u': {
                            StringBuffer stringBuffer2 = new StringBuffer(4);
                            int n2 = 0;
                            while (n2 < 4) {
                                stringBuffer2.append(characterIterator.next());
                                ++n2;
                            }
                            try {
                                stringBuffer.append((char)Integer.parseInt(stringBuffer2.toString(), 16));
                                break block15;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw JSON.a("expected a unicode hex number but was '" + stringBuffer2.toString() + "'", characterIterator);
                            }
                        }
                        default: {
                            throw JSON.a("illegal escape character '" + c2 + "'", characterIterator);
                        }
                    }
                }
                stringBuffer.append(c2);
            }
            c2 = characterIterator.next();
        }
        c2 = characterIterator.next();
        return stringBuffer.toString();
    }

    private static Map d(CharacterIterator characterIterator) {
        characterIterator.next();
        JSON.a(characterIterator);
        if (characterIterator.current() == '}') {
            characterIterator.next();
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (characterIterator.current() != '\uffff') {
            if (characterIterator.current() != '\"') {
                throw JSON.a("expected a string start '\"' but was '" + characterIterator.current() + "'", characterIterator);
            }
            String string = JSON.c(characterIterator);
            if (hashMap.containsKey(string)) {
                throw JSON.a("' already definedkey '" + string, characterIterator);
            }
            JSON.a(characterIterator);
            if (characterIterator.current() != ':') {
                throw JSON.a("expected a pair separator ':' but was '" + characterIterator.current() + "'", characterIterator);
            }
            characterIterator.next();
            JSON.a(characterIterator);
            Object object = JSON.b(characterIterator);
            hashMap.put(string, object);
            JSON.a(characterIterator);
            if (characterIterator.current() == ',') {
                characterIterator.next();
                JSON.a(characterIterator);
                continue;
            }
            if (characterIterator.current() == '}') break;
            throw JSON.a("expected an object close '}' but was '" + characterIterator.current() + "'", characterIterator);
        }
        characterIterator.next();
        return hashMap;
    }

    private static List e(CharacterIterator characterIterator) {
        characterIterator.next();
        JSON.a(characterIterator);
        if (characterIterator.current() == ']') {
            characterIterator.next();
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (characterIterator.current() != '\uffff') {
            Object object = JSON.b(characterIterator);
            arrayList.add(object);
            JSON.a(characterIterator);
            if (characterIterator.current() == ',') {
                characterIterator.next();
                JSON.a(characterIterator);
                continue;
            }
            if (characterIterator.current() == ']') break;
            throw JSON.a("expected an array close ']' but was '" + characterIterator.current() + "'", characterIterator);
        }
        characterIterator.next();
        return arrayList;
    }

    private static void b(String string, CharacterIterator characterIterator) {
        int n2 = string.length();
        char c2 = characterIterator.current();
        int n3 = 0;
        while (n3 < n2) {
            if (c2 != string.charAt(n3)) {
                throw JSON.a("expected to parse '" + string + "' but character " + (n3 + 1) + " was '" + c2 + "'", characterIterator);
            }
            c2 = characterIterator.next();
            ++n3;
        }
    }

    private static Object f(CharacterIterator characterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = characterIterator.current();
        while (Character.isDigit(c2) || c2 == '-' || c2 == '+' || c2 == '.' || c2 == 'e' || c2 == 'E') {
            stringBuffer.append(c2);
            c2 = characterIterator.next();
        }
        try {
            return new BigDecimal(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw JSON.a("expected a number but was '" + stringBuffer.toString() + "'", characterIterator);
        }
    }
}

