/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.jsbinding.connect;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.RuntimeConfig;
import org.ccdt.common.resource.UploadManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.debug.core.jsdi.connect.Connector;
import org.ccdt.debug.internal.jsbinding.a;
import org.ccdt.debug.internal.jsbinding.connect.AttachConnector;
import org.ccdt.debug.internal.jsbinding.connect.Messages;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.ga.EventInfoFactory;
import org.ccdt.statistics.ga.Tracker;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class Win32Connector
extends AttachConnector {
    public static String ID = "jsbinding.win32.attach.connector";

    @Override
    protected int getDebugPort() {
        int n2 = 0;
        String string = PathManager.instance.getProjectConfigPath(this.project);
        RuntimeConfig runtimeConfig = (RuntimeConfig)ConfigurationManager.getConfiguration((String)string).getConfig(RuntimeConfig.class);
        if (runtimeConfig != null) {
            n2 = runtimeConfig.getInit_cfg().getDebugPort();
        }
        return n2 != 0 ? n2 : 5086;
    }

    @Override
    protected int getConsolePort() {
        int n2 = 0;
        String string = PathManager.instance.getProjectConfigPath(this.project);
        RuntimeConfig runtimeConfig = (RuntimeConfig)ConfigurationManager.getConfiguration((String)string).getConfig(RuntimeConfig.class);
        if (runtimeConfig != null) {
            n2 = runtimeConfig.getInit_cfg().getConsolePort();
        }
        return n2 != 0 ? n2 : 6050;
    }

    @Override
    public Map defaultArguments() {
        HashMap<String, Connector.Win32RuntimePath> hashMap = new HashMap<String, Connector.Win32RuntimePath>();
        hashMap.put(Connector.Win32RuntimePath.NAME, new Connector.Win32RuntimePath(a.c));
        return hashMap;
    }

    @Override
    public String description() {
        return Messages.win32_connector_desc;
    }

    @Override
    public String name() {
        return Messages.win32_connector_name;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void saveUserConfiguration(Map map) {
        this.appFilePath = String.valueOf(this.projectPath) + File.separator + (String)map.get(Connector.Win32RuntimePath.NAME);
    }

    @Override
    public boolean uploadResouceToRuntime(IProgressMonitor iProgressMonitor) throws Exception {
        UploadManager uploadManager = UploadManager.getInstance((String)this.project.getName(), (CCConsole)CCConsole.getCCConsole(), (String)"127.0.0.1", (int)6060, (boolean)false);
        uploadManager.setReloadCallback(this.syncerCallback);
        this.precompileAllScripts();
        return true;
    }

    @Override
    public boolean startRuntime() throws Exception {
        this.f();
        if (SystemInfo.checkPortBusy((int[])new int[]{this.getDebugPort(), this.getConsolePort()}, (boolean)false)) {
            return false;
        }
        if (!this.isFileExists(this.appFilePath)) {
            CocosLogger.getLogger((String)"Win32Connector").error((Object)(String.valueOf(this.appFilePath) + " is not exist"));
            Dialogs.openLaunchConfigurationDialog((String)(String.valueOf(this.appFilePath) + " is not exist, please select a new one and try again"), (String)this.mode);
            return false;
        }
        String string = String.format("\"%s\" \"%s\"", this.appFilePath, this.projectPath);
        CocosLogger.getLogger((String)"Win32Connector").info((Object)("start win32 runtime by : " + string));
        CommandHelper.execute((String)string, null, null, (File)new File(String.valueOf(this.projectPath) + "/runtime/win32/"));
        CCConsole cCConsole = CCConsole.getCCConsole((String)this.getHost(), (int)this.getConsolePort(), (long)10000L);
        if (cCConsole == null) {
            TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_JS_WINDOWS.getValue(), (long)FeatureValue.TIMEOUT);
            Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genDebugJSTimeoutEvent("db_windows_timeout"));
            int n2 = this.appFilePath.lastIndexOf("/");
            String string2 = this.appFilePath.substring(n2 + 1);
            if (SystemInfo.isRuntimeStarted((String)string2)) {
                CocosLogger.getLogger((String)"Win32Connector").error((Object)String.format("runtime started, but connect to runtime console %s:%d failed", this.getHost(), this.getConsolePort()));
                Dialogs.showMessageDialog((String)String.format("Runtime %s is running, but we can't access port %d", this.appFilePath, this.getConsolePort()));
            } else {
                CocosLogger.getLogger((String)"Win32Connector").error((Object)String.format("Runtime %s can't run normally", this.appFilePath));
                Dialogs.showMessageDialog((String)String.format("Runtime %s can't run normally, it would be some error with your runtime or blocked by firewall", this.appFilePath));
            }
            return false;
        }
        CocosLogger.getLogger((String)"Win32Connector").info((Object)String.format("connect to runtime console %s:%d success", this.getHost(), this.getConsolePort()));
        TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_JS_WINDOWS.getValue(), (long)FeatureValue.NOT_TIMEOUT);
        return true;
    }

    @Override
    public void afterRuntimeReady() {
        try {
            CCConsole.getCCConsole().startLogic();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

