/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.jsbinding.connect;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.RuntimeConfig;
import org.ccdt.common.resource.UploadManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.debug.core.jsdi.connect.Connector;
import org.ccdt.debug.internal.jsbinding.a;
import org.ccdt.debug.internal.jsbinding.connect.AttachConnector;
import org.ccdt.debug.internal.jsbinding.connect.Messages;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.ga.EventInfoFactory;
import org.ccdt.statistics.ga.Tracker;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class MacConnector
extends AttachConnector {
    public static String ID = "jsbinding.mac.attach.connector";
    private static final Pattern K = Pattern.compile("[0-9]{1,}");

    @Override
    protected int getDebugPort() {
        int n2 = 0;
        String string = PathManager.instance.getProjectConfigPath(this.project);
        RuntimeConfig runtimeConfig = (RuntimeConfig)ConfigurationManager.getConfiguration((String)string).getConfig(RuntimeConfig.class);
        if (runtimeConfig != null) {
            n2 = runtimeConfig.getInit_cfg().getDebugPort();
        }
        return n2 != 0 ? n2 : 5086;
    }

    @Override
    protected int getConsolePort() {
        int n2 = 0;
        String string = PathManager.instance.getProjectConfigPath(this.project);
        RuntimeConfig runtimeConfig = (RuntimeConfig)ConfigurationManager.getConfiguration((String)string).getConfig(RuntimeConfig.class);
        if (runtimeConfig != null) {
            n2 = runtimeConfig.getInit_cfg().getConsolePort();
        }
        return n2 != 0 ? n2 : 6050;
    }

    @Override
    public Map defaultArguments() {
        HashMap<String, Connector.MacRuntimePath> hashMap = new HashMap<String, Connector.MacRuntimePath>();
        hashMap.put(Connector.MacRuntimePath.NAME, new Connector.MacRuntimePath(a.d));
        return hashMap;
    }

    @Override
    public String description() {
        return Messages.mac_connector_desc;
    }

    @Override
    public String name() {
        return Messages.mac_connector_name;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void saveUserConfiguration(Map map) {
        this.appFilePath = String.valueOf(this.projectPath) + File.separator + (String)map.get(Connector.MacRuntimePath.NAME);
    }

    @Override
    public boolean uploadResouceToRuntime(IProgressMonitor iProgressMonitor) throws Exception {
        UploadManager uploadManager = UploadManager.getInstance((String)this.project.getName(), (CCConsole)CCConsole.getCCConsole(), (String)this.getHost(), (int)this.getUploadPort(), (boolean)false);
        uploadManager.setReloadCallback(this.syncerCallback);
        this.precompileAllScripts();
        return true;
    }

    @Override
    public boolean startRuntime() throws Exception {
        this.f();
        if (SystemInfo.checkPortBusy((int[])new int[]{this.getDebugPort(), this.getConsolePort()}, (boolean)false)) {
            return false;
        }
        if (!this.isFileExists(this.appFilePath)) {
            CocosLogger.getLogger((String)"MacConnector").error((Object)(String.valueOf(this.appFilePath) + " is not exist"));
            Dialogs.openLaunchConfigurationDialog((String)(String.valueOf(this.appFilePath) + " is not exist, please select a new one and try again"), (String)this.mode);
            return false;
        }
        String string = "";
        Object object = new File(String.valueOf(this.appFilePath) + "/Contents/MacOS/");
        CCConsole cCConsole = ((File)object).listFiles();
        if (cCConsole != null && ((File[])cCConsole).length != 0) {
            int n2 = 0;
            while (n2 < ((File[])cCConsole).length) {
                if (cCConsole[n2].canExecute()) {
                    string = cCConsole[n2].getAbsolutePath();
                    break;
                }
                ++n2;
            }
        }
        object = String.format("\"%s\" \"%s\"", string, this.projectPath);
        CocosLogger.getLogger((String)"MacConnector").info((Object)("start mac runtime by : " + (String)object));
        CommandHelper.execute((String)object, null, null, null, (String)"UTF-8");
        cCConsole = CCConsole.getCCConsole((String)this.getHost(), (int)this.getConsolePort(), (long)10000L);
        if (cCConsole == null) {
            TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_JS_MACOSX.getValue(), (long)FeatureValue.TIMEOUT);
            Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genDebugJSTimeoutEvent("db_mac_timeout"));
            if (SystemInfo.isRuntimeStarted((String)this.appFilePath)) {
                CocosLogger.getLogger((String)"MacConnector").error((Object)String.format("runtime started, but connect to runtime console %s:%d failed", this.getHost(), this.getConsolePort()));
                Dialogs.showMessageDialog((String)String.format("Runtime %s is running, but we can't access port %d", this.appFilePath, this.getConsolePort()));
            } else {
                CocosLogger.getLogger((String)"MacConnector").error((Object)String.format("Runtime %s can't run normally", this.appFilePath));
                Dialogs.showMessageDialog((String)String.format("Runtime %s can't run normally, it would be some error with your runtime", this.appFilePath));
            }
            return false;
        }
        CocosLogger.getLogger((String)"MacConnector").info((Object)String.format("connect to runtime console %s:%d success", this.getHost(), this.getConsolePort()));
        TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_JS_MACOSX.getValue(), (long)FeatureValue.NOT_TIMEOUT);
        return true;
    }

    @Override
    public void afterRuntimeReady() {
        try {
            CCConsole.getCCConsole().startLogic();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

