/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.jsbinding.connect;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.CommonConstants;
import org.ccdt.common.ccconsole.CCCommandPacket;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.resource.UploadManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.debug.core.jsdi.connect.Connector;
import org.ccdt.debug.internal.jsbinding.a;
import org.ccdt.debug.internal.jsbinding.connect.AttachConnector;
import org.ccdt.debug.internal.jsbinding.connect.IOSHostArgument;
import org.ccdt.debug.internal.jsbinding.connect.IOSSimulatorFamilyArgument;
import org.ccdt.debug.internal.jsbinding.connect.Messages;
import org.ccdt.debug.internal.jsbinding.connect.UseSimulatorArgument;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.ga.EventInfoFactory;
import org.ccdt.statistics.ga.Tracker;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class IOSConnector
extends AttachConnector {
    public static String ID = "jsbinding.ios.attach.connector";
    private Map t = null;
    private boolean H = false;
    private String I = null;
    private String J = null;
    UploadManager x = null;

    @Override
    protected String getHost() {
        if (this.H) {
            return "127.0.0.1";
        }
        return (String)this.t.get("androidHost");
    }

    @Override
    public Map defaultArguments() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("iosHost", new IOSHostArgument("127.0.0.1"));
        hashMap.put(UseSimulatorArgument.NAME, new UseSimulatorArgument(true));
        hashMap.put("iosSimulatorFamily", new IOSSimulatorFamilyArgument("iPhone Retina (3.5-inch)"));
        hashMap.put(Connector.IOSRuntimePath.NAME, new Connector.IOSRuntimePath(a.e));
        return hashMap;
    }

    @Override
    public String description() {
        return Messages.ios_connector_desc;
    }

    @Override
    public String name() {
        return Messages.ios_connector_name;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void saveUserConfiguration(Map map) {
        this.H = new Boolean((String)map.get(UseSimulatorArgument.NAME));
        if (this.H) {
            this.I = String.valueOf(this.projectPath) + File.separator + "runtime" + File.separator + "ios";
            this.appFilePath = String.valueOf(this.projectPath) + File.separator + (String)map.get(Connector.IOSRuntimePath.NAME);
            this.J = (String)map.get("iosSimulatorFamily");
        }
        this.t = map;
    }

    @Override
    public boolean uploadResouceToRuntime(IProgressMonitor iProgressMonitor) throws Exception {
        iProgressMonitor.subTask(Messages.uploading_res);
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        this.x = UploadManager.getInstance((String)this.project.getName(), (CCConsole)CCConsole.getCCConsole(), (String)this.getHost(), (int)this.getUploadPort(), (boolean)true);
        this.x.setReloadCallback(this.syncerCallback);
        this.x.initResourceToRuntime();
        this.precompileAllScripts();
        return true;
    }

    @Override
    public boolean startRuntime() throws Exception {
        Object object;
        if (this.H) {
            this.f();
            if (SystemInfo.checkPortBusy((int[])new int[]{this.getDebugPort(), this.getConsolePort(), this.getUploadPort()}, (boolean)false)) {
                return false;
            }
            if (!this.isFileExists(this.appFilePath)) {
                CocosLogger.getLogger((String)"IOSConnector").error((Object)(String.valueOf(this.appFilePath) + " is not exist"));
                Dialogs.openLaunchConfigurationDialog((String)(String.valueOf(this.appFilePath) + " is not exist, please select a new one and try again"), (String)this.mode);
                return false;
            }
            object = String.format("%s/ios-sim launch %s %s --exit", this.I, this.appFilePath, this.i());
            CocosLogger.getLogger((String)"IOSConnector").info((Object)("start ios simulator by : " + (String)object));
            CommandHelper.execute((String)object, null, null, null);
        }
        if ((object = CCConsole.getCCConsole((String)this.getHost(), (int)this.getConsolePort(), (long)15000L)) == null) {
            TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_JS_IOS.getValue(), (long)FeatureValue.TIMEOUT);
            Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genDebugJSTimeoutEvent("db_ios_timeout"));
            if (!this.H) {
                CocosLogger.getLogger((String)"IOSConnector").error((Object)String.format("connect to device runtime console %s:%d failed", this.getHost(), this.getConsolePort()));
                Dialogs.showMessageDialog((String)"Please install runtime ipa in your device, start it and try again");
            } else {
                CocosLogger.getLogger((String)"IOSConnector").error((Object)String.format("connect to simulator runtime console %s:%d failed", this.getHost(), this.getConsolePort()));
                Dialogs.showMessageDialog((String)"Connect runtime timeout, may be simulator takes too long time to start or runtime app is damaged, please try again without shutdown iOS simulator");
            }
            return false;
        }
        TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_JS_IOS.getValue(), (long)FeatureValue.NOT_TIMEOUT);
        CocosLogger.getLogger((String)"IOSConnector").info((Object)String.format("connect to runtime console %s:%d success", this.getHost(), this.getConsolePort()));
        CCCommandPacket cCCommandPacket = new CCCommandPacket("debugmsg", "on");
        CCConsole.getCCConsole().sendCommand(cCCommandPacket);
        return true;
    }

    @Override
    public void afterRuntimeReady() {
        try {
            CCConsole.getCCConsole().startLogic();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String i() {
        if (!CommonConstants.IOS_SIMULATOR_FAIMILY.contains(this.J)) {
            this.J = "iPhone Retina (3.5-inch)";
        }
        return (String)CommonConstants.IOS_SIMULATOR_FAMILY_ARGS.get(this.J);
    }
}

