/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.jsbinding.connect;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.ccconsole.CCCommandPacket;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.config.IConfiguration;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.model.InstalledRuntimeConfig;
import org.ccdt.common.resource.UploadManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.ConsoleFactory;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.debug.core.jsdi.connect.Connector;
import org.ccdt.debug.internal.jsbinding.a;
import org.ccdt.debug.internal.jsbinding.connect.AndroidConnector$1;
import org.ccdt.debug.internal.jsbinding.connect.AndroidConnector$ShellResultReceiver;
import org.ccdt.debug.internal.jsbinding.connect.AndroidConnector$StartActivityReceiver;
import org.ccdt.debug.internal.jsbinding.connect.AndroidHostArgument;
import org.ccdt.debug.internal.jsbinding.connect.AttachConnector;
import org.ccdt.debug.internal.jsbinding.connect.LaunchActivityArgument;
import org.ccdt.debug.internal.jsbinding.connect.Messages;
import org.ccdt.debug.internal.jsbinding.connect.PackageNameArgument;
import org.ccdt.debug.internal.jsbinding.connect.UseAdbModeArgument;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.ga.EventInfoFactory;
import org.ccdt.statistics.ga.Tracker;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;

public class AndroidConnector
extends AttachConnector {
    public static String ID = "jsbinding.android.attach.connector";
    private static final int p = 10086;
    private static final int q = 10088;
    private static final int r = 10090;
    private boolean s = false;
    private Map t = null;
    private String u = null;
    private String v = null;
    String w;
    UploadManager x = null;

    public AndroidConnector() {
        try {
            AndroidDebugBridge.init((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Override
    protected String getHost() {
        if (this.s) {
            return "127.0.0.1";
        }
        return (String)this.t.get("androidHost");
    }

    @Override
    protected int getDebugPort() {
        if (this.s) {
            return 10086;
        }
        return 5086;
    }

    @Override
    protected int getConsolePort() {
        if (this.s) {
            return 10088;
        }
        return 6050;
    }

    @Override
    protected int getUploadPort() {
        if (this.s) {
            return 10090;
        }
        return 6060;
    }

    @Override
    public Map defaultArguments() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(UseAdbModeArgument.NAME, new UseAdbModeArgument(true));
        hashMap.put("androidHost", new AndroidHostArgument("127.0.0.1"));
        hashMap.put("packageName", new PackageNameArgument(a.b));
        hashMap.put(LaunchActivityArgument.NAME, new LaunchActivityArgument("org.cocos2dx.javascript.AppActivity"));
        hashMap.put(Connector.AndroidRuntimePath.NAME, new Connector.AndroidRuntimePath(a.f));
        return hashMap;
    }

    @Override
    public String description() {
        return Messages.android_connector_desc;
    }

    @Override
    public String name() {
        return Messages.android_connector_name;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void saveUserConfiguration(Map map) {
        this.s = new Boolean((String)map.get(UseAdbModeArgument.NAME));
        this.appFilePath = String.valueOf(this.projectPath) + File.separator + (String)map.get(Connector.AndroidRuntimePath.NAME);
        if (this.s) {
            this.u = (String)map.get("packageName");
            this.v = (String)map.get(LaunchActivityArgument.NAME);
        }
        this.t = map;
    }

    @Override
    public boolean uploadResouceToRuntime(IProgressMonitor iProgressMonitor) throws Exception {
        iProgressMonitor.subTask(Messages.uploading_res);
        if (iProgressMonitor.isCanceled()) {
            return false;
        }
        this.x = UploadManager.getInstance((String)this.project.getName(), (CCConsole)CCConsole.getCCConsole(), (String)this.getHost(), (int)this.getUploadPort(), (boolean)true);
        this.x.setReloadCallback(this.syncerCallback);
        this.x.initResourceToRuntime();
        this.precompileAllScripts();
        return true;
    }

    @Override
    public void afterRuntimeReady() {
        try {
            CCConsole.getCCConsole().startLogic();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    IDevice getDevice() {
        IDevice iDevice = null;
        AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
        if (androidDebugBridge == null || !androidDebugBridge.isConnected()) {
            return null;
        }
        IDevice[] iDeviceArray = androidDebugBridge.getDevices();
        if (iDeviceArray.length == 0) {
            try {
                String string = String.valueOf(this.w) + "/platform-tools/adb";
                Process process = DebugPlugin.exec((String[])new String[]{string, "kill-server"}, null);
                process.waitFor();
                process = DebugPlugin.exec((String[])new String[]{string, "devices"}, null);
                process.waitFor();
            }
            catch (Throwable throwable) {}
            iDeviceArray = androidDebugBridge.getDevices();
        }
        if (iDeviceArray.length == 0) {
            return null;
        }
        iDevice = iDeviceArray[0];
        return iDevice;
    }

    boolean e() {
        if (!this.checkAndroidSDK()) {
            CocosLogger.getLogger((String)"AndroidConnector").error((Object)"haven't set android sdk");
            return false;
        }
        String string = String.valueOf(this.w) + "/platform-tools/adb";
        AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.createBridge();
        if (!androidDebugBridge.isConnected()) {
            try {
                Process process = DebugPlugin.exec((String[])new String[]{string, "devices"}, null);
                process.waitFor();
            }
            catch (Throwable throwable) {
                CocosLogger.getLogger((String)"AndroidConnector").info((Object)(String.valueOf(string) + " devices failed"));
            }
        }
        int n2 = 0;
        while (!androidDebugBridge.hasInitialDeviceList()) {
            try {
                Thread.sleep(200L);
                ++n2;
            }
            catch (InterruptedException interruptedException) {}
            if (n2 <= 15) continue;
            CocosLogger.getLogger((String)"AndroidConnector").error((Object)"init device failed");
            return false;
        }
        return true;
    }

    @Override
    public boolean startRuntime() throws Exception {
        Object object;
        CCConsole cCConsole;
        if (this.s) {
            block13: {
                this.f();
                if (!this.e()) {
                    return false;
                }
                if (this.u == null || this.v == null) {
                    CocosLogger.getLogger((String)"AndroidConnector").error((Object)String.format("package name or launch activity is invalid %s/%s", this.u, this.v));
                    Dialogs.openLaunchConfigurationDialog((String)"Package Name and Launch Activity must not be empty when launching on android device via adb mode", (String)this.mode);
                    return false;
                }
                cCConsole = this.getDevice();
                if (cCConsole == null) {
                    CocosLogger.getLogger((String)"AndroidConnector").error((Object)"can't get android device");
                    Dialogs.openLaunchConfigurationDialog((String)"There is no android device is connected, are you sure you want to launch on android device via adb mode?", (String)this.mode);
                    return false;
                }
                if (cCConsole.isOffline()) {
                    CocosLogger.getLogger((String)"AndroidConnector").error((Object)"device is offline");
                    Dialogs.showMessageDialog((String)"The device is offline, please try to re-plugged the USB line or reboot the device then try again.");
                    return false;
                }
                if (SystemInfo.checkPortBusy((int[])new int[]{this.getDebugPort(), this.getConsolePort(), this.getUploadPort()}, (boolean)true)) {
                    return false;
                }
                if (!this.isFileExists(this.appFilePath)) {
                    CocosLogger.getLogger((String)"AndroidConnector").error((Object)(String.valueOf(this.appFilePath) + " is not exist"));
                    Dialogs.openLaunchConfigurationDialog((String)(String.valueOf(this.appFilePath) + " is not exist, please select a new one and try again"), (String)this.mode);
                    return false;
                }
                if (!this.d((IDevice)cCConsole)) {
                    return false;
                }
                try {
                    object = String.format("am start -W %s/%s", this.u, this.v);
                    ConsoleFactory.showLine((String)String.format("Start LaunchActivity %s/%s", this.u, this.v), (boolean)false);
                    CocosLogger.getLogger((String)"AndroidConnector").info((Object)String.format("Start LaunchActivity %s/%s", this.u, this.v));
                    AndroidConnector$StartActivityReceiver androidConnector$StartActivityReceiver = new AndroidConnector$StartActivityReceiver(this, null);
                    cCConsole.executeShellCommand((String)object, (IShellOutputReceiver)androidConnector$StartActivityReceiver);
                    if (androidConnector$StartActivityReceiver.getErrorMessage() == null) break block13;
                    CocosLogger.getLogger((String)"AndroidConnector").error((Object)String.format("Start runtime error:%s", androidConnector$StartActivityReceiver.getErrorMessage()));
                    Dialogs.openLaunchConfigurationDialog((String)String.format("Start runtime error:%s", androidConnector$StartActivityReceiver.getErrorMessage()), (String)this.mode);
                    return false;
                }
                catch (Throwable throwable) {
                    CocosLogger.getLogger((String)"AndroidConnector").error((Object)("Start runtime Exception : " + throwable));
                    Dialogs.showMessageDialog((String)"Starting runtime failed. Check whether device's screen is locked.");
                    return false;
                }
            }
            CocosLogger.getLogger((String)"AndroidConnector").info((Object)String.format("Start LaunchActivity %s/%s success", this.u, this.v));
            cCConsole.createForward(10086, 5086);
            cCConsole.createForward(10088, 6050);
            cCConsole.createForward(10090, 6060);
        }
        if ((cCConsole = CCConsole.getCCConsole((String)this.getHost(), (int)this.getConsolePort(), (long)10000L)) == null) {
            TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_JS_ANDROID.getValue(), (long)FeatureValue.TIMEOUT);
            Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genDebugJSTimeoutEvent("db_android_timeout"));
            CocosLogger.getLogger((String)"AndroidConnector").error((Object)String.format("connect to runtime console %s:%d failed", this.getHost(), this.getConsolePort()));
            if (!this.s) {
                Dialogs.showMessageDialog((String)("Please install runtime in your device, start it and try debug again. If runtime is started, please check whether the device and pc are on the same segment, and can access each other." + String.format("Prebuilt runtime apk is in %s/runtime/android directory", this.projectPath)));
            }
            return false;
        }
        TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_JS_ANDROID.getValue(), (long)FeatureValue.NOT_TIMEOUT);
        CocosLogger.getLogger((String)"AndroidConnector").info((Object)String.format("connect to runtime console %s:%d success", this.getHost(), this.getConsolePort()));
        object = new CCCommandPacket("debugmsg", "on");
        cCConsole.sendCommand(object);
        return true;
    }

    boolean checkAndroidSDK() {
        IPreferenceStore iPreferenceStore = CommonPlugin.getDefault().getPreferenceStore();
        this.w = iPreferenceStore.getString("org.ccdt.common.sdk_path");
        if (this.w == null || "".equals(this.w)) {
            this.showPreferencesDialog("Android SDK must be setted, please go to preferences to set it and relaunch the debugger.", "org.ccdt.common.ui.prefs.cocos");
            return false;
        }
        if (!new File(this.w).exists()) {
            this.showPreferencesDialog("Android SDK path is not exist, please go to preferences to reset it and relaunch the debugger.", "org.ccdt.common.ui.prefs.cocos");
            return false;
        }
        return true;
    }

    boolean a(IDevice iDevice) {
        boolean bl = false;
        try {
            AndroidConnector$ShellResultReceiver androidConnector$ShellResultReceiver = new AndroidConnector$ShellResultReceiver(this);
            iDevice.executeShellCommand(String.format("pm path %s", this.u), (IShellOutputReceiver)androidConnector$ShellResultReceiver);
            while (!androidConnector$ShellResultReceiver.B) {
            }
            if (androidConnector$ShellResultReceiver.getResult().indexOf(".apk") != -1) {
                bl = true;
            }
        }
        catch (Throwable throwable) {}
        return bl;
    }

    boolean b(IDevice iDevice) {
        String string = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + iDevice.getName() + ".json";
        IConfiguration iConfiguration = ConfigurationManager.getConfiguration((String)string);
        InstalledRuntimeConfig installedRuntimeConfig = (InstalledRuntimeConfig)iConfiguration.getConfig(InstalledRuntimeConfig.class);
        if (installedRuntimeConfig == null) {
            return true;
        }
        long l2 = installedRuntimeConfig.getInstalledModifiedTime(this.u);
        long l3 = new File(this.appFilePath).lastModified();
        return l3 > l2;
    }

    void c(IDevice iDevice) {
        String string = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + iDevice.getName() + ".json";
        IConfiguration iConfiguration = ConfigurationManager.getConfiguration((String)string);
        InstalledRuntimeConfig installedRuntimeConfig = (InstalledRuntimeConfig)iConfiguration.getConfig(InstalledRuntimeConfig.class);
        if (installedRuntimeConfig == null) {
            installedRuntimeConfig = new InstalledRuntimeConfig();
        }
        long l2 = new File(this.appFilePath).lastModified();
        installedRuntimeConfig.setInstalledModifiedTime(this.u, l2);
        iConfiguration.save((Object)installedRuntimeConfig);
    }

    boolean d(IDevice iDevice) {
        block4: {
            if (!this.b(iDevice) && this.a(iDevice)) {
                return true;
            }
            try {
                ConsoleFactory.showLine((String)"install runtime start...", (boolean)false);
                String string = iDevice.installPackage(this.appFilePath, true, new String[0]);
                String string2 = string == null ? "success!" : "error:" + string;
                ConsoleFactory.showLine((String)("install runtime " + string2), (boolean)false);
                if (string == null) break block4;
                CocosLogger.getLogger((String)"AndroidConnector").error((Object)("Install apk error, error message : " + string2));
                Dialogs.showMessageDialog((String)("Install apk error, error message : " + string2));
                return false;
            }
            catch (InstallException installException) {
                CocosLogger.getLogger((String)"AndroidConnector").error((Object)("InstallException" + (Object)((Object)installException)));
                Dialogs.showMessageDialog((String)"Install runtime apk error, please open 'Error Log' view for details.");
                return false;
            }
        }
        CocosLogger.getLogger((String)"AndroidConnector").info((Object)"Install apk success");
        this.c(iDevice);
        return true;
    }

    void showPreferencesDialog(String string, String string2) {
        Display.getDefault().syncExec((Runnable)new AndroidConnector$1(this, string, string2));
    }
}

