/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.lua.debug.launch.runtime;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.RuntimeConfig;
import org.ccdt.common.resource.UploadManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.lua.debug.launch.Messages;
import org.ccdt.lua.debug.launch.i;
import org.ccdt.lua.debug.launch.runtime.d;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.ga.EventInfoFactory;
import org.ccdt.statistics.ga.Tracker;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.osgi.util.NLS;

public class MacRuntime
extends d {
    public static final String ID = "mac";

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String name() {
        return "Mac";
    }

    @Override
    public void doStart(IProgressMonitor iProgressMonitor) throws Exception {
        String string = this.getRuntimeIP();
        this.a(iProgressMonitor);
        this.bi = CCConsole.getCCConsole((String)string, (int)this.getConsolePort(), (long)10000L);
        if (this.bi == null) {
            TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_LUA_MACOSX.getValue(), (long)FeatureValue.TIMEOUT);
            Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genDebugLuaTimeoutEvent("db_mac_timeout"));
            String string2 = this.getRuntimePath();
            if (SystemInfo.isRuntimeStarted((String)string2)) {
                CocosLogger.getLogger((String)"MacRuntime").error((Object)String.format("runtime started, but connect to runtime console %s:%d failed", string, this.getConsolePort()));
                Dialogs.showMessageDialog((String)NLS.bind((String)Messages.mac_runtime_is_running_but_cannot_access, (Object)string2, (Object)this.getConsolePort()));
            } else {
                CocosLogger.getLogger((String)"MacRuntime").error((Object)String.format("Runtime %s can't run normally", string, this.getConsolePort()));
                Dialogs.showMessageDialog((String)NLS.bind((String)Messages.mac_runtime_not_run_normally, (Object)string2));
            }
            throw this.a(Messages.mac_runtime_timeout_err, null);
        }
        TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_LUA_MACOSX.getValue(), (long)FeatureValue.NOT_TIMEOUT);
        CocosLogger.getLogger((String)"MacRuntime").info((Object)String.format("connect to runtime console %s:%d success", string, this.getConsolePort()));
        this.bj = UploadManager.getInstance((String)this.getProjectName(), (CCConsole)this.bi, (String)string, (int)this.r(), (boolean)false);
        this.bj.setReloadCallback(this.syncerCallback);
        this.c(iProgressMonitor);
    }

    void a(IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.isRuntimeExisted()) {
            CocosLogger.getLogger((String)"MacRuntime").error((Object)(String.valueOf(this.getRuntimePath()) + " is not exist"));
            Dialogs.openLaunchConfigurationDialog((String)NLS.bind((String)Messages.runtime_not_exist_msg, (Object)this.getRuntimePath()), (String)this.mode);
            throw this.a(Messages.runtime_not_exist, null);
        }
        this.u();
        if (SystemInfo.checkPortBusy((int[])new int[]{this.getConsolePort()}, (boolean)false)) {
            throw this.a(Messages.mac_runtime_ports_being_used_err, null);
        }
        String string = "";
        Object object = new File(String.valueOf(this.getRuntimePath()) + "/Contents/MacOS/");
        File[] fileArray = ((File)object).listFiles();
        if (fileArray != null && fileArray.length != 0) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (fileArray[n2].canExecute()) {
                    string = fileArray[n2].getAbsolutePath();
                    break;
                }
                ++n2;
            }
        }
        try {
            CocosLogger.getLogger((String)"MacRuntime").info((Object)("start mac runtime by : " + string + " " + this.getProjectPath()));
            object = DebugPlugin.exec((String[])new String[]{string, this.getProjectPath()}, null);
            this.a((Process)object);
        }
        catch (CoreException coreException) {
            Dialogs.showMessageDialog((String)NLS.bind((String)Messages.mac_runtime_not_run_normally, (Object)this.getRuntimePath()));
            throw this.a(coreException.getCause().getMessage(), null);
        }
    }

    String p() throws CoreException {
        i i2 = new i();
        i2.setHost("127.0.0.1");
        i2.setPort(this.bh.getAttribute("dbgp.port", "10000"));
        i2.d(LaunchConfigurationUtils.getString((ILaunchConfiguration)this.bh, (String)"dbgp_session_id", (String)"luaidekey"));
        i2.e(null);
        i2.setPlatform("ios");
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        i2.f(String.valueOf(iProject.getLocationURI().getPath()) + "/");
        return i2.toString();
    }

    void c(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        iProgressMonitor.subTask(Messages.mac_runtime_start_logic_task);
        try {
            this.bi.startLogic(this.p());
        }
        catch (Throwable throwable) {
            Dialogs.showMessageDialog((String)Messages.mac_runtime_start_logic_err_msg);
            throw this.a(Messages.mac_runtime_start_logic_err, throwable);
        }
    }

    @Override
    public String getRuntimePath() throws CoreException {
        String string = this.getProjectPath();
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string2 = (String)map.get("mac.runtime_path");
        String string3 = "";
        if (string2 != null && !"".equals(string2)) {
            string3 = String.valueOf(string) + File.separator + string2;
        }
        return string3;
    }

    @Override
    public String getRuntimeIP() throws CoreException {
        String string = "127.0.0.1";
        return string;
    }

    @Override
    protected int getConsolePort() throws CoreException {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        int n2 = 0;
        String string = PathManager.instance.getProjectConfigPath(iProject);
        RuntimeConfig runtimeConfig = (RuntimeConfig)ConfigurationManager.getConfiguration((String)string).getConfig(RuntimeConfig.class);
        if (runtimeConfig != null) {
            n2 = runtimeConfig.getInit_cfg().getConsolePort();
        }
        return n2 != 0 ? n2 : 6010;
    }

    @Override
    public boolean isUseDevice() throws CoreException {
        return false;
    }
}

