/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.lua.debug.launch.runtime;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ccdt.common.CommonConstants;
import org.ccdt.common.ccconsole.CCCommandPacket;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.resource.UploadManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.lua.b;
import org.ccdt.lua.debug.launch.Messages;
import org.ccdt.lua.debug.launch.i;
import org.ccdt.lua.debug.launch.runtime.d;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.ga.EventInfoFactory;
import org.ccdt.statistics.ga.Tracker;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.osgi.util.NLS;

public class IOSRuntime
extends d {
    public static final String ID = "ios";

    public IOSRuntime() {
    }

    public IOSRuntime(ILaunchConfiguration iLaunchConfiguration) {
        super(iLaunchConfiguration);
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String name() {
        return "IOS";
    }

    @Override
    public void doStart(IProgressMonitor iProgressMonitor) throws Exception {
        String string = this.getRuntimeIP();
        this.a(iProgressMonitor);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        this.bi = CCConsole.getCCConsole((String)string, (int)this.getConsolePort(), (long)15000L);
        if (this.bi == null) {
            TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_LUA_IOS.getValue(), (long)FeatureValue.TIMEOUT);
            Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genDebugLuaTimeoutEvent("db_ios_timeout"));
            if (this.isUseDevice()) {
                CocosLogger.getLogger((String)"IOSRuntime").error((Object)String.format("connect to device runtime console %s:%d failed", string, this.getConsolePort()));
                Dialogs.showMessageDialog((String)Messages.ios_device_runtime_connect_to_rt_msg);
            } else {
                CocosLogger.getLogger((String)"IOSRuntime").error((Object)String.format("connect to simulator runtime console %s:%d failed", string, this.getConsolePort()));
                Dialogs.showMessageDialog((String)Messages.ios_simulator_runtime_connect_to_rt_msg);
            }
            throw this.a(Messages.ios_runtime_connect_to_rt_err, null);
        }
        TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_LUA_IOS.getValue(), (long)FeatureValue.NOT_TIMEOUT);
        CocosLogger.getLogger((String)"IOSRuntime").info((Object)String.format("connect to runtime console %s:%d success", string, this.getConsolePort()));
        CCCommandPacket cCCommandPacket = new CCCommandPacket("debugmsg", "on");
        this.bi.sendCommand(cCCommandPacket);
        this.bj = UploadManager.getInstance((String)this.getProjectName(), (CCConsole)this.bi, (String)string, (int)this.r(), (boolean)true);
        this.bj.setReloadCallback(this.syncerCallback);
        this.b(iProgressMonitor);
        this.c(iProgressMonitor);
    }

    void a(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            if (!this.isUseDevice()) {
                iProgressMonitor.subTask(Messages.ios_runtime_starting_simulator_task);
                if (!this.isRuntimeExisted()) {
                    CocosLogger.getLogger((String)"IOSRuntime").error((Object)(String.valueOf(this.getRuntimePath()) + " is not exist"));
                    Dialogs.openLaunchConfigurationDialog((String)NLS.bind((String)Messages.runtime_not_exist_msg, (Object)this.getRuntimePath()), (String)this.mode);
                    throw this.a(Messages.runtime_not_exist, null);
                }
                this.u();
                if (SystemInfo.checkPortBusy((int[])new int[]{this.getConsolePort(), this.r()}, (boolean)false)) {
                    throw this.a(Messages.ios_runtime_ports_being_used_err, null);
                }
                String string = String.format("\"%s\" launch \"%s\" %s --exit", this.w(), this.getRuntimePath(), this.y());
                CocosLogger.getLogger((String)"IOSRuntime").info((Object)("start ios simulator by : " + string));
                Process process = DebugPlugin.exec((String[])new String[]{"/bin/sh", "-c", string}, null);
                this.a(process);
                process.waitFor();
            }
        }
        catch (CoreException coreException) {
            throw coreException;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    String p() throws CoreException {
        IProject iProject;
        i i2 = new i();
        String string = "127.0.0.1";
        if (this.isUseDevice()) {
            string = this.bh.getAttribute("dbgp.ip", "127.0.0.1");
            iProject = b.getLocalAddresses();
            List<String> list = Arrays.asList(iProject);
            if (!list.contains(string)) {
                CocosLogger.getLogger((String)"IOSRuntime").error((Object)(String.valueOf(string) + " is not included in : " + list));
                Dialogs.openLaunchConfigurationDialog((String)Messages.ios_runtime_reset_host_ip_msg, (String)this.mode);
                throw this.a(Messages.ios_runtime_reset_host_ip_err, null);
            }
        }
        i2.setHost(string);
        i2.setPort(this.bh.getAttribute("dbgp.port", "10000"));
        i2.d(LaunchConfigurationUtils.getString((ILaunchConfiguration)this.bh, (String)"dbgp_session_id", (String)"luaidekey"));
        i2.e(null);
        i2.setPlatform(ID);
        iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        i2.f(String.valueOf(iProject.getLocationURI().getPath()) + "/");
        return i2.toString();
    }

    void b(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        iProgressMonitor.subTask(Messages.ios_runtime_uploading_res_task);
        try {
            this.bj.initResourceToRuntime();
        }
        catch (Exception exception) {
            Dialogs.showMessageDialog((String)Messages.ios_runtime_uploading_res_err_msg);
            throw this.a(Messages.ios_runtime_uploading_res_err, exception);
        }
    }

    void c(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        String string = this.p();
        iProgressMonitor.subTask(Messages.ios_runtime_start_logic_task);
        try {
            this.bi.startLogic(string);
        }
        catch (Throwable throwable) {
            Dialogs.showMessageDialog((String)Messages.ios_runtime_start_logic_err_msg);
            throw this.a(Messages.ios_runtime_start_logic_err, throwable);
        }
    }

    @Override
    public String getRuntimePath() throws CoreException {
        String string = this.getProjectPath();
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string2 = (String)map.get("ios.runtime_path");
        String string3 = "";
        if (string2 != null && !"".equals(string2)) {
            string3 = String.valueOf(string) + File.separator + string2;
        }
        return string3;
    }

    String w() throws CoreException {
        String string = this.getProjectPath();
        return String.valueOf(string) + File.separator + "runtime" + File.separator + ID + File.separator + "ios-sim";
    }

    @Override
    public boolean isUseDevice() throws CoreException {
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string = (String)map.get("ios.use_simulator");
        return Boolean.valueOf(string) == false;
    }

    @Override
    public String getRuntimeIP() throws CoreException {
        String string = "127.0.0.1";
        if (!this.isUseDevice()) {
            return string;
        }
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        string = (String)map.get("ios.host");
        if (string == null || "".equals(string) || "127.0.0.1".equals(string)) {
            Dialogs.openLaunchConfigurationDialog((String)Messages.ios_runtime_reset_device_ip_msg, (String)this.mode);
            throw this.a(Messages.ios_runtime_reset_device_ip_err, null);
        }
        return string;
    }

    private String x() throws CoreException {
        String string = "iPhone Retina (3.5-inch)";
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string2 = (String)map.get("ios.simulator_family");
        if (CommonConstants.IOS_SIMULATOR_FAIMILY.contains(string2)) {
            string = string2;
        }
        return string;
    }

    private String y() throws CoreException {
        String string = this.x();
        return (String)CommonConstants.IOS_SIMULATOR_FAMILY_ARGS.get(string);
    }
}

