/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.lua.debug.launch.runtime;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.ccconsole.CCCommandPacket;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.config.IConfiguration;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.model.InstalledRuntimeConfig;
import org.ccdt.common.resource.UploadManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.ConsoleFactory;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.lua.debug.launch.Messages;
import org.ccdt.lua.debug.launch.i;
import org.ccdt.lua.debug.launch.runtime.a;
import org.ccdt.lua.debug.launch.runtime.b;
import org.ccdt.lua.debug.launch.runtime.c;
import org.ccdt.lua.debug.launch.runtime.d;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.ga.EventInfoFactory;
import org.ccdt.statistics.ga.Tracker;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class AndroidRuntime
extends d {
    public static final String ID = "android";
    private static final int aT = 10089;
    private static final int aU = 10091;
    private String aV = null;
    private String aW = null;
    String aX;
    String aY;

    public AndroidRuntime() {
        IPreferenceStore iPreferenceStore = CommonPlugin.getDefault().getPreferenceStore();
        this.aX = iPreferenceStore.getString("org.ccdt.common.sdk_path");
        this.aY = String.valueOf(this.aX) + "/platform-tools/adb";
        try {
            AndroidDebugBridge.init((boolean)false);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String name() {
        return "Android";
    }

    public AndroidRuntime(ILaunchConfiguration iLaunchConfiguration) {
        super(iLaunchConfiguration);
    }

    @Override
    public void doStart(IProgressMonitor iProgressMonitor) throws Exception {
        this.a(iProgressMonitor);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        String string = this.getRuntimeIP();
        this.bi = CCConsole.getCCConsole((String)string, (int)this.getConsolePort(), (long)10000L);
        if (this.bi == null) {
            TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_LUA_ANDROID.getValue(), (long)FeatureValue.TIMEOUT);
            Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genDebugLuaTimeoutEvent("db_android_timeout"));
            CocosLogger.getLogger((String)"AndroidRuntime").error((Object)String.format("connect to runtime console %s:%d failed!", string, this.getConsolePort()));
            Dialogs.showMessageDialog((String)Messages.android_runtime_connect_err_msg);
            throw this.a(Messages.android_runtime_connect_err, null);
        }
        TrackUtils.trackFeatureValue((String)FeatureEnum.CONNECT_RUNTIME_TIMEOUT_LUA_ANDROID.getValue(), (long)FeatureValue.NOT_TIMEOUT);
        CocosLogger.getLogger((String)"AndroidRuntime").error((Object)String.format("connect to runtime console %s:%s success!", string, this.getConsolePort()));
        CCCommandPacket cCCommandPacket = new CCCommandPacket("debugmsg", "on");
        this.bi.sendCommand(cCCommandPacket);
        this.bj = UploadManager.getInstance((String)this.getProjectName(), (CCConsole)this.bi, (String)string, (int)this.r(), (boolean)true);
        this.bj.setReloadCallback(this.syncerCallback);
        this.b(iProgressMonitor);
        this.c(iProgressMonitor);
    }

    void a(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        if (!this.t()) {
            return;
        }
        try {
            this.u();
            this.aV = this.getPackageName();
            this.aW = this.s();
            if (!this.checkAndroidSDK()) {
                CocosLogger.getLogger((String)"AndroidRuntime").error((Object)"haven't set android sdk");
                iProgressMonitor.setCanceled(true);
                return;
            }
            this.q();
            IDevice iDevice = this.getDevice();
            if (SystemInfo.checkPortBusy((int[])new int[]{this.getConsolePort(), this.r()}, (boolean)true)) {
                throw this.a(Messages.android_runtime_adb_ports_being_used_err, null);
            }
            this.a(iDevice, iProgressMonitor);
            iProgressMonitor.setTaskName(Messages.android_runtime_starting_task);
            ConsoleFactory.showLine((String)String.format("Start LaunchActivity %s/%s", this.aV, this.aW), (boolean)false);
            CocosLogger.getLogger((String)"AndroidRuntime").info((Object)String.format("Start LaunchActivity %s/%s", this.aV, this.aW));
            String string = String.format("am start -W -n %1$s/%2$s", this.aV, this.aW);
            c c2 = new c(this, null);
            iDevice.executeShellCommand(string, (IShellOutputReceiver)c2);
            if (c2.getErrorMessage() != null) {
                CocosLogger.getLogger((String)"AndroidRuntime").error((Object)String.format("Start runtime error:%s", c2.getErrorMessage()));
                Dialogs.openLaunchConfigurationDialog((String)NLS.bind((String)Messages.android_runtime_start_err_msg, (Object)c2.getErrorMessage()), (String)this.mode);
                throw this.a(Messages.android_runtime_start_err, null);
            }
            CocosLogger.getLogger((String)"AndroidRuntime").info((Object)String.format("Start LaunchActivity %s/%s success", this.aV, this.aW));
            iDevice.createForward(10089, 6010);
            iDevice.createForward(10091, 6020);
        }
        catch (CoreException coreException) {
            throw coreException;
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            CocosLogger.getLogger((String)"AndroidRuntime").error((Object)("startRuntime ShellCommandUnresponsiveException : " + (Object)((Object)shellCommandUnresponsiveException)));
            Dialogs.showMessageDialog((String)Messages.android_runtime_start_failed_msg);
            throw this.a(Messages.android_runtime_start_failed_err, shellCommandUnresponsiveException);
        }
        catch (Throwable throwable) {
            CocosLogger.getLogger((String)"AndroidRuntime").error((Object)("startRuntime Throwable : " + throwable));
            Dialogs.showMessageDialog((String)Messages.android_runtime_starting_unknown_err_msg);
            throw this.a(Messages.android_runtime_starting_unknown_err, throwable);
        }
    }

    void b(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        iProgressMonitor.subTask(Messages.android_runtime_uploading_res_task);
        try {
            this.bj.initResourceToRuntime();
        }
        catch (Exception exception) {
            Dialogs.showMessageDialog((String)Messages.android_runtime_uploading_res_err_msg);
            throw this.a(Messages.android_runtime_uploading_res_err, exception);
        }
    }

    void c(IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor.isCanceled()) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        String string = this.p();
        CocosLogger.getLogger((String)"AndroidRuntime").info((Object)("luaDebugArgs : " + string));
        iProgressMonitor.subTask(Messages.android_runtime_start_logic_task);
        try {
            this.bi.startLogic(string);
        }
        catch (Throwable throwable) {
            Dialogs.showMessageDialog((String)Messages.android_runtime_start_logic_err_msg);
            throw this.a(Messages.android_runtime_start_logic_err, null);
        }
    }

    String p() throws CoreException {
        i i2 = new i();
        String string = this.bh.getAttribute("dbgp.ip", "127.0.0.1");
        String[] stringArray = org.ccdt.lua.b.getLocalAddresses();
        List<String> list = Arrays.asList(stringArray);
        if (!list.contains(string)) {
            CocosLogger.getLogger((String)"AndroidRuntime").error((Object)(String.valueOf(string) + " is not included in : " + list));
            Dialogs.openLaunchConfigurationDialog((String)Messages.android_runtime_reset_host_ip_msg, (String)this.mode);
            throw this.a(Messages.android_runtime_reset_host_ip_err, null);
        }
        i2.setHost(string);
        i2.setPort(this.bh.getAttribute("dbgp.port", "10000"));
        i2.d(LaunchConfigurationUtils.getString((ILaunchConfiguration)this.bh, (String)"dbgp_session_id", (String)"luaidekey"));
        i2.e(null);
        i2.setPlatform(ID);
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        i2.f(String.valueOf(iProject.getLocationURI().getPath()) + "/");
        System.out.println("debug args = " + i2.toString());
        return i2.toString();
    }

    void q() throws CoreException {
        AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.createBridge();
        if (!androidDebugBridge.isConnected()) {
            Process process = DebugPlugin.exec((String[])new String[]{this.aY, "devices"}, null);
            try {
                process.waitFor();
            }
            catch (Throwable throwable) {
                CocosLogger.getLogger((String)"AndroidRuntime").info((Object)(String.valueOf(this.aY) + " devices failed"));
            }
        }
        int n2 = 0;
        while (!androidDebugBridge.hasInitialDeviceList()) {
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
                ++n2;
            }
            catch (InterruptedException interruptedException) {}
            if (n2 <= 15) continue;
            CocosLogger.getLogger((String)"AndroidRuntime").error((Object)"init device failed");
            Dialogs.showMessageDialog((String)Messages.android_runtime_adb_can_not_connect_to_device_msg);
            throw this.a(Messages.android_runtime_adb_can_not_connect_to_device_err, null);
        }
    }

    IDevice getDevice() throws CoreException {
        AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
        if (androidDebugBridge == null) {
            Dialogs.showMessageDialog((String)Messages.android_runtime_create_adb_instance_err_msg);
            throw this.a(Messages.android_runtime_create_adb_instance_err, null);
        }
        IDevice[] iDeviceArray = androidDebugBridge.getDevices();
        if (iDeviceArray.length == 0) {
            try {
                Process process = DebugPlugin.exec((String[])new String[]{this.aY, "kill-server"}, null);
                process.waitFor();
                process = DebugPlugin.exec((String[])new String[]{this.aY, "devices"}, null);
                process.waitFor();
            }
            catch (Throwable throwable) {}
            iDeviceArray = androidDebugBridge.getDevices();
        }
        if (iDeviceArray.length == 0) {
            CocosLogger.getLogger((String)"AndroidRuntime").error((Object)"can't get android device");
            Dialogs.showMessageDialog((String)Messages.android_runtime_can_not_get_devices_msg);
            throw this.a(Messages.android_runtime_can_not_get_devices_err, null);
        }
        if (iDeviceArray[0].isOffline()) {
            CocosLogger.getLogger((String)"AndroidRuntime").error((Object)"device is offline");
            Dialogs.showMessageDialog((String)Messages.android_runtime_device_is_offline_msg);
            throw this.a(Messages.android_runtime_device_is_offline_err, null);
        }
        return iDeviceArray[0];
    }

    boolean checkAndroidSDK() {
        if (this.aX == null || "".equals(this.aX)) {
            this.showPreferencesDialog(Messages.android_runtime_sdk_must_be_setted_msg, "org.ccdt.common.ui.prefs.cocos");
            return false;
        }
        if (!new File(this.aX).exists()) {
            this.showPreferencesDialog(Messages.android_runtime_sdk_path_not_exist_msg, "org.ccdt.common.ui.prefs.cocos");
            return false;
        }
        return true;
    }

    void showPreferencesDialog(String string, String string2) {
        Display.getDefault().syncExec((Runnable)new a(this, string, string2));
    }

    @Override
    public String getRuntimePath() throws CoreException {
        String string = this.getProjectPath();
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string2 = (String)map.get("android.runtime_path");
        String string3 = "";
        if (string2 != null && !"".equals(string2)) {
            string3 = String.valueOf(string) + File.separator + string2;
        }
        return string3;
    }

    boolean a(IDevice iDevice) {
        boolean bl = false;
        try {
            b b2 = new b(this);
            iDevice.executeShellCommand(String.format("pm path %s", this.getPackageName()), (IShellOutputReceiver)b2);
            while (!b2.bc) {
            }
            if (b2.getResult().indexOf(".apk") != -1) {
                bl = true;
            }
        }
        catch (Throwable throwable) {}
        return bl;
    }

    boolean b(IDevice iDevice) throws CoreException {
        String string = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + iDevice.getName() + ".json";
        IConfiguration iConfiguration = ConfigurationManager.getConfiguration((String)string);
        InstalledRuntimeConfig installedRuntimeConfig = (InstalledRuntimeConfig)iConfiguration.getConfig(InstalledRuntimeConfig.class);
        if (installedRuntimeConfig == null) {
            return true;
        }
        long l2 = installedRuntimeConfig.getInstalledModifiedTime(this.aV);
        long l3 = new File(this.getRuntimePath()).lastModified();
        return l3 > l2;
    }

    void c(IDevice iDevice) throws CoreException {
        String string = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + iDevice.getName() + ".json";
        IConfiguration iConfiguration = ConfigurationManager.getConfiguration((String)string);
        InstalledRuntimeConfig installedRuntimeConfig = (InstalledRuntimeConfig)iConfiguration.getConfig(InstalledRuntimeConfig.class);
        if (installedRuntimeConfig == null) {
            installedRuntimeConfig = new InstalledRuntimeConfig();
        }
        long l2 = new File(this.getRuntimePath()).lastModified();
        installedRuntimeConfig.setInstalledModifiedTime(this.aV, l2);
        iConfiguration.save((Object)installedRuntimeConfig);
    }

    void a(IDevice iDevice, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.b(iDevice) && this.a(iDevice)) {
            return;
        }
        try {
            iProgressMonitor.setTaskName(Messages.android_runtime_installing_runtime_task);
            if (!this.isRuntimeExisted()) {
                CocosLogger.getLogger((String)"AndroidRuntime").error((Object)(String.valueOf(this.getRuntimePath()) + " is not exist"));
                Dialogs.openLaunchConfigurationDialog((String)NLS.bind((String)Messages.runtime_not_exist_msg, (Object)this.getRuntimePath()), (String)this.mode);
                throw this.a(Messages.runtime_not_exist, null);
            }
            String string = iDevice.installPackage(this.getRuntimePath(), true, new String[0]);
            String string2 = string == null ? "success!" : "error:" + string;
            ConsoleFactory.showLine((String)(String.valueOf(Messages.android_runtime_install_runtime_reslut_log) + string2), (boolean)true);
            if (string != null) {
                CocosLogger.getLogger((String)"AndroidRuntime").error((Object)(String.valueOf(Messages.android_runtime_install_apk_err_msg) + string));
                Dialogs.showMessageDialog((String)(String.valueOf(Messages.android_runtime_install_apk_err_msg) + string));
                throw this.a(Messages.android_runtime_install_apk_err, null);
            }
            CocosLogger.getLogger((String)"AndroidRuntime").info((Object)"Install apk success");
            this.c(iDevice);
        }
        catch (InstallException installException) {
            CocosLogger.getLogger((String)"AndroidRuntime").error((Object)String.format("InstallException %s", installException.getMessage()));
            Dialogs.showMessageDialog((String)Messages.android_runtime_install_runtime_err_msg);
            throw this.a(Messages.android_runtime_install_runtime_err, null);
        }
        catch (CoreException coreException) {
            throw coreException;
        }
    }

    @Override
    public String getRuntimeIP() throws CoreException {
        if (this.t()) {
            return "127.0.0.1";
        }
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string = (String)map.get("android.host");
        if (string == null || "".equals(string) || "127.0.0.1".equals(string)) {
            Dialogs.openLaunchConfigurationDialog((String)Messages.android_runtime_please_set_ip_of_device_msg, (String)this.mode);
            throw this.a(Messages.android_runtime_please_set_ip_of_device_err, null);
        }
        return string;
    }

    @Override
    int getConsolePort() throws CoreException {
        if (this.t()) {
            return 10089;
        }
        return 6010;
    }

    @Override
    int r() throws CoreException {
        if (this.t()) {
            return 10091;
        }
        return 6020;
    }

    String getPackageName() throws CoreException {
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string = (String)map.get("android.package_name");
        if (string == null || "".equals(string)) {
            Dialogs.openLaunchConfigurationDialog((String)Messages.android_runtime_please_set_package_name_msg, (String)this.mode);
            throw this.a(Messages.android_runtime_please_set_package_name_err, null);
        }
        return string;
    }

    String s() throws CoreException {
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string = (String)map.get("android.launch_activity");
        if (string == null || "".equals(string)) {
            Dialogs.openLaunchConfigurationDialog((String)Messages.android_runtime_please_set_launch_activity_msg, (String)this.mode);
            throw this.a(Messages.android_runtime_please_set_launch_activity_err, null);
        }
        return string;
    }

    boolean t() throws CoreException {
        Map map = this.bh.getAttribute(this.id(), new HashMap());
        String string = (String)map.get("android.use_adb");
        return Boolean.valueOf(string);
    }

    @Override
    public boolean isUseDevice() throws CoreException {
        return true;
    }
}

