/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.log;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JsonLog {
    private static JsonLog singleton;
    private String pluginId;
    private ILog log;

    private JsonLog(String pluginId, ILog log) {
        this.pluginId = pluginId;
        this.log = log;
    }

    public static JsonLog getInstance(String pluginId, ILog log) {
        if (singleton != null) {
            return singleton;
        }
        singleton = new JsonLog(pluginId, log);
        return singleton;
    }

    public static void logInfo(String message) {
        JsonLog.log(1, 0, message, null);
    }

    public static void logError(Throwable exception) {
        JsonLog.logError("Unexpected Exception", exception);
    }

    public static void logError(String message, Throwable exception) {
        JsonLog.log(4, 0, message, exception);
    }

    public static void log(int severity, int code, String message, Throwable exception) {
        JsonLog.log(JsonLog.createStatus(severity, code, message, exception));
    }

    public static IStatus createStatus(int severity, int code, String message, Throwable exception) {
        return new Status(severity, JsonLog.singleton.pluginId, code, message, exception);
    }

    public static void log(IStatus status) {
        JsonLog.singleton.log.log(status);
    }
}

