/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.model.single;

import com.boothen.jsonedit.core.util.reader.JsonReader;
import com.boothen.jsonedit.core.util.reader.JsonReaderException;
import com.boothen.jsonedit.model.JsonModel;
import com.boothen.jsonedit.model.JsonModelType;
import com.boothen.jsonedit.model.JsonString;
import com.boothen.jsonedit.model.single.JsonModelBuilder;
import org.eclipse.jface.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStringBuilder
implements JsonModelBuilder {
    public static final char DOUBLE_QUOTE = '\"';
    private static final Logger LOG = LoggerFactory.getLogger(JsonStringBuilder.class);

    @Override
    public JsonModel buildModel(JsonReader parser) throws JsonReaderException {
        int openingOffset = parser.getPosition();
        char ch = '\uffff';
        StringBuilder stringBuilder = new StringBuilder("" + parser.getCurrent());
        do {
            ch = parser.getNextChar();
            stringBuilder.append(ch);
        } while (ch != '\"' && parser.getPrevious() != '\\' && ch != 65535);
        if (ch == '\uffff') {
            return new JsonModel(JsonModelType.Error, new Position(parser.getPosition(), 0), new Position(openingOffset, parser.getPosition() - openingOffset));
        }
        ch = parser.getNextChar();
        LOG.debug("JsonStringBuilder: " + stringBuilder.toString());
        return new JsonString(stringBuilder.toString(), new Position(openingOffset, parser.getPosition() - openingOffset), new Position(openingOffset, parser.getPosition() - openingOffset));
    }
}

