/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.model.single;

import com.boothen.jsonedit.core.util.reader.JsonReader;
import com.boothen.jsonedit.core.util.reader.JsonReaderException;
import com.boothen.jsonedit.model.JsonModel;
import com.boothen.jsonedit.model.JsonModelType;
import com.boothen.jsonedit.model.JsonObject;
import com.boothen.jsonedit.model.single.JsonErrorBuilder;
import com.boothen.jsonedit.model.single.JsonModelBuilder;
import com.boothen.jsonedit.model.single.JsonModelBuilderFactory;
import java.util.LinkedList;
import org.eclipse.jface.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObjectBuilder
implements JsonModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JsonObjectBuilder.class);
    private static final JsonModelBuilderFactory JSON_MODEL_BUILDER_FACTORY = new JsonModelBuilderFactory();
    public static final char OPEN_OBJECT = '{';
    public static final char CLOSE_OBJECT = '}';

    @Override
    public JsonModel buildModel(JsonReader parser) throws JsonReaderException {
        char ch;
        LOG.debug("JsonObjectBuilder");
        LinkedList<JsonModel> pairModels = new LinkedList<JsonModel>();
        boolean success = true;
        int openingOffset = parser.getPosition();
        do {
            JsonModelBuilder jsonModelBuilder;
            if ((jsonModelBuilder = JSON_MODEL_BUILDER_FACTORY.getPairModelBuilder(ch = parser.getNextClean())) != null) {
                JsonModel pairModel = jsonModelBuilder.buildModel(parser);
                pairModels.add(pairModel);
            }
            if (!(jsonModelBuilder instanceof JsonErrorBuilder)) continue;
            success = false;
            break;
        } while ((ch = parser.getCurrent()) == ',');
        if (success && ch != '}') {
            success = false;
            pairModels.add(new JsonModel(JsonModelType.Error, new Position(parser.getPosition(), 0), new Position(openingOffset, parser.getPosition() - openingOffset)));
        }
        if (success) {
            ch = parser.getNextClean();
        }
        return new JsonObject(pairModels, new Position(openingOffset, parser.getPosition() - openingOffset), new Position(openingOffset, parser.getPosition() - openingOffset));
    }
}

