/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.model.single;

import com.boothen.jsonedit.model.single.JsonArrayBuilder;
import com.boothen.jsonedit.model.single.JsonErrorBuilder;
import com.boothen.jsonedit.model.single.JsonFalseBuilder;
import com.boothen.jsonedit.model.single.JsonModelBuilder;
import com.boothen.jsonedit.model.single.JsonNullBuilder;
import com.boothen.jsonedit.model.single.JsonNumberBuilder;
import com.boothen.jsonedit.model.single.JsonObjectBuilder;
import com.boothen.jsonedit.model.single.JsonPairBuilder;
import com.boothen.jsonedit.model.single.JsonStringBuilder;
import com.boothen.jsonedit.model.single.JsonTrueBuilder;

public class JsonModelBuilderFactory {
    public JsonModelBuilder getContainerModelBuilder(char ch) {
        JsonModelBuilder jsonModelBuilder = this.getObjectModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        jsonModelBuilder = this.getArrayModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        return new JsonErrorBuilder();
    }

    public JsonModelBuilder getPairModelBuilder(char ch) {
        if (ch == '}') {
            return null;
        }
        if (ch == '\"') {
            return new JsonPairBuilder();
        }
        return new JsonErrorBuilder();
    }

    public JsonModelBuilder getValueModelBuilder(char ch) {
        JsonModelBuilder jsonModelBuilder = this.getStringModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        jsonModelBuilder = this.getObjectModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        jsonModelBuilder = this.getArrayModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        jsonModelBuilder = this.getTrueModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        jsonModelBuilder = this.getFalseModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        jsonModelBuilder = this.getNumberModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        jsonModelBuilder = this.getNullModelBuilder(ch);
        if (jsonModelBuilder != null) {
            return jsonModelBuilder;
        }
        return new JsonErrorBuilder();
    }

    private JsonModelBuilder getTrueModelBuilder(char ch) {
        if (ch == 't') {
            return new JsonTrueBuilder();
        }
        return null;
    }

    private JsonModelBuilder getFalseModelBuilder(char ch) {
        if (ch == 'f') {
            return new JsonFalseBuilder();
        }
        return null;
    }

    private JsonModelBuilder getNullModelBuilder(char ch) {
        if (ch == 'n') {
            return new JsonNullBuilder();
        }
        return null;
    }

    private JsonModelBuilder getNumberModelBuilder(char ch) {
        if (JsonNumberBuilder.isStartOfNumber(ch)) {
            return new JsonNumberBuilder();
        }
        return null;
    }

    private JsonModelBuilder getObjectModelBuilder(char ch) {
        if (ch == '{') {
            return new JsonObjectBuilder();
        }
        return null;
    }

    private JsonModelBuilder getArrayModelBuilder(char ch) {
        if (ch == '[') {
            return new JsonArrayBuilder();
        }
        return null;
    }

    private JsonModelBuilder getStringModelBuilder(char ch) {
        if (ch == '\"') {
            return new JsonStringBuilder();
        }
        return null;
    }
}

