/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.model.single;

import com.boothen.jsonedit.core.util.reader.JsonReader;
import com.boothen.jsonedit.core.util.reader.JsonReaderException;
import com.boothen.jsonedit.model.JsonArray;
import com.boothen.jsonedit.model.JsonModel;
import com.boothen.jsonedit.model.JsonModelType;
import com.boothen.jsonedit.model.single.JsonErrorBuilder;
import com.boothen.jsonedit.model.single.JsonModelBuilder;
import com.boothen.jsonedit.model.single.JsonModelBuilderFactory;
import java.util.LinkedList;
import org.eclipse.jface.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonArrayBuilder
implements JsonModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JsonArrayBuilder.class);
    private static final JsonModelBuilderFactory JSON_MODEL_BUILDER_FACTORY = new JsonModelBuilderFactory();
    public static final char OPEN_ARRAY = '[';
    public static final char CLOSE_ARRAY = ']';

    @Override
    public JsonModel buildModel(JsonReader parser) throws JsonReaderException {
        char ch;
        LOG.debug("JsonArrayBuilder");
        LinkedList<JsonModel> valueModels = new LinkedList<JsonModel>();
        boolean success = true;
        int openingOffset = parser.getPosition();
        do {
            JsonModelBuilder jsonModelBuilder;
            if ((jsonModelBuilder = JSON_MODEL_BUILDER_FACTORY.getValueModelBuilder(ch = parser.getNextClean())) != null) {
                JsonModel valueModel = jsonModelBuilder.buildModel(parser);
                valueModels.add(valueModel);
            }
            if (!(jsonModelBuilder instanceof JsonErrorBuilder)) continue;
            success = false;
            break;
        } while ((ch = parser.getCurrent()) == ',');
        if (success && ch != ']') {
            success = false;
            valueModels.add(new JsonModel(JsonModelType.Error, new Position(parser.getPosition(), 0), new Position(openingOffset, parser.getPosition() - openingOffset)));
        }
        if (success) {
            ch = parser.getNextClean();
        }
        return new JsonArray(valueModels, new Position(openingOffset, parser.getPosition() - openingOffset), new Position(openingOffset, parser.getPosition() - openingOffset));
    }
}

