/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.core.model.node;

import com.boothen.jsonedit.core.model.node.Node;
import com.boothen.jsonedit.core.model.node.Type;
import com.boothen.jsonedit.core.util.JsonCharUtility;
import com.boothen.jsonedit.core.util.reader.JsonDocReader;
import com.boothen.jsonedit.core.util.reader.JsonReader;
import com.boothen.jsonedit.core.util.reader.JsonReaderException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class NodeBuilder {
    private IDocument fDocument;
    private JsonReader parser;
    private List<Node> nodes;

    public NodeBuilder(IDocument document) {
        this.fDocument = document;
    }

    public List<Node> buildNodes() {
        this.nodes = new LinkedList<Node>();
        this.parser = new JsonDocReader(this.fDocument);
        try {
            char ch;
            do {
                Node node;
                if ((node = this.buildNode(ch = this.parser.getNextClean())) == null) continue;
                this.nodes.add(node);
            } while (ch != '\uffff');
        }
        catch (JsonReaderException jsonReaderException) {
            return null;
        }
        this.parseNodes(this.nodes);
        return this.nodes;
    }

    private Node buildNode(char ch) {
        if (JsonCharUtility.isJsonChar((char)ch, (char)this.parser.getPrevious())) {
            Node node = new Node(NodeBuilder.getJsonCharType(ch));
            node.setPosition(this.parser.getPosition(), 1);
            node.setValue(String.valueOf(ch));
            return node;
        }
        return null;
    }

    private void parseNodes(List<Node> nodes) {
        int i = 0;
        while (i < nodes.size() - 1) {
            Node node = nodes.get(i);
            Node node2 = nodes.get(i + 1);
            this.compareNodes(node, node2, i);
            ++i;
        }
    }

    private void compareNodes(Node node, Node node2, int index) {
        if (node.getType() == Type.OpenObject) {
            this.compareOpenObject(node, node2, index);
        }
        if (node.getType() == Type.Quote) {
            this.compareQuote(node, node2, index);
        }
        if (node.getType() == Type.OpenArray) {
            this.compareOpenArray(node, node2, index);
        }
        if (node.getType() == Type.Colon) {
            this.compareColon(node, node2, index);
        }
        if (node.getType() == Type.Comma) {
            this.compareComma(node, node2, index);
        }
        if (node.getType() == Type.CloseArray) {
            this.compareCloseArray(node, node2, index);
        }
        if (node.getType() == Type.CloseObject) {
            this.compareCloseObject(node, node2, index);
        }
    }

    private void compareCloseObject(Node node, Node node2, int index) {
        if (node2.getType() == Type.Comma || node2.getType() == Type.CloseArray || node2.getType() == Type.CloseObject) {
            this.checkForText(node, node2, index);
        } else {
            this.doError(node, node2, index);
        }
    }

    private void compareCloseArray(Node node, Node node2, int index) {
        if (node2.getType() == Type.Comma || node2.getType() == Type.CloseArray || node2.getType() == Type.CloseObject) {
            this.checkForText(node, node2, index);
        } else {
            this.doError(node, node2, index);
        }
    }

    private void compareComma(Node node, Node node2, int index) {
        if (node2.getType() == Type.Quote || node2.getType() == Type.OpenArray || node2.getType() == Type.OpenObject) {
            this.checkForText(node, node2, index);
        } else if (node2.getType() == Type.Comma || node2.getType() == Type.CloseArray) {
            this.buildValue(node, node2, index);
        } else {
            this.doError(node, node2, index);
        }
    }

    private void compareColon(Node node, Node node2, int index) {
        if (node2.getType() == Type.Comma || node2.getType() == Type.CloseObject) {
            this.buildValue(node, node2, index);
        } else if (node2.getType() == Type.Quote) {
            this.checkForText(node, node2, index);
        } else {
            if (node2.getType() == Type.OpenArray || node2.getType() == Type.OpenObject) {
                return;
            }
            this.doError(node, node2, index);
        }
    }

    private void compareOpenArray(Node node, Node node2, int index) {
        if (node2.getType() == Type.CloseArray || node2.getType() == Type.Comma) {
            this.buildValue(node, node2, index);
        } else if (node2.getType() == Type.Quote || node2.getType() == Type.OpenArray || node2.getType() == Type.OpenObject) {
            this.checkForText(node, node2, index);
        } else {
            this.doError(node, node2, index);
        }
    }

    private void compareOpenObject(Node node, Node node2, int index) {
        if (node2.getType() == Type.Quote || node2.getType() == Type.CloseObject) {
            this.checkForText(node, node2, index);
        } else {
            this.doError(node, node2, index);
        }
    }

    private void compareQuote(Node node, Node node2, int index) {
        if (node2.getType() == Type.Quote) {
            this.buildString(node, node2, index);
        } else if (node2.getType() == Type.Colon || node2.getType() == Type.Comma || node2.getType() == Type.CloseArray || node2.getType() == Type.CloseObject) {
            this.checkForText(node, node2, index);
        } else {
            this.doError(node, node2, index);
        }
    }

    private void checkForText(Node node, Node node2, int index) {
        int offset = node.getEnd();
        int length = node2.getStart() - offset;
        try {
            String text = this.fDocument.get(offset, length);
            if (!text.trim().isEmpty()) {
                this.addErrorNode(text, offset, length, index);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void buildString(Node node, Node node2, int index) {
        int offset = node.getEnd();
        int length = node2.getStart() - offset;
        try {
            String text = this.fDocument.get(offset, length);
            if (text != null && !text.trim().isEmpty()) {
                this.addNode(text, offset, length, index, Type.String);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void buildValue(Node node, Node node2, int index) {
        int offset = node.getEnd();
        int length = node2.getStart() - offset;
        try {
            String text = this.fDocument.get(offset, length);
            String trimmedText = text.trim();
            if ("null".equals(trimmedText)) {
                this.addNode(trimmedText, offset, length, index, Type.Null);
            } else if ("true".equals(trimmedText)) {
                this.addNode(trimmedText, offset, length, index, Type.True);
            } else if ("false".equals(trimmedText)) {
                this.addNode(trimmedText, offset, length, index, Type.False);
            } else if (this.isANumber(trimmedText)) {
                this.addNode(trimmedText, offset, length, index, Type.Number);
            } else {
                this.checkForText(node, node2, index);
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    private boolean isANumber(String text) {
        try {
            Float.parseFloat(text);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void addNode(String text, int offset, int length, int index, Type type) {
        Node node = new Node(type);
        node.setPosition(offset, length);
        node.setValue(text);
        this.nodes.add(index + 1, node);
    }

    private void doError(Node node, Node node2, int index) {
        int offset = node.getEnd();
        int length = node2.getStart() - offset;
        this.addErrorNode("Error", offset, length, index);
    }

    private void addErrorNode(String text, int offset, int length, int index) {
        Node errorNode = new Node(Type.Error);
        errorNode.setPosition(offset, length);
        errorNode.setValue(text.trim());
        this.nodes.add(index + 1, errorNode);
    }

    public static Type getJsonCharType(char ch) {
        if (ch == ',') {
            return Type.Comma;
        }
        if (ch == '{') {
            return Type.OpenObject;
        }
        if (ch == '}') {
            return Type.CloseObject;
        }
        if (ch == '[') {
            return Type.OpenArray;
        }
        if (ch == ']') {
            return Type.CloseArray;
        }
        if (ch == ':') {
            return Type.Colon;
        }
        if (ch == '\"') {
            return Type.Quote;
        }
        return null;
    }
}

