/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.core.model.node;

import com.boothen.jsonedit.core.model.jsonnode.JsonNode;
import com.boothen.jsonedit.core.model.node.Type;
import org.eclipse.jface.text.Position;

public class Node {
    private Type type;
    private Position position;
    private String value;
    private JsonNode owner;

    public Node(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Position getPosition() {
        return this.position;
    }

    public int getStart() {
        if (this.position != null && !this.position.isDeleted) {
            return this.position.getOffset();
        }
        return -1;
    }

    public void setStart(int start) {
        this.position = new Position(start);
    }

    public int getLength() {
        if (this.position != null && !this.position.isDeleted) {
            return this.position.getLength();
        }
        return -1;
    }

    public void setLength(int length) {
        this.position.setLength(length);
    }

    public void setPosition(int start, int length) {
        this.position = new Position(start, length);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value != null) {
            value.replaceAll("\\\"", "\"");
            this.value = value;
        }
    }

    public int getEnd() {
        if (this.position != null && !this.position.isDeleted) {
            return this.position.getOffset() + this.position.getLength();
        }
        return -1;
    }

    public JsonNode getOwner() {
        return this.owner;
    }

    public void setOwner(JsonNode owner) {
        this.owner = owner;
    }

    public String toString() {
        String toString = this.type.toString();
        toString = String.valueOf(toString) + ", " + this.position.offset + ", " + this.position.length;
        toString = String.valueOf(toString) + ", " + this.value;
        return toString;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.position == null ? other.position != null : !this.position.equals((Object)other.position)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

