/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.util;

import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import org.ccdt.jsdt.internal.core.JavaElement;
import org.ccdt.jsdt.internal.core.util.ICacheEnumeration;
import org.ccdt.jsdt.internal.core.util.ILRUCacheable;
import org.ccdt.jsdt.internal.core.util.LRUCache$1;
import org.ccdt.jsdt.internal.core.util.LRUCache$LRUCacheEntry;
import org.ccdt.jsdt.internal.core.util.ToStringSorter;

public class LRUCache
implements Cloneable {
    protected int fCurrentSpace = 0;
    protected int fSpaceLimit;
    protected int fTimestampCounter = 0;
    protected Hashtable fEntryTable;
    protected LRUCache$LRUCacheEntry fEntryQueue = null;
    protected LRUCache$LRUCacheEntry fEntryQueueTail = null;
    protected static final int DEFAULT_SPACELIMIT = 100;

    public LRUCache() {
        this(100);
    }

    public LRUCache(int n2) {
        this.fEntryTable = new Hashtable(n2);
        this.fSpaceLimit = n2;
    }

    public Object clone() {
        LRUCache lRUCache = this.newInstance(this.fSpaceLimit);
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = this.fEntryQueueTail;
        while (lRUCache$LRUCacheEntry != null) {
            lRUCache.privateAdd(lRUCache$LRUCacheEntry._fKey, lRUCache$LRUCacheEntry._fValue, lRUCache$LRUCacheEntry._fSpace);
            lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fPrevious;
        }
        return lRUCache;
    }

    public double fillingRatio() {
        return (double)this.fCurrentSpace * 100.0 / (double)this.fSpaceLimit;
    }

    public void flush() {
        this.fCurrentSpace = 0;
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = this.fEntryQueueTail;
        this.fEntryTable = new Hashtable();
        this.fEntryQueueTail = null;
        this.fEntryQueue = null;
        while (lRUCache$LRUCacheEntry != null) {
            lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fPrevious;
        }
    }

    public void flush(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return;
        }
        this.privateRemoveEntry(lRUCache$LRUCacheEntry, false);
    }

    public Object get(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return null;
        }
        this.updateTimestamp(lRUCache$LRUCacheEntry);
        return lRUCache$LRUCacheEntry._fValue;
    }

    public int getCurrentSpace() {
        return this.fCurrentSpace;
    }

    public int getSpaceLimit() {
        return this.fSpaceLimit;
    }

    public Enumeration keys() {
        return this.fEntryTable.keys();
    }

    public ICacheEnumeration keysAndValues() {
        return new LRUCache$1(this);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int var1_1) {
        var2_2 = this.getSpaceLimit();
        if (this.fCurrentSpace + var1_1 <= var2_2) {
            return true;
        }
        if (var1_1 <= var2_2) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.fEntryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.fCurrentSpace + var1_1 > var2_2 && this.fEntryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected LRUCache newInstance(int n2) {
        return new LRUCache(n2);
    }

    public Object peek(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return null;
        }
        return lRUCache$LRUCacheEntry._fValue;
    }

    protected void privateAdd(Object object, Object object2, int n2) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = new LRUCache$LRUCacheEntry(object, object2, n2);
        this.privateAddEntry(lRUCache$LRUCacheEntry, false);
    }

    protected void privateAddEntry(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry, boolean bl2) {
        if (!bl2) {
            this.fEntryTable.put(lRUCache$LRUCacheEntry._fKey, lRUCache$LRUCacheEntry);
            this.fCurrentSpace += lRUCache$LRUCacheEntry._fSpace;
        }
        lRUCache$LRUCacheEntry._fTimestamp = this.fTimestampCounter++;
        lRUCache$LRUCacheEntry._fNext = this.fEntryQueue;
        lRUCache$LRUCacheEntry._fPrevious = null;
        if (this.fEntryQueue == null) {
            this.fEntryQueueTail = lRUCache$LRUCacheEntry;
        } else {
            this.fEntryQueue._fPrevious = lRUCache$LRUCacheEntry;
        }
        this.fEntryQueue = lRUCache$LRUCacheEntry;
    }

    protected void privateNotifyDeletionFromCache(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry) {
    }

    protected void privateRemoveEntry(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry, boolean bl2) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry2 = lRUCache$LRUCacheEntry._fPrevious;
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry3 = lRUCache$LRUCacheEntry._fNext;
        if (!bl2) {
            this.fEntryTable.remove(lRUCache$LRUCacheEntry._fKey);
            this.fCurrentSpace -= lRUCache$LRUCacheEntry._fSpace;
        }
        if (lRUCache$LRUCacheEntry2 == null) {
            this.fEntryQueue = lRUCache$LRUCacheEntry3;
        } else {
            lRUCache$LRUCacheEntry2._fNext = lRUCache$LRUCacheEntry3;
        }
        if (lRUCache$LRUCacheEntry3 == null) {
            this.fEntryQueueTail = lRUCache$LRUCacheEntry2;
        } else {
            lRUCache$LRUCacheEntry3._fPrevious = lRUCache$LRUCacheEntry2;
        }
    }

    public Object put(Object object, Object object2) {
        int n2 = this.spaceFor(object2);
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry != null) {
            int n3 = lRUCache$LRUCacheEntry._fSpace;
            int n4 = this.getCurrentSpace() - n3 + n2;
            if (n4 <= this.getSpaceLimit()) {
                this.updateTimestamp(lRUCache$LRUCacheEntry);
                lRUCache$LRUCacheEntry._fValue = object2;
                lRUCache$LRUCacheEntry._fSpace = n2;
                this.fCurrentSpace = n4;
                return object2;
            }
            this.privateRemoveEntry(lRUCache$LRUCacheEntry, false);
        }
        if (this.makeSpace(n2)) {
            this.privateAdd(object, object2, n2);
        }
        return object2;
    }

    public Object removeKey(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return null;
        }
        Object object2 = lRUCache$LRUCacheEntry._fValue;
        this.privateRemoveEntry(lRUCache$LRUCacheEntry, false);
        return object2;
    }

    public void setSpaceLimit(int n2) {
        if (n2 < this.fSpaceLimit) {
            this.makeSpace(this.fSpaceLimit - n2);
        }
        this.fSpaceLimit = n2;
    }

    protected int spaceFor(Object object) {
        if (object instanceof ILRUCacheable) {
            return ((ILRUCacheable)object).getCacheFootprint();
        }
        return 1;
    }

    public String toString() {
        return String.valueOf(this.toStringFillingRation("LRUCache")) + this.toStringContents();
    }

    protected String toStringContents() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.fEntryTable.size();
        Object[] objectArray = new Object[n2];
        String[] stringArray = new String[n2];
        Enumeration enumeration = this.keys();
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = enumeration.nextElement();
            objectArray[n3] = e2;
            stringArray[n3] = e2 instanceof JavaElement ? ((JavaElement)e2).getElementName() : e2.toString();
            ++n3;
        }
        ToStringSorter toStringSorter = new ToStringSorter();
        toStringSorter.sort(objectArray, stringArray);
        int n4 = 0;
        while (n4 < n2) {
            String string = toStringSorter.b[n4];
            Object object = this.get(toStringSorter.a[n4]);
            stringBuffer.append(string);
            stringBuffer.append(" -> ");
            stringBuffer.append(object);
            stringBuffer.append("\n");
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String toStringFillingRation(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('[');
        stringBuffer.append(this.getSpaceLimit());
        stringBuffer.append("]: ");
        stringBuffer.append(NumberFormat.getInstance().format(this.fillingRatio()));
        stringBuffer.append("% full");
        return stringBuffer.toString();
    }

    protected void updateTimestamp(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry) {
        lRUCache$LRUCacheEntry._fTimestamp = this.fTimestampCounter++;
        if (this.fEntryQueue != lRUCache$LRUCacheEntry) {
            this.privateRemoveEntry(lRUCache$LRUCacheEntry, true);
            this.privateAddEntry(lRUCache$LRUCacheEntry, true);
        }
    }
}

