/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.util;

import org.ccdt.jsdt.internal.compiler.util.Util;

public class CharArrayBuffer {
    protected char[][] fBuffer;
    public static final int DEFAULT_BUFFER_SIZE = 10;
    protected int fEnd;
    protected int fSize;
    protected int[][] fRanges;

    public CharArrayBuffer() {
        this(null, 10);
    }

    public CharArrayBuffer(char[] cArray) {
        this(cArray, 10);
    }

    public CharArrayBuffer(char[] cArray, int n2) {
        this.fSize = n2 > 0 ? n2 : 10;
        this.fBuffer = new char[this.fSize][];
        this.fRanges = new int[this.fSize][];
        this.fEnd = 0;
        if (cArray != null) {
            this.append(cArray, 0, cArray.length);
        }
    }

    public CharArrayBuffer(int n2) {
        this(null, n2);
    }

    public CharArrayBuffer append(char[] cArray) {
        if (cArray != null) {
            this.append(cArray, 0, cArray.length);
        }
        return this;
    }

    public CharArrayBuffer append(char[] cArray, int n2, int n3) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (cArray != null) {
            int n4 = cArray.length;
            if (n2 > n4) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n3 + n2 > n4) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n3 > 0) {
                if (this.fEnd == this.fSize) {
                    int n5 = this.fSize * 2;
                    char[][] cArrayArray = new char[n5][];
                    this.fBuffer = cArrayArray;
                    System.arraycopy(this.fBuffer, 0, cArrayArray, 0, this.fSize);
                    int[][] nArrayArray = new int[n5][];
                    this.fRanges = nArrayArray;
                    System.arraycopy(this.fRanges, 0, nArrayArray, 0, this.fSize);
                    this.fSize *= 2;
                }
                this.fBuffer[this.fEnd] = cArray;
                this.fRanges[this.fEnd] = new int[]{n2, n3};
                ++this.fEnd;
            }
        }
        return this;
    }

    public CharArrayBuffer append(char c2) {
        this.append(new char[]{c2}, 0, 1);
        return this;
    }

    public CharArrayBuffer append(String string) {
        if (string != null) {
            this.append(string.toCharArray(), 0, string.length());
        }
        return this;
    }

    public char[] getContents() {
        if (this.fEnd == 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fEnd) {
            n2 += this.fRanges[n3][1];
            ++n3;
        }
        if (n2 > 0) {
            char[] cArray = new char[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.fEnd) {
                int[] nArray = this.fRanges[n5];
                int n6 = nArray[1];
                System.arraycopy(this.fBuffer[n5], nArray[0], cArray, n4, n6);
                n4 += n6;
                ++n5;
            }
            return cArray;
        }
        return null;
    }

    public String toString() {
        char[] cArray = this.getContents();
        return cArray != null ? new String(cArray) : Util.EMPTY_STRING;
    }
}

