/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.search.matching;

import org.ccdt.jsdt.internal.compiler.ast.Assignment;
import org.ccdt.jsdt.internal.compiler.ast.CompoundAssignment;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.NameReference;
import org.ccdt.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.ccdt.jsdt.internal.compiler.ast.Reference;
import org.ccdt.jsdt.internal.compiler.ast.SingleNameReference;
import org.ccdt.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.ccdt.jsdt.internal.core.search.matching.PatternLocator;
import org.ccdt.jsdt.internal.core.search.matching.VariablePattern;

public class VariableLocator
extends PatternLocator {
    protected VariablePattern pattern;

    public VariableLocator(VariablePattern variablePattern) {
        super(variablePattern);
        this.pattern = variablePattern;
    }

    @Override
    public int match(Expression expression, MatchingNodeSet matchingNodeSet) {
        if (this.pattern.writeAccess) {
            Expression expression2;
            if (this.pattern.readAccess) {
                return 0;
            }
            if (expression instanceof Assignment && (expression2 = ((Assignment)expression).lhs) instanceof Reference) {
                return this.matchReference((Reference)expression2, matchingNodeSet, true);
            }
        } else if (this.pattern.readAccess && expression instanceof Assignment && !(expression instanceof CompoundAssignment)) {
            Expression expression3 = ((Assignment)expression).lhs;
            matchingNodeSet.removePossibleMatch(expression3);
            matchingNodeSet.removeTrustedMatch(expression3);
        }
        return 0;
    }

    @Override
    public int match(Reference reference, MatchingNodeSet matchingNodeSet) {
        return this.pattern.readAccess ? this.matchReference(reference, matchingNodeSet, false) : 0;
    }

    protected int matchReference(Reference reference, MatchingNodeSet matchingNodeSet, boolean bl2) {
        if (reference instanceof NameReference) {
            if (this.pattern.name == null) {
                return matchingNodeSet.addMatch(reference, this.pattern.c ? 2 : 3);
            }
            if (reference instanceof SingleNameReference) {
                if (this.matchesName(this.pattern.name, ((SingleNameReference)reference).token)) {
                    return matchingNodeSet.addMatch(reference, this.pattern.c ? 2 : 3);
                }
            } else {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)reference;
                char[][] cArray = qualifiedNameReference.tokens;
                if (bl2) {
                    if (this.matchesName(this.pattern.name, cArray[cArray.length - 1])) {
                        return matchingNodeSet.addMatch(reference, 2);
                    }
                } else {
                    int n2 = 0;
                    int n3 = cArray.length;
                    while (n2 < n3) {
                        if (this.matchesName(this.pattern.name, cArray[n2])) {
                            return matchingNodeSet.addMatch(reference, 2);
                        }
                        ++n2;
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

