/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.search.matching;

import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IPackageFragment;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.ImportReference;
import org.ccdt.jsdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.ccdt.jsdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.ccdt.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.ccdt.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.ccdt.jsdt.internal.compiler.ast.Reference;
import org.ccdt.jsdt.internal.compiler.ast.TypeReference;
import org.ccdt.jsdt.internal.compiler.lookup.ArrayBinding;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.ImportBinding;
import org.ccdt.jsdt.internal.compiler.lookup.PackageBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ProblemBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.ccdt.jsdt.internal.compiler.lookup.TypeBinding;
import org.ccdt.jsdt.internal.core.search.matching.MatchLocator;
import org.ccdt.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.ccdt.jsdt.internal.core.search.matching.PackageReferencePattern;
import org.ccdt.jsdt.internal.core.search.matching.PatternLocator;
import org.ccdt.jsdt.internal.core.util.Util;
import org.eclipse.core.runtime.CoreException;

public class PackageReferenceLocator
extends PatternLocator {
    protected PackageReferencePattern pattern;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDeclaringPackageFragment(IPackageFragment iPackageFragment, ReferenceBinding referenceBinding) {
        char[] cArray = referenceBinding.getFileName();
        if (cArray == null) return true;
        cArray = CharOperation.replaceOnCopy(cArray, '/', '\\');
        cArray = CharOperation.lastSegment(cArray, '\\');
        try {
            switch (iPackageFragment.getKind()) {
                case 1: {
                    if (!Util.isJavaLikeFileName(cArray)) return false;
                    if (iPackageFragment.getJavaScriptUnit(new String(cArray)).exists()) return true;
                    return false;
                }
                case 2: {
                    if (!org.ccdt.jsdt.internal.compiler.util.Util.isClassFileName(cArray)) return false;
                    if (iPackageFragment.getClassFile(new String(cArray)).exists()) return true;
                    return false;
                }
            }
            return true;
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return true;
    }

    public PackageReferenceLocator(PackageReferencePattern packageReferencePattern) {
        super(packageReferencePattern);
        this.pattern = packageReferencePattern;
    }

    @Override
    public int match(ASTNode aSTNode, MatchingNodeSet matchingNodeSet) {
        if (!(aSTNode instanceof ImportReference)) {
            return 0;
        }
        return matchingNodeSet.addMatch(aSTNode, this.matchLevel((ImportReference)aSTNode));
    }

    @Override
    public int match(Reference reference, MatchingNodeSet matchingNodeSet) {
        if (!(reference instanceof QualifiedNameReference)) {
            return 0;
        }
        return matchingNodeSet.addMatch(reference, this.matchLevelForTokens(((QualifiedNameReference)reference).tokens));
    }

    @Override
    public int match(TypeReference typeReference, MatchingNodeSet matchingNodeSet) {
        if (typeReference instanceof JavadocSingleTypeReference) {
            char[][] cArrayArray = new char[][]{((JavadocSingleTypeReference)typeReference).token};
            return matchingNodeSet.addMatch(typeReference, this.matchLevelForTokens(cArrayArray));
        }
        if (!(typeReference instanceof QualifiedTypeReference)) {
            return 0;
        }
        return matchingNodeSet.addMatch(typeReference, this.matchLevelForTokens(((QualifiedTypeReference)typeReference).tokens));
    }

    @Override
    protected int matchLevel(ImportReference importReference) {
        return this.matchLevelForTokens(importReference.tokens);
    }

    protected int matchLevelForTokens(char[][] cArray) {
        if (this.pattern.pkgName == null) {
            return 3;
        }
        char[] cArray2 = null;
        if (this.isCamelCase && CharOperation.camelCaseMatch(this.pattern.pkgName, cArray2 = CharOperation.concatWith(cArray, '.'))) {
            return 2;
        }
        switch (this.matchMode) {
            case 0: 
            case 1: {
                if (cArray2 == null) {
                    cArray2 = CharOperation.concatWith(cArray, '.');
                }
                if (!CharOperation.prefixEquals(this.pattern.pkgName, cArray2, this.isCaseSensitive)) break;
                return 2;
            }
            case 2: {
                char[] cArray3;
                char[] cArray4 = cArray3 = this.pattern.pkgName[this.pattern.pkgName.length - 1] == '*' ? this.pattern.pkgName : CharOperation.concat(this.pattern.pkgName, ".*".toCharArray());
                if (cArray2 == null) {
                    cArray2 = CharOperation.concatWith(cArray, '.');
                }
                if (!CharOperation.match(cArray3, cArray2, this.isCaseSensitive)) break;
                return 2;
            }
        }
        return 0;
    }

    @Override
    protected void matchReportImportRef(ImportReference importReference, Binding binding, IJavaScriptElement iJavaScriptElement, int n2, MatchLocator matchLocator) throws CoreException {
        if (binding == null) {
            this.matchReportReference(importReference, iJavaScriptElement, null, n2, matchLocator);
        } else if (matchLocator.encloses(iJavaScriptElement)) {
            PackageBinding packageBinding;
            long[] lArray = importReference.sourcePositions;
            int n3 = lArray.length - 1;
            if (binding instanceof ProblemReferenceBinding) {
                binding = ((ProblemReferenceBinding)binding).closestMatch();
            }
            if (binding instanceof ReferenceBinding && (packageBinding = ((ReferenceBinding)binding).fPackage) != null) {
                n3 = packageBinding.compoundName.length;
            }
            if (binding instanceof PackageBinding) {
                n3 = ((PackageBinding)binding).compoundName.length;
            }
            int n4 = (int)(lArray[0] >>> 32);
            int n5 = (int)lArray[n3 - 1];
            this.b = matchLocator.newPackageReferenceMatch(iJavaScriptElement, n2, n4, n5 - n4 + 1, importReference);
            matchLocator.report(this.b);
        }
    }

    @Override
    protected void matchReportReference(ASTNode aSTNode, IJavaScriptElement iJavaScriptElement, Binding binding, int n2, MatchLocator matchLocator) throws CoreException {
        int n3;
        long[] lArray;
        block25: {
            Object object;
            Object object2;
            block27: {
                block26: {
                    block24: {
                        lArray = null;
                        n3 = -1;
                        if (!(aSTNode instanceof ImportReference)) break block24;
                        object2 = (ImportReference)aSTNode;
                        lArray = ((ImportReference)object2).sourcePositions;
                        n3 = (((ImportReference)object2).bits & 0x20000) != 0 ? lArray.length : lArray.length - 1;
                        break block25;
                    }
                    object2 = null;
                    if (!(aSTNode instanceof QualifiedNameReference)) break block26;
                    object = (QualifiedNameReference)aSTNode;
                    lArray = ((QualifiedNameReference)object).sourcePositions;
                    switch (((QualifiedNameReference)object).bits & 0xF) {
                        case 1: {
                            object2 = ((QualifiedNameReference)object).actualReceiverType;
                            break;
                        }
                        case 4: {
                            if (((QualifiedNameReference)object).binding instanceof TypeBinding) {
                                object2 = (TypeBinding)((QualifiedNameReference)object).binding;
                                break;
                            }
                            break block27;
                        }
                        case 3: 
                        case 7: {
                            Binding binding2 = ((QualifiedNameReference)object).binding;
                            if (binding2 instanceof TypeBinding) {
                                object2 = (TypeBinding)binding2;
                                break;
                            }
                            if (binding2 instanceof ProblemFieldBinding) {
                                object2 = ((QualifiedNameReference)object).actualReceiverType;
                                n3 = ((QualifiedNameReference)object).tokens.length - (((QualifiedNameReference)object).otherBindings == null ? 2 : ((QualifiedNameReference)object).otherBindings.length + 2);
                                break;
                            }
                            if (!(binding2 instanceof ProblemBinding)) break block27;
                            ProblemBinding problemBinding = (ProblemBinding)binding2;
                            object2 = problemBinding.searchType;
                            n3 = CharOperation.occurencesOf('.', problemBinding.name);
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block27;
                }
                if (aSTNode instanceof QualifiedTypeReference) {
                    object = (QualifiedTypeReference)aSTNode;
                    lArray = ((QualifiedTypeReference)object).sourcePositions;
                    object2 = ((QualifiedTypeReference)object).resolvedType;
                } else if (aSTNode instanceof JavadocSingleTypeReference) {
                    object = (JavadocSingleTypeReference)aSTNode;
                    lArray = new long[]{((long)((JavadocSingleTypeReference)object).sourceStart << 32) + (long)((JavadocSingleTypeReference)object).sourceEnd};
                    object2 = ((JavadocSingleTypeReference)object).resolvedType;
                }
            }
            if (lArray == null) {
                return;
            }
            if (object2 instanceof ArrayBinding) {
                object2 = ((ArrayBinding)object2).leafComponentType;
            }
            if (object2 instanceof ProblemReferenceBinding) {
                object2 = ((ProblemReferenceBinding)object2).closestMatch();
            }
            if (object2 instanceof ReferenceBinding && (object = ((ReferenceBinding)object2).fPackage) != null) {
                n3 = ((PackageBinding)object).compoundName.length;
            }
            Object object3 = object = object2 == null ? null : ((TypeBinding)object2).enclosingType();
            if (object != null) {
                int n4 = lArray.length;
                while (object != null && n4 > 0) {
                    --n4;
                    object = ((TypeBinding)object).enclosingType();
                }
                if (n4 <= 1) {
                    return;
                }
            }
        }
        if (n3 == -1) {
            n3 = this.pattern.segments.length;
        }
        if (n3 == 0) {
            return;
        }
        if (n3 > lArray.length) {
            n3 = lArray.length;
        }
        int n5 = (int)(lArray[0] >>> 32);
        int n6 = (int)lArray[n3 - 1];
        this.b = matchLocator.newPackageReferenceMatch(iJavaScriptElement, n2, n5, n6 - n5 + 1, aSTNode);
        matchLocator.report(this.b);
    }

    @Override
    protected int referenceType() {
        return 4;
    }

    @Override
    public int resolveLevel(ASTNode aSTNode) {
        if (aSTNode instanceof JavadocQualifiedTypeReference) {
            JavadocQualifiedTypeReference javadocQualifiedTypeReference = (JavadocQualifiedTypeReference)aSTNode;
            if (javadocQualifiedTypeReference.packageBinding != null) {
                return this.resolveLevel(javadocQualifiedTypeReference.packageBinding);
            }
            return this.resolveLevel(javadocQualifiedTypeReference.resolvedType);
        }
        if (aSTNode instanceof JavadocSingleTypeReference) {
            JavadocSingleTypeReference javadocSingleTypeReference = (JavadocSingleTypeReference)aSTNode;
            if (javadocSingleTypeReference.packageBinding != null) {
                return this.resolveLevel(javadocSingleTypeReference.packageBinding);
            }
            return 0;
        }
        if (aSTNode instanceof QualifiedTypeReference) {
            return this.resolveLevel(((QualifiedTypeReference)aSTNode).resolvedType);
        }
        if (aSTNode instanceof QualifiedNameReference) {
            return this.resolveLevel((QualifiedNameReference)aSTNode);
        }
        return 0;
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        char[][] cArray = null;
        if (binding instanceof ImportBinding) {
            cArray = ((ImportBinding)binding).compoundName;
        } else if (binding instanceof PackageBinding) {
            cArray = ((PackageBinding)binding).compoundName;
        } else {
            if (binding instanceof ArrayBinding) {
                binding = ((ArrayBinding)binding).leafComponentType;
            }
            if (binding instanceof ProblemReferenceBinding) {
                binding = ((ProblemReferenceBinding)binding).closestMatch();
            }
            if (binding == null) {
                return 1;
            }
            if (binding instanceof ReferenceBinding) {
                PackageBinding packageBinding = ((ReferenceBinding)binding).fPackage;
                if (packageBinding == null) {
                    return 1;
                }
                cArray = packageBinding.compoundName;
            }
        }
        if (cArray != null && this.matchesName(this.pattern.pkgName, CharOperation.concatWith(cArray, '.'))) {
            if (this.pattern.a instanceof IPackageFragment && binding instanceof ReferenceBinding && !PackageReferenceLocator.isDeclaringPackageFragment((IPackageFragment)this.pattern.a, (ReferenceBinding)binding)) {
                return 0;
            }
            return 3;
        }
        return 0;
    }

    protected int resolveLevel(QualifiedNameReference qualifiedNameReference) {
        TypeBinding typeBinding = null;
        switch (qualifiedNameReference.bits & 0xF) {
            case 1: {
                if (qualifiedNameReference.tokens.length < (qualifiedNameReference.otherBindings == null ? 3 : qualifiedNameReference.otherBindings.length + 3)) {
                    return 0;
                }
                typeBinding = qualifiedNameReference.actualReceiverType;
                break;
            }
            case 2: {
                return 0;
            }
            case 4: {
                if (!(qualifiedNameReference.binding instanceof TypeBinding)) break;
                typeBinding = (TypeBinding)qualifiedNameReference.binding;
                break;
            }
            case 3: 
            case 7: {
                Binding binding = qualifiedNameReference.binding;
                if (binding instanceof ProblemReferenceBinding) {
                    typeBinding = (TypeBinding)binding;
                    break;
                }
                if (binding instanceof ProblemFieldBinding) {
                    if (qualifiedNameReference.tokens.length < (qualifiedNameReference.otherBindings == null ? 3 : qualifiedNameReference.otherBindings.length + 3)) {
                        return 0;
                    }
                    typeBinding = qualifiedNameReference.actualReceiverType;
                    break;
                }
                if (!(binding instanceof ProblemBinding)) break;
                ProblemBinding problemBinding = (ProblemBinding)binding;
                if (CharOperation.occurencesOf('.', problemBinding.name) <= 0) {
                    return 1;
                }
                typeBinding = problemBinding.searchType;
            }
        }
        return this.resolveLevel(typeBinding);
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

