/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.search.matching;

import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.core.infer.InferredMethod;
import org.ccdt.jsdt.core.search.SearchMatch;
import org.ccdt.jsdt.internal.compiler.ast.ASTNode;
import org.ccdt.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.AllocationExpression;
import org.ccdt.jsdt.internal.compiler.ast.Argument;
import org.ccdt.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.ExplicitConstructorCall;
import org.ccdt.jsdt.internal.compiler.ast.Expression;
import org.ccdt.jsdt.internal.compiler.ast.FieldDeclaration;
import org.ccdt.jsdt.internal.compiler.ast.FieldReference;
import org.ccdt.jsdt.internal.compiler.ast.JavadocMessageSend;
import org.ccdt.jsdt.internal.compiler.ast.MessageSend;
import org.ccdt.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.ccdt.jsdt.internal.compiler.ast.SingleNameReference;
import org.ccdt.jsdt.internal.compiler.ast.TypeDeclaration;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.compiler.lookup.MethodBinding;
import org.ccdt.jsdt.internal.compiler.util.Util;
import org.ccdt.jsdt.internal.core.search.matching.ConstructorPattern;
import org.ccdt.jsdt.internal.core.search.matching.MatchLocator;
import org.ccdt.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.ccdt.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.core.runtime.CoreException;

public class ConstructorLocator
extends PatternLocator {
    protected ConstructorPattern pattern;

    public ConstructorLocator(ConstructorPattern constructorPattern) {
        super(constructorPattern);
        this.pattern = constructorPattern;
    }

    @Override
    public int match(ASTNode aSTNode, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!(aSTNode instanceof ExplicitConstructorCall)) {
            return 0;
        }
        if (!this.a(aSTNode, ((ExplicitConstructorCall)aSTNode).arguments)) {
            return 0;
        }
        return matchingNodeSet.addMatch(aSTNode, this.pattern.c ? 2 : 3);
    }

    @Override
    public int match(ConstructorDeclaration constructorDeclaration, MatchingNodeSet matchingNodeSet) {
        int n2 = this.pattern.findReferences ? this.matchLevelForReferences(constructorDeclaration) : 0;
        int n3 = this.pattern.findDeclarations ? this.matchLevelForDeclarations(constructorDeclaration) : 0;
        return matchingNodeSet.addMatch(constructorDeclaration, n2 >= n3 ? n2 : n3);
    }

    @Override
    public int match(Expression expression, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!(expression instanceof AllocationExpression)) {
            return 0;
        }
        AllocationExpression allocationExpression = (AllocationExpression)expression;
        char[] cArray = this.a(allocationExpression);
        if (cArray == null) {
            return 0;
        }
        if (this.a(cArray)) {
            return matchingNodeSet.addMatch(expression, this.pattern.c ? 2 : 3);
        }
        return 0;
    }

    private char[] a(AllocationExpression allocationExpression) {
        char[] cArray = null;
        if (allocationExpression.member instanceof SingleNameReference) {
            cArray = ((SingleNameReference)allocationExpression.member).token;
        } else if (allocationExpression.member instanceof FieldReference) {
            cArray = Util.getTypeName(allocationExpression.member);
        }
        return cArray;
    }

    private boolean a(char[] cArray) {
        int n2;
        char[] cArray2 = this.pattern.getSearchPrefix() != null ? this.pattern.getSearchPrefix() : this.pattern.declaringSimpleName;
        if (this.matchesName(cArray2, cArray)) {
            return true;
        }
        char[] cArray3 = this.pattern.declaringQualification;
        return this.pattern.getSearchPrefix() == null && cArray3 != null ? cArray3.length > 0 && this.matchesName(CharOperation.concat(cArray3, this.pattern.declaringSimpleName, '.'), cArray) : (n2 = CharOperation.lastIndexOf('.', cArray)) >= 0 && this.matchesName(cArray2, CharOperation.subarray(cArray, n2 + 1, cArray.length));
    }

    @Override
    public int match(FieldDeclaration fieldDeclaration, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (fieldDeclaration.type != null || !(fieldDeclaration.initialization instanceof AllocationExpression)) {
            return 0;
        }
        if (fieldDeclaration.binding != null && fieldDeclaration.binding.declaringClass != null && this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, fieldDeclaration.binding.declaringClass.sourceName())) {
            return 0;
        }
        return matchingNodeSet.addMatch(fieldDeclaration, this.pattern.c ? 2 : 3);
    }

    @Override
    public int match(MessageSend messageSend, MatchingNodeSet matchingNodeSet) {
        if ((messageSend.bits & 0x8000) == 0) {
            return 0;
        }
        if (this.pattern.declaringSimpleName == null || CharOperation.equals(messageSend.selector, this.pattern.declaringSimpleName)) {
            return matchingNodeSet.addMatch(messageSend, this.pattern.c ? 2 : 3);
        }
        return 0;
    }

    @Override
    public int match(TypeDeclaration typeDeclaration, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        return matchingNodeSet.addMatch(typeDeclaration, this.pattern.c ? 2 : 3);
    }

    @Override
    public int match(InferredMethod inferredMethod, MatchingNodeSet matchingNodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!inferredMethod.isConstructor) {
            return 0;
        }
        if (!this.a(inferredMethod.name)) {
            return 0;
        }
        boolean bl2 = false;
        if (this.pattern.parameterSimpleNames != null) {
            int n2;
            int n3 = this.pattern.parameterSimpleNames.length;
            Argument[] argumentArray = ((AbstractMethodDeclaration)((Object)inferredMethod.getFunctionDeclaration())).arguments;
            int n4 = n2 = argumentArray == null ? 0 : argumentArray.length;
            if (n3 != n2) {
                return 0;
            }
            int n5 = 0;
            while (n5 < n2) {
                if (argumentArray != null && !this.matchesTypeReference(this.pattern.parameterSimpleNames[n5], argumentArray[n5].type)) {
                    if (this.mayBeGeneric) {
                        if (!this.pattern.c) {
                            matchingNodeSet.mustResolve = true;
                            bl2 = true;
                        }
                    } else {
                        return 0;
                    }
                }
                ++n5;
            }
        }
        return matchingNodeSet.addMatch(inferredMethod, bl2 ? 2 : 3);
    }

    protected int matchConstructor(MethodBinding methodBinding) {
        int n2;
        if (!methodBinding.isConstructor()) {
            return 0;
        }
        int n3 = this.pattern.getSearchPrefix() != null ? this.resolveLevelUsingSearchPrefix(this.pattern.getSearchPrefix(), methodBinding.declaringClass) : this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, methodBinding.declaringClass);
        if (n3 == 0) {
            return 0;
        }
        int n4 = n2 = this.pattern.parameterNames != null ? this.pattern.parameterNames.length : 0;
        if (n2 > -1) {
            if (methodBinding.parameters == null) {
                return 1;
            }
            if (n2 != methodBinding.parameters.length) {
                return 0;
            }
            int n5 = 0;
            while (n5 < n2) {
                int n6 = this.resolveLevelForType(this.pattern.parameterSimpleNames[n5], this.pattern.parameterQualifications[n5], methodBinding.parameters[n5]);
                if (n3 > n6) {
                    if (n6 == 0) {
                        return 0;
                    }
                    n3 = n6;
                }
                ++n5;
            }
        }
        return n3;
    }

    @Override
    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 15;
        }
        return 2;
    }

    protected int matchLevelForReferences(ConstructorDeclaration constructorDeclaration) {
        ExplicitConstructorCall explicitConstructorCall = constructorDeclaration.constructorCall;
        if (explicitConstructorCall == null || explicitConstructorCall.accessMode != 1) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int n2;
            int n3 = this.pattern.parameterSimpleNames.length;
            Expression[] expressionArray = explicitConstructorCall.arguments;
            int n4 = n2 = expressionArray == null ? 0 : expressionArray.length;
            if (n3 != n2) {
                return 0;
            }
        }
        return this.pattern.c ? 2 : 3;
    }

    protected int matchLevelForDeclarations(ConstructorDeclaration constructorDeclaration) {
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, constructorDeclaration.getName())) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int n2;
            int n3 = this.pattern.parameterSimpleNames.length;
            Argument[] argumentArray = constructorDeclaration.arguments;
            int n4 = n2 = argumentArray == null ? 0 : argumentArray.length;
            if (n3 != n2) {
                return 0;
            }
        }
        return this.pattern.c ? 2 : 3;
    }

    boolean a(ASTNode aSTNode, Expression[] expressionArray) {
        if (this.pattern.parameterSimpleNames != null && (aSTNode.bits & 0x8000) != 0) {
            int n2;
            int n3;
            int n4 = n3 = this.pattern.parameterNames != null ? this.pattern.parameterNames.length : 0;
            if (n3 < 0) {
                n3 = this.pattern.parameterSimpleNames.length;
            }
            int n5 = n2 = expressionArray == null ? 0 : expressionArray.length;
            if (n3 != n2) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void matchReportReference(ASTNode aSTNode, IJavaScriptElement iJavaScriptElement, Binding binding, int n2, MatchLocator matchLocator) throws CoreException {
        boolean bl2;
        if (aSTNode instanceof TypeDeclaration || aSTNode instanceof FieldDeclaration) {
            super.matchReportReference(aSTNode, iJavaScriptElement, binding, n2, matchLocator);
            if (this.b != null) {
                return;
            }
        }
        this.b = matchLocator.newMethodReferenceMatch(iJavaScriptElement, binding, n2, -1, -1, true, aSTNode);
        if (this.b.getRule() == 0) {
            return;
        }
        boolean bl3 = bl2 = this.isErasureMatch && this.b.isErasure() || this.isEquivalentMatch && this.b.isEquivalent() || this.b.isExact();
        if (!bl2) {
            return;
        }
        int n3 = aSTNode.sourceStart;
        this.b.setOffset(n3);
        this.b.setLength(aSTNode.sourceEnd - n3 + 1);
        if (aSTNode instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode;
            if (fieldDeclaration.initialization instanceof QualifiedAllocationExpression) {
                matchLocator.reportAccurateEnumConstructorReference(this.b, fieldDeclaration, (QualifiedAllocationExpression)fieldDeclaration.initialization);
                return;
            }
        }
        matchLocator.report(this.b);
    }

    @Override
    public SearchMatch newDeclarationMatch(ASTNode aSTNode, IJavaScriptElement iJavaScriptElement, Binding binding, int n2, int n3, MatchLocator matchLocator) {
        this.b = null;
        int n4 = aSTNode.sourceStart;
        if (this.pattern.findReferences) {
            if (aSTNode instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
                if (abstractMethodDeclarationArray != null) {
                    int n5 = 0;
                    int n6 = abstractMethodDeclarationArray.length;
                    while (n5 < n6) {
                        AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n5];
                        this.b = matchLocator.newMethodReferenceMatch(iJavaScriptElement, binding, n2, n4, n3, abstractMethodDeclaration.isConstructor(), abstractMethodDeclaration);
                        ++n5;
                    }
                }
            } else if (aSTNode instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)aSTNode;
                this.b = matchLocator.newMethodReferenceMatch(iJavaScriptElement, binding, n2, n4, n3, constructorDeclaration.isConstructor(), constructorDeclaration);
            }
        }
        if (this.b != null) {
            return this.b;
        }
        return matchLocator.newDeclarationMatch(iJavaScriptElement, binding, n2, aSTNode.sourceStart, n3);
    }

    @Override
    public int resolveLevel(ASTNode aSTNode) {
        if (this.pattern.findReferences) {
            if (aSTNode instanceof AllocationExpression) {
                return this.resolveLevel((AllocationExpression)aSTNode);
            }
            if (aSTNode instanceof ExplicitConstructorCall) {
                return this.resolveLevel(((ExplicitConstructorCall)aSTNode).binding);
            }
            if (aSTNode instanceof TypeDeclaration) {
                return this.resolveLevel((TypeDeclaration)aSTNode);
            }
            if (aSTNode instanceof FieldDeclaration) {
                return this.resolveLevel((FieldDeclaration)aSTNode);
            }
            if (aSTNode instanceof JavadocMessageSend) {
                return this.resolveLevel(((JavadocMessageSend)aSTNode).binding);
            }
        }
        if (aSTNode instanceof ConstructorDeclaration) {
            return this.resolveLevel((ConstructorDeclaration)aSTNode, true);
        }
        return 0;
    }

    @Override
    protected int referenceType() {
        return 9;
    }

    protected int resolveLevel(AllocationExpression allocationExpression) {
        return this.resolveLevel(allocationExpression.binding);
    }

    protected int resolveLevel(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration.type != null || fieldDeclaration.binding == null) {
            return 0;
        }
        if (this.pattern.declaringSimpleName != null && !this.matchesName(this.pattern.declaringSimpleName, fieldDeclaration.binding.type.sourceName())) {
            return 0;
        }
        if (!(fieldDeclaration.initialization instanceof AllocationExpression) || fieldDeclaration.initialization.resolvedType.isLocalType()) {
            return 0;
        }
        return this.resolveLevel(((AllocationExpression)fieldDeclaration.initialization).binding);
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding methodBinding = (MethodBinding)binding;
        int n2 = this.matchConstructor(methodBinding);
        if (n2 == 0 && methodBinding != methodBinding.original()) {
            n2 = this.matchConstructor(methodBinding.original());
        }
        return n2;
    }

    protected int resolveLevel(ConstructorDeclaration constructorDeclaration, boolean bl2) {
        ExplicitConstructorCall explicitConstructorCall;
        int n2 = 0;
        if (this.pattern.findReferences && (explicitConstructorCall = constructorDeclaration.constructorCall) != null && explicitConstructorCall.accessMode == 1) {
            int n3;
            int n4 = explicitConstructorCall.arguments == null ? 0 : explicitConstructorCall.arguments.length;
            int n5 = n3 = this.pattern.parameterSimpleNames == null ? 0 : this.pattern.parameterSimpleNames.length;
            if (n3 != n4) {
                n2 = 0;
            } else {
                n2 = this.resolveLevel(explicitConstructorCall.binding);
                if (n2 == 3) {
                    return 3;
                }
            }
        }
        if (!bl2) {
            return n2;
        }
        int n6 = this.pattern.findDeclarations ? this.resolveLevel(constructorDeclaration.getBinding()) : 0;
        return n2 >= n6 ? n2 : n6;
    }

    protected int resolveLevel(TypeDeclaration typeDeclaration) {
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
        if (abstractMethodDeclarationArray != null) {
            int n2 = 0;
            int n3 = abstractMethodDeclarationArray.length;
            while (n2 < n3) {
                AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n2];
                if (abstractMethodDeclaration.isDefaultConstructor() && abstractMethodDeclaration.sourceStart < typeDeclaration.bodyStart) {
                    return this.resolveLevel((ConstructorDeclaration)abstractMethodDeclaration, false);
                }
                ++n2;
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

