/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;
import org.ccdt.jsdt.core.IIncludePathEntry;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.JavaScriptCore;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.core.search.IJavaScriptSearchScope;
import org.ccdt.jsdt.core.search.SearchDocument;
import org.ccdt.jsdt.core.search.SearchEngine;
import org.ccdt.jsdt.core.search.SearchParticipant;
import org.ccdt.jsdt.internal.compiler.ISourceElementRequestor;
import org.ccdt.jsdt.internal.compiler.SourceElementParser;
import org.ccdt.jsdt.internal.compiler.impl.CompilerOptions;
import org.ccdt.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.ccdt.jsdt.internal.compiler.util.SimpleLookupTable;
import org.ccdt.jsdt.internal.compiler.util.SimpleSet;
import org.ccdt.jsdt.internal.core.ClasspathEntry;
import org.ccdt.jsdt.internal.core.JavaModel;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.JavaProject;
import org.ccdt.jsdt.internal.core.LibraryFragmentRoot;
import org.ccdt.jsdt.internal.core.c.e;
import org.ccdt.jsdt.internal.core.search.a.a;
import org.ccdt.jsdt.internal.core.search.b;
import org.ccdt.jsdt.internal.core.search.indexing.AddFolderToIndex;
import org.ccdt.jsdt.internal.core.search.indexing.AddJarFileToIndex;
import org.ccdt.jsdt.internal.core.search.indexing.AddLibraryFileToIndex;
import org.ccdt.jsdt.internal.core.search.indexing.AddLibraryFolderToIndex;
import org.ccdt.jsdt.internal.core.search.indexing.IIndexConstants;
import org.ccdt.jsdt.internal.core.search.indexing.IndexAllProject;
import org.ccdt.jsdt.internal.core.search.indexing.IndexBinaryFolder;
import org.ccdt.jsdt.internal.core.search.indexing.IndexManager$1;
import org.ccdt.jsdt.internal.core.search.indexing.IndexRequest;
import org.ccdt.jsdt.internal.core.search.indexing.IndexingParser;
import org.ccdt.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.ccdt.jsdt.internal.core.search.indexing.RemoveFolderFromIndex;
import org.ccdt.jsdt.internal.core.search.indexing.RemoveFromIndex;
import org.ccdt.jsdt.internal.core.search.x;
import org.ccdt.jsdt.internal.core.util.Messages;
import org.ccdt.jsdt.internal.core.util.Util;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexManager
extends org.ccdt.jsdt.internal.core.search.a.b
implements IIndexConstants {
    public SimpleLookupTable indexLocations = new SimpleLookupTable();
    private SimpleLookupTable a = new SimpleLookupTable();
    private boolean b = false;
    private static final CRC32 c = new CRC32();
    private IPath d = null;
    private SimpleLookupTable e = null;
    private File f = new File(this.c(), "savedIndexNames.txt");
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);

    public synchronized void aboutToUpdateIndex(IPath iPath, Integer n2) {
        Integer n3;
        IPath iPath2 = this.computeIndexLocation(iPath);
        Object object = this.a().get(iPath2);
        Integer n4 = n3 = object == null ? UNKNOWN_STATE : (Integer)object;
        if (n3.equals(REBUILDING_STATE)) {
            return;
        }
        int n5 = n2.compareTo(n3);
        if (n5 > 0) {
            this.a(iPath2, n2);
        } else if (n5 < 0 && this.a.get(iPath2) == null) {
            this.a(iPath2, iPath);
        }
    }

    public void addBinary(IFile iFile, IPath iPath) {
        if (JavaScriptCore.getPlugin() == null) {
            return;
        }
        SearchParticipant searchParticipant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument searchDocument = searchParticipant.getDocument(iFile.getFullPath().toString());
        IPath iPath2 = this.computeIndexLocation(iPath);
        this.scheduleDocumentIndexing(searchDocument, iPath, iPath2, searchParticipant);
    }

    public void addSource(IFile iFile, IPath iPath, SourceElementParser sourceElementParser) {
        if (JavaScriptCore.getPlugin() == null) {
            return;
        }
        SearchParticipant searchParticipant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument searchDocument = searchParticipant.getDocument(iFile.getFullPath().toString());
        searchDocument.b = sourceElementParser;
        IPath iPath2 = this.computeIndexLocation(iPath);
        this.scheduleDocumentIndexing(searchDocument, iPath, iPath2, searchParticipant);
    }

    public void cleanUpIndexes() {
        SimpleSet simpleSet = new SimpleSet();
        IJavaScriptSearchScope iJavaScriptSearchScope = org.ccdt.jsdt.internal.core.search.b.a();
        x x2 = new x(null, SearchEngine.getDefaultSearchParticipant(), iJavaScriptSearchScope, null);
        e[] eArray = x2.a(null);
        int n2 = 0;
        int n3 = eArray.length;
        while (n2 < n3) {
            String string = eArray[n2].a().getAbsolutePath();
            simpleSet.add(string);
            ++n2;
        }
        if (this.e != null) {
            Object[] objectArray = this.e.keyTable;
            IPath[] iPathArray = new IPath[this.e.elementSize];
            int n4 = 0;
            int n5 = 0;
            int n6 = objectArray.length;
            while (n5 < n6) {
                IPath iPath = (IPath)objectArray[n5];
                if (iPath != null && !simpleSet.includes(iPath.toOSString())) {
                    iPathArray[n4++] = iPath;
                }
                ++n5;
            }
            if (n4 > 0) {
                this.a(iPathArray);
            }
        }
        this.a(simpleSet);
    }

    public IPath computeIndexLocation(IPath iPath) {
        IPath iPath2 = (IPath)this.indexLocations.get(iPath);
        if (iPath2 == null) {
            String string = iPath.toOSString();
            c.reset();
            c.update(string.getBytes());
            String string2 = String.valueOf(Long.toString(c.getValue())) + ".index";
            if (VERBOSE) {
                Util.verbose("-> index name for " + string + " is " + string2);
            }
            iPath2 = (IPath)this.a().getKey(this.b().append(string2));
            this.indexLocations.put(iPath, iPath2);
        }
        return iPath2;
    }

    public void deleteIndexFiles() {
        this.f.delete();
        this.a((SimpleSet)null);
    }

    private void a(SimpleSet simpleSet) {
        File[] fileArray = this.c().listFiles();
        if (fileArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = fileArray.length;
        while (n2 < n3) {
            String string = fileArray[n2].getAbsolutePath();
            if ((simpleSet == null || !simpleSet.includes(string)) && string.regionMatches(true, string.length() - ".index".length(), ".index", 0, ".index".length())) {
                if (VERBOSE) {
                    Util.verbose("Deleting index file " + fileArray[n2]);
                }
                fileArray[n2].delete();
            }
            ++n2;
        }
    }

    public void ensureIndexExists(IPath iPath, IPath iPath2) {
        SimpleLookupTable simpleLookupTable = this.a();
        Object object = simpleLookupTable.get(iPath);
        if (object == null) {
            this.a(iPath, REBUILDING_STATE);
            this.getIndex(iPath2, iPath, true, true);
        }
    }

    public SourceElementParser getSourceElementParser(IJavaScriptProject iJavaScriptProject, ISourceElementRequestor iSourceElementRequestor) {
        Map map = iJavaScriptProject.getOptions(true);
        map.put("org.ccdt.jsdt.core.compiler.taskTags", "");
        IndexingParser indexingParser = new IndexingParser(iSourceElementRequestor, new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(map), true, true, false);
        indexingParser.reportOnlyOneSyntaxError = true;
        indexingParser.javadocParser.checkDocComment = true;
        indexingParser.javadocParser.reportProblems = false;
        return indexingParser;
    }

    public synchronized e getIndex(IPath iPath, boolean bl2, boolean bl3) {
        IPath iPath2 = this.computeIndexLocation(iPath);
        return this.getIndex(iPath, iPath2, bl2, bl3);
    }

    public synchronized e getIndex(IPath iPath, IPath iPath2, boolean bl2, boolean bl3) {
        e e2 = this.getIndex(iPath2);
        if (e2 == null) {
            Integer n2;
            Object object = this.a().get(iPath2);
            Integer n3 = n2 = object == null ? UNKNOWN_STATE : (Integer)object;
            if (n2 == UNKNOWN_STATE) {
                this.a(iPath2, iPath);
                return null;
            }
            String string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
            String string2 = iPath2.toOSString();
            if (bl2) {
                block13: {
                    File file = new File(string2);
                    if (file.exists()) {
                        try {
                            e2 = new e(string2, string, true);
                            this.a.put(iPath2, e2);
                            return e2;
                        }
                        catch (IOException iOException) {
                            if (n2 == REBUILDING_STATE) break block13;
                            if (VERBOSE) {
                                Util.verbose("-> cannot reuse existing index: " + string2 + " path: " + string);
                            }
                            this.a(iPath2, iPath);
                            return null;
                        }
                    }
                }
                if (n2 == SAVED_STATE) {
                    this.a(iPath2, iPath);
                    return null;
                }
            }
            if (bl3) {
                try {
                    if (VERBOSE) {
                        Util.verbose("-> create empty index: " + string2 + " path: " + string);
                    }
                    e2 = new e(string2, string, false);
                    this.a.put(iPath2, e2);
                    return e2;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        Util.verbose("-> unable to create empty index: " + string2 + " path: " + string);
                    }
                    return null;
                }
            }
        }
        return e2;
    }

    public synchronized e getIndex(IPath iPath) {
        return (e)this.a.get(iPath);
    }

    public synchronized e getIndexForUpdate(IPath iPath, boolean bl2, boolean bl3) {
        IPath iPath2 = this.computeIndexLocation(iPath);
        if (this.a().get(iPath2) == REBUILDING_STATE) {
            return this.getIndex(iPath, iPath2, bl2, bl3);
        }
        return null;
    }

    private SimpleLookupTable a() {
        if (this.e != null) {
            return this.e;
        }
        this.e = new SimpleLookupTable();
        IPath iPath = this.b();
        char[][] cArray = this.a(iPath.toOSString());
        if (cArray != null) {
            int n2 = 1;
            int n3 = cArray.length;
            while (n2 < n3) {
                char[] cArray2 = cArray[n2];
                if (cArray2.length > 0) {
                    IPath iPath2 = iPath.append(new String(cArray2));
                    if (VERBOSE) {
                        Util.verbose("Reading saved index file " + iPath2);
                    }
                    this.e.put(iPath2, SAVED_STATE);
                }
                ++n2;
            }
        } else {
            this.deleteIndexFiles();
        }
        return this.e;
    }

    private IPath b() {
        if (this.d != null) {
            return this.d;
        }
        IPath iPath = JavaScriptCore.getPlugin().getStateLocation().addTrailingSeparator().append("indexes");
        try {
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath);
            if (!iFileStore.fetchInfo().exists()) {
                iFileStore.mkdir(4, null);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        this.d = iPath;
        return this.d;
    }

    private File c() {
        return new File(this.b().toOSString());
    }

    public void indexDocument(SearchDocument searchDocument, SearchParticipant searchParticipant, e e2, IPath iPath) {
        try {
            searchDocument.a = e2;
            searchParticipant.indexDocument(searchDocument, iPath);
        }
        finally {
            searchDocument.a = null;
        }
    }

    public void indexAll(IProject iProject) {
        Object object;
        if (JavaScriptCore.getPlugin() == null) {
            return;
        }
        try {
            object = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject javaProject = (JavaProject)((JavaModel)object).getJavaProject((IResource)iProject);
            IIncludePathEntry[] iIncludePathEntryArray = javaProject.getResolvedClasspath();
            int n2 = 0;
            while (n2 < iIncludePathEntryArray.length) {
                IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray[n2];
                if (iIncludePathEntry.getEntryKind() == 1) {
                    this.indexLibrary(iIncludePathEntry, iProject);
                }
                ++n2;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        object = new IndexAllProject(iProject, this);
        if (!this.isJobWaiting((a)object)) {
            this.request((a)object);
        }
    }

    public void indexLibrary(IIncludePathEntry iIncludePathEntry, IProject iProject) {
        if (JavaScriptCore.getPlugin() == null) {
            return;
        }
        IndexRequest indexRequest = null;
        Object object = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), iIncludePathEntry.getPath(), true);
        char[][] cArray = ((ClasspathEntry)iIncludePathEntry).fullInclusionPatternChars();
        char[][] cArray2 = ((ClasspathEntry)iIncludePathEntry).fullExclusionPatternChars();
        indexRequest = object instanceof IFolder || object instanceof IProject ? new AddLibraryFolderToIndex(iIncludePathEntry.getPath(), iProject, cArray, cArray2, this) : (object instanceof IFile ? new AddLibraryFileToIndex((IFile)object, this) : new AddLibraryFileToIndex(iIncludePathEntry.getPath(), cArray, cArray2, this));
        if (!this.isJobWaiting(indexRequest)) {
            this.request(indexRequest);
        }
    }

    public void indexLibrary(LibraryFragmentRoot libraryFragmentRoot, IProject iProject) {
        try {
            this.indexLibrary(libraryFragmentRoot.getRawIncludepathEntry(), iProject);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            javaScriptModelException.printStackTrace();
        }
    }

    public void indexSourceFolder(JavaProject javaProject, IPath iPath, char[][] cArray, char[][] cArray2) {
        IndexAllProject indexAllProject;
        IProject iProject = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(indexAllProject = new IndexAllProject(iProject, this))) {
            return;
        }
        this.request(new AddFolderToIndex(iPath, iProject, cArray, cArray2, this));
    }

    public synchronized void jobWasCancelled(IPath iPath) {
        IPath iPath2 = this.computeIndexLocation(iPath);
        e e2 = this.getIndex(iPath2);
        if (e2 != null) {
            e2.b = null;
            this.a.removeKey(iPath2);
        }
        this.a(iPath2, UNKNOWN_STATE);
    }

    @Override
    protected synchronized void moveToNextJob() {
        this.b = true;
        super.moveToNextJob();
    }

    @Override
    protected void notifyIdle(long l2) {
        if (l2 > 1000L && this.b) {
            this.saveIndexes();
        }
    }

    @Override
    public String processName() {
        return Messages.process_name;
    }

    private void a(IPath iPath, IPath iPath2) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace == null) {
            return;
        }
        Object object = JavaModel.getTarget((IContainer)iWorkspace.getRoot(), iPath2, true);
        if (object == null) {
            return;
        }
        if (VERBOSE) {
            Util.verbose("-> request to rebuild index: " + iPath + " path: " + iPath2);
        }
        this.a(iPath, REBUILDING_STATE);
        IndexRequest indexRequest = null;
        if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            if (JavaProject.hasJavaNature(iProject)) {
                indexRequest = new IndexAllProject(iProject, this);
            }
        } else if (object instanceof IFolder) {
            indexRequest = new IndexBinaryFolder((IContainer)((IFolder)object), this);
        } else if (object instanceof IFile && org.ccdt.jsdt.internal.compiler.util.Util.isArchiveFileName(((IFile)object).getName())) {
            indexRequest = new AddJarFileToIndex((IFile)object, this);
        } else if (object instanceof File) {
            indexRequest = org.ccdt.jsdt.internal.compiler.util.Util.isArchiveFileName(((File)object).getName()) ? new AddJarFileToIndex(iPath2, this) : new AddLibraryFileToIndex(iPath2, this);
        }
        if (indexRequest != null) {
            this.request(indexRequest);
        }
    }

    public synchronized e recreateIndex(IPath iPath) {
        String string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
        try {
            ReadWriteMonitor readWriteMonitor;
            IPath iPath2 = this.computeIndexLocation(iPath);
            e e2 = this.getIndex(iPath2);
            ReadWriteMonitor readWriteMonitor2 = readWriteMonitor = e2 == null ? null : e2.b;
            if (VERBOSE) {
                Util.verbose("-> recreating index: " + iPath2 + " for path: " + string);
            }
            e2 = new e(iPath2.toOSString(), string, false);
            this.a.put(iPath2, e2);
            e2.b = readWriteMonitor;
            return e2;
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                Util.verbose("-> failed to recreate index for path: " + string);
                iOException.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String string, IPath iPath) {
        this.request(new RemoveFromIndex(string, iPath, this));
    }

    public synchronized void removeIndex(IPath iPath) {
        if (VERBOSE) {
            Util.verbose("removing index " + iPath);
        }
        IPath iPath2 = this.computeIndexLocation(iPath);
        e e2 = this.getIndex(iPath2);
        File file = null;
        if (e2 != null) {
            e2.b = null;
            file = e2.a();
        }
        if (file == null) {
            file = new File(iPath2.toOSString());
        }
        if (file.exists()) {
            file.delete();
        }
        this.a.removeKey(iPath2);
        this.a(iPath2, (Integer)null);
    }

    public synchronized void removeIndexPath(IPath iPath) {
        Object[] objectArray = this.a.keyTable;
        Object[] objectArray2 = this.a.valueTable;
        IPath[] iPathArray = null;
        int n2 = this.a.elementSize;
        int n3 = 0;
        int n4 = 0;
        int n5 = objectArray.length;
        while (n4 < n5) {
            IPath iPath2 = (IPath)objectArray[n4];
            if (iPath2 != null) {
                if (iPath.isPrefixOf(iPath2)) {
                    e e2 = (e)objectArray2[n4];
                    e2.b = null;
                    if (iPathArray == null) {
                        iPathArray = new IPath[n2];
                    }
                    iPathArray[n3++] = iPath2;
                    File file = e2.a();
                    if (file.exists()) {
                        file.delete();
                    }
                } else {
                    --n2;
                }
            }
            ++n4;
        }
        if (iPathArray != null) {
            n4 = 0;
            while (n4 < n3) {
                this.a.removeKey(iPathArray[n4]);
                ++n4;
            }
            this.a(iPathArray);
        }
    }

    public synchronized void removeIndexFamily(IPath iPath) {
        ArrayList<IPath> arrayList = null;
        Object[] objectArray = this.indexLocations.keyTable;
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            IPath iPath2 = (IPath)objectArray[n2];
            if (iPath2 != null && iPath.isPrefixOf(iPath2)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<IPath>();
                }
                arrayList.add(iPath2);
            }
            ++n2;
        }
        if (arrayList != null) {
            n2 = 0;
            n3 = arrayList.size();
            while (n2 < n3) {
                this.removeIndex((IPath)arrayList.get(n2));
                ++n2;
            }
        }
    }

    public void removeSourceFolderFromIndex(JavaProject javaProject, IPath iPath, char[][] cArray, char[][] cArray2) {
        IndexAllProject indexAllProject;
        IProject iProject = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(indexAllProject = new IndexAllProject(iProject, this))) {
            return;
        }
        this.request(new RemoveFolderFromIndex(iPath, cArray, cArray2, iProject, this));
    }

    @Override
    public synchronized void reset() {
        super.reset();
        if (this.a != null) {
            this.a = new SimpleLookupTable();
            this.e = null;
        }
        this.indexLocations = new SimpleLookupTable();
        this.d = null;
    }

    public synchronized boolean resetIndex(IPath iPath) {
        String string = iPath.getDevice() == null ? iPath.toString() : iPath.toOSString();
        try {
            IPath iPath2 = this.computeIndexLocation(iPath);
            e e2 = this.getIndex(iPath2);
            if (VERBOSE) {
                Util.verbose("-> reseting index: " + iPath2 + " for path: " + string);
            }
            if (e2 == null) {
                return this.recreateIndex(iPath) != null;
            }
            e2.f();
            return true;
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                Util.verbose("-> failed to reset index for path: " + string);
                iOException.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndex(e e2) throws IOException {
        if (e2.b()) {
            if (VERBOSE) {
                Util.verbose("-> saving index " + e2.a());
            }
            e2.c();
        }
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Path path = new Path(e2.a);
            if (this.jobEnd > this.jobStart) {
                int n2 = this.jobEnd;
                while (n2 > this.jobStart) {
                    a a2 = this.awaitingJobs[n2];
                    if (a2 instanceof IndexRequest && ((IndexRequest)a2).containerPath.equals((Object)path)) {
                        return;
                    }
                    --n2;
                }
            }
            IPath iPath = this.computeIndexLocation((IPath)path);
            this.a(iPath, SAVED_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndexes() {
        Object object;
        int n2;
        ArrayList<e> arrayList = new ArrayList<e>();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Object[] objectArray = this.a.valueTable;
            n2 = 0;
            int n3 = objectArray.length;
            while (n2 < n3) {
                object = (e)objectArray[n2];
                if (object != null) {
                    arrayList.add((e)object);
                }
                ++n2;
            }
        }
        boolean bl2 = true;
        int n4 = 0;
        n2 = arrayList.size();
        while (n4 < n2) {
            block16: {
                e e2 = (e)arrayList.get(n4);
                object = e2.b;
                if (object != null) {
                    try {
                        ((ReadWriteMonitor)object).enterRead();
                        if (!e2.b()) break block16;
                        if (((ReadWriteMonitor)object).exitReadEnterWrite()) {
                            try {
                                try {
                                    this.saveIndex(e2);
                                }
                                catch (IOException iOException) {
                                    if (VERBOSE) {
                                        Util.verbose("-> got the following exception while saving:", System.err);
                                        iOException.printStackTrace();
                                    }
                                    bl2 = false;
                                    ((ReadWriteMonitor)object).exitWriteEnterRead();
                                    break block16;
                                }
                            }
                            catch (Throwable throwable) {
                                ((ReadWriteMonitor)object).exitWriteEnterRead();
                                throw throwable;
                            }
                            ((ReadWriteMonitor)object).exitWriteEnterRead();
                            break block16;
                        }
                        bl2 = false;
                    }
                    finally {
                        ((ReadWriteMonitor)object).exitRead();
                    }
                }
            }
            ++n4;
        }
        this.b = !bl2;
    }

    public void scheduleDocumentIndexing(SearchDocument searchDocument, IPath iPath, IPath iPath2, SearchParticipant searchParticipant) {
        this.request(new IndexManager$1(this, iPath, this, iPath2, searchDocument, searchParticipant));
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(super.toString());
        stringBuffer.append("In-memory indexes:\n");
        int n2 = 0;
        Object[] objectArray = this.a.valueTable;
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            e e2 = (e)objectArray[n3];
            if (e2 != null) {
                stringBuffer.append(++n2).append(" - ").append(e2.toString()).append('\n');
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private char[][] a(String string) {
        block3: {
            try {
                String string2;
                char[][] cArray;
                char[] cArray2 = org.ccdt.jsdt.internal.compiler.util.Util.getFileCharContent(this.f, null);
                if (cArray2.length > 0 && (cArray = CharOperation.splitOn('\n', cArray2)).length > 1 && (string2 = "INDEX VERSION 1.3+" + string).equals(new String(cArray[0]))) {
                    return cArray;
                }
            }
            catch (IOException iOException) {
                if (!VERBOSE) break block3;
                Util.verbose("Failed to read saved index file names");
            }
        }
        return null;
    }

    private synchronized void a(IPath[] iPathArray) {
        this.a();
        int n2 = iPathArray.length;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n2) {
            if (iPathArray[n3] != null && this.e.removeKey(iPathArray[n3]) != null) {
                bl2 = true;
                if (VERBOSE) {
                    Util.verbose("-> index state updated to: ? for: " + iPathArray[n3]);
                }
            }
            ++n3;
        }
        if (!bl2) {
            return;
        }
        this.d();
    }

    private synchronized void a(IPath iPath, Integer n2) {
        if (iPath.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.a();
        if (n2 != null) {
            if (n2.equals(this.e.get(iPath))) {
                return;
            }
            this.e.put(iPath, n2);
        } else {
            if (!this.e.containsKey(iPath)) {
                return;
            }
            this.e.removeKey(iPath);
        }
        this.d();
        if (VERBOSE) {
            String string = "?";
            if (n2 == SAVED_STATE) {
                string = "SAVED";
            } else if (n2 == UPDATING_STATE) {
                string = "UPDATING";
            } else if (n2 == UNKNOWN_STATE) {
                string = "UNKNOWN";
            } else if (n2 == REBUILDING_STATE) {
                string = "REBUILDING";
            }
            Util.verbose("-> index state updated to: " + string + " for: " + iPath);
        }
    }

    private void d() {
        block17: {
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(this.f));
                    bufferedWriter.write("INDEX VERSION 1.3");
                    bufferedWriter.write(43);
                    bufferedWriter.write(this.b().toOSString());
                    bufferedWriter.write(10);
                    Object[] objectArray = this.e.keyTable;
                    Object[] objectArray2 = this.e.valueTable;
                    int n2 = 0;
                    int n3 = objectArray2.length;
                    while (n2 < n3) {
                        IPath iPath = (IPath)objectArray[n2];
                        if (iPath != null && !iPath.isEmpty() && objectArray2[n2] == SAVED_STATE) {
                            bufferedWriter.write(iPath.lastSegment());
                            bufferedWriter.write(10);
                        }
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        Util.verbose("Failed to write saved index file names", System.err);
                    }
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

