/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ccdt.jsdt.core.search.SearchEngine;
import org.ccdt.jsdt.core.search.SearchParticipant;
import org.ccdt.jsdt.internal.compiler.util.SimpleLookupTable;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.c.e;
import org.ccdt.jsdt.internal.core.search.a.b;
import org.ccdt.jsdt.internal.core.search.indexing.IndexManager;
import org.ccdt.jsdt.internal.core.search.indexing.IndexRequest;
import org.ccdt.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.ccdt.jsdt.internal.core.search.r;
import org.ccdt.jsdt.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

class AddLibraryFileToIndex
extends IndexRequest {
    IPath a;
    char[][] b;
    char[][] c;

    public AddLibraryFileToIndex(IFile iFile, IndexManager indexManager) {
        super(iFile.getFullPath(), indexManager);
        this.a = iFile.getLocation();
    }

    public AddLibraryFileToIndex(IPath iPath, IndexManager indexManager) {
        this(iPath, null, null, indexManager);
    }

    public AddLibraryFileToIndex(IPath iPath, char[][] cArray, char[][] cArray2, IndexManager indexManager) {
        super(iPath, indexManager);
        this.b = cArray;
        this.c = cArray2;
    }

    public boolean equals(Object object) {
        if (object instanceof AddLibraryFileToIndex && this.containerPath != null) {
            return this.containerPath.equals((Object)((AddLibraryFileToIndex)object).containerPath);
        }
        return false;
    }

    public int hashCode() {
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (this.isCancelled || iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        try {
            e e2 = this.manager.getIndexForUpdate(this.containerPath, false, false);
            if (e2 != null) {
                if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                    Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                }
                return true;
            }
            e2 = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (e2 == null) {
                if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                    Util.verbose("-> index could not be created for " + this.containerPath);
                }
                return true;
            }
            ReadWriteMonitor readWriteMonitor = e2.b;
            if (readWriteMonitor == null) {
                if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                    Util.verbose("-> index for " + this.containerPath + " just got deleted");
                }
                return true;
            }
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String[] stringArray;
                Path path = null;
                readWriteMonitor.enterWrite();
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                }
                path = (Path)this.containerPath;
                if (this.isCancelled) {
                    if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                        Util.verbose("-> indexing of " + path.toString() + " has been cancelled");
                    }
                    return false;
                }
                if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                    Util.verbose("-> indexing " + path.toString());
                }
                long l2 = System.currentTimeMillis();
                if (org.ccdt.jsdt.internal.compiler.util.Util.isArchiveFileName(path.lastSegment()) && (stringArray = e2.b("")) != null) {
                    int n2 = stringArray.length;
                    object4 = "OK";
                    object3 = "DELETED";
                    object2 = new SimpleLookupTable(n2 == 0 ? 33 : n2 + 11);
                    int n3 = 0;
                    while (n3 < n2) {
                        ((SimpleLookupTable)object2).put(stringArray[n3], object3);
                        ++n3;
                    }
                    if (org.ccdt.jsdt.internal.compiler.util.Util.isClassFileName(path.toPortableString())) {
                        ((SimpleLookupTable)object2).put(path.toPortableString(), object4);
                    }
                    int n4 = n3 = ((SimpleLookupTable)object2).elementSize != n2 ? 1 : 0;
                    if (n3 == 0) {
                        object = ((SimpleLookupTable)object2).valueTable;
                        int n5 = 0;
                        int n6 = ((Object[])object).length;
                        while (n5 < n6) {
                            if (object[n5] == object3) {
                                n3 = 1;
                                break;
                            }
                            ++n5;
                        }
                        if (n3 == 0) {
                            if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                                Util.verbose("-> no indexing required (index is consistent with library) for " + path.lastSegment() + " (" + (System.currentTimeMillis() - l2) + "ms)");
                            }
                            this.manager.saveIndex(e2);
                            return true;
                        }
                    }
                }
                stringArray = SearchEngine.getDefaultSearchParticipant();
                e2 = this.manager.recreateIndex(this.containerPath);
                if (e2 == null) {
                    this.manager.removeIndex(this.containerPath);
                    return false;
                }
                IPath iPath = this.a != null ? this.a : this.containerPath;
                object4 = new File(iPath.toOSString());
                if (((File)object4).isFile()) {
                    if (Util.isJavaLikeFileName(((File)object4).getName())) {
                        if (this.c == null && this.b == null) {
                            this.a((File)object4, (SearchParticipant)stringArray, e2, (IPath)path);
                        } else if (!org.ccdt.jsdt.internal.compiler.util.Util.isExcluded(((File)object4).getPath().toCharArray(), this.b, this.c, false)) {
                            this.a((File)object4, (SearchParticipant)stringArray, e2, (IPath)path);
                        }
                    } else if (org.ccdt.jsdt.internal.compiler.util.Util.isArchiveFileName(((File)object4).getName())) {
                        object3 = new ZipFile((File)object4);
                        object2 = ((ZipFile)object3).entries();
                        while (object2.hasMoreElements()) {
                            if (this.isCancelled) {
                                if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                                    Util.verbose("-> indexing of " + ((ZipFile)object3).getName() + " has been cancelled");
                                }
                                return false;
                            }
                            ZipEntry zipEntry = (ZipEntry)object2.nextElement();
                            if (!org.ccdt.jsdt.internal.compiler.util.Util.isClassFileName(zipEntry.getName())) continue;
                            object = new InputStreamReader(((ZipFile)object3).getInputStream(zipEntry), "utf8");
                            StringBuffer stringBuffer = new StringBuffer();
                            char[] cArray = new char[2048];
                            int n7 = 0;
                            while ((n7 = ((Reader)object).read(cArray)) > -1) {
                                stringBuffer.append(cArray, 0, n7);
                            }
                            r r2 = new r(zipEntry, (IPath)path, stringBuffer.toString().toCharArray(), (SearchParticipant)stringArray);
                            this.manager.indexDocument(r2, (SearchParticipant)stringArray, e2, this.containerPath);
                        }
                    }
                } else if (this.c == null && this.b == null) {
                    this.b((File)object4, (SearchParticipant)stringArray, e2, (IPath)path);
                } else if (this.c != null && this.b == null) {
                    if (!org.ccdt.jsdt.internal.compiler.util.Util.isExcluded(((File)object4).getPath().toCharArray(), this.b, this.c, true)) {
                        this.b((File)object4, (SearchParticipant)stringArray, e2, (IPath)path);
                    }
                } else {
                    this.b((File)object4, (SearchParticipant)stringArray, e2, (IPath)path);
                }
                this.manager.saveIndex(e2);
                if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                    Util.verbose("-> done indexing of " + path.toString() + " (" + (System.currentTimeMillis() - l2) + "ms)");
                }
            }
            finally {
                readWriteMonitor.exitWrite();
            }
        }
        catch (IOException iOException) {
            if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                iOException.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
        return true;
    }

    @Override
    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }

    private void a(File file, SearchParticipant searchParticipant, e e2, IPath iPath) {
        try {
            char[] cArray = org.ccdt.jsdt.internal.compiler.util.Util.getFileCharContent(file, null);
            String string = "";
            r r2 = new r((IPath)new Path(file.getAbsolutePath()), cArray, searchParticipant, string);
            this.manager.indexDocument(r2, searchParticipant, e2, this.containerPath);
        }
        catch (Exception exception) {}
    }

    private void b(File file, SearchParticipant searchParticipant, e e2, IPath iPath) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (fileArray[n2].isDirectory()) {
                    if (this.c == null && this.b == null) {
                        this.b(fileArray[n2], searchParticipant, e2, iPath);
                    } else if (this.c != null && this.b == null) {
                        if (!org.ccdt.jsdt.internal.compiler.util.Util.isExcluded(fileArray[n2].getPath().toCharArray(), this.b, this.c, true)) {
                            this.b(fileArray[n2], searchParticipant, e2, iPath);
                        }
                    } else {
                        this.b(fileArray[n2], searchParticipant, e2, iPath);
                    }
                } else if (org.ccdt.jsdt.internal.compiler.util.Util.isClassFileName(fileArray[n2].getName())) {
                    if (this.c == null && this.b == null) {
                        this.a(fileArray[n2], searchParticipant, e2, iPath);
                    } else if (!org.ccdt.jsdt.internal.compiler.util.Util.isExcluded(fileArray[n2].getPath().toCharArray(), this.b, this.c, false)) {
                        this.a(fileArray[n2], searchParticipant, e2, iPath);
                    }
                }
                ++n2;
            }
        }
    }
}

