/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ccdt.jsdt.core.search.SearchEngine;
import org.ccdt.jsdt.core.search.SearchParticipant;
import org.ccdt.jsdt.internal.compiler.util.SimpleLookupTable;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.c.e;
import org.ccdt.jsdt.internal.core.search.a.b;
import org.ccdt.jsdt.internal.core.search.indexing.IndexManager;
import org.ccdt.jsdt.internal.core.search.indexing.IndexRequest;
import org.ccdt.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.ccdt.jsdt.internal.core.search.r;
import org.ccdt.jsdt.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

class AddJarFileToIndex
extends IndexRequest {
    private static final char b = "|".charAt(0);
    IFile a;

    public AddJarFileToIndex(IFile iFile, IndexManager indexManager) {
        super(iFile.getFullPath(), indexManager);
        this.a = iFile;
    }

    public AddJarFileToIndex(IPath iPath, IndexManager indexManager) {
        super(iPath, indexManager);
    }

    public boolean equals(Object object) {
        if (object instanceof AddJarFileToIndex) {
            if (this.a != null) {
                return this.a.equals((Object)((AddJarFileToIndex)object).a);
            }
            if (this.containerPath != null) {
                return this.containerPath.equals((Object)((AddJarFileToIndex)object).containerPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.a != null) {
            return this.a.hashCode();
        }
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(IProgressMonitor iProgressMonitor) {
        if (this.isCancelled) return true;
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            return true;
        }
        try {
            e e2 = this.manager.getIndexForUpdate(this.containerPath, false, false);
            if (e2 != null) {
                if (!org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) return true;
                Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                return true;
            }
            e2 = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (e2 == null) {
                if (!org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) return true;
                Util.verbose("-> index could not be created for " + this.containerPath);
                return true;
            }
            ReadWriteMonitor readWriteMonitor = e2.b;
            if (readWriteMonitor == null) {
                if (!org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) return true;
                Util.verbose("-> index for " + this.containerPath + " just got deleted");
                return true;
            }
            ZipFile zipFile = null;
            try {
                Object object;
                Object object2;
                Cloneable cloneable;
                Object object3;
                String string;
                Path path = null;
                readWriteMonitor.enterWrite();
                if (this.a != null) {
                    File file;
                    URI uRI;
                    block40: {
                        uRI = this.a.getLocationURI();
                        if (uRI == null) {
                            return false;
                        }
                        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                            System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + uRI.getPath());
                        }
                        file = null;
                        try {
                            file = Util.toLocalFile(uRI, iProgressMonitor);
                        }
                        catch (CoreException coreException) {
                            if (!org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) break block40;
                            Util.verbose("-> failed to index " + uRI.getPath() + " because of the following exception:");
                            coreException.printStackTrace();
                        }
                    }
                    if (file == null) {
                        if (!org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) return false;
                        Util.verbose("-> failed to index " + uRI.getPath() + " because the file could not be fetched");
                        return false;
                    }
                    zipFile = new ZipFile(file);
                    path = (Path)this.a.getFullPath().makeRelative();
                } else {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                    }
                    zipFile = new ZipFile(this.containerPath.toFile());
                    path = (Path)this.containerPath;
                }
                if (this.isCancelled) {
                    if (!org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) return false;
                    Util.verbose("-> indexing of " + zipFile.getName() + " has been cancelled");
                    return false;
                }
                if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                    Util.verbose("-> indexing " + zipFile.getName());
                }
                long l2 = System.currentTimeMillis();
                String[] stringArray = e2.b("");
                if (stringArray != null) {
                    boolean bl2;
                    int n2 = stringArray.length;
                    string = "OK";
                    object3 = "DELETED";
                    cloneable = new SimpleLookupTable(n2 == 0 ? 33 : n2 + 11);
                    int n3 = 0;
                    while (n3 < n2) {
                        ((SimpleLookupTable)cloneable).put(stringArray[n3], object3);
                        ++n3;
                    }
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        object = object2.getName();
                        if (!org.ccdt.jsdt.internal.compiler.util.Util.isClassFileName((String)object)) continue;
                        ((SimpleLookupTable)cloneable).put(object, string);
                    }
                    boolean bl3 = bl2 = ((SimpleLookupTable)cloneable).elementSize != n2;
                    if (!bl2) {
                        object2 = ((SimpleLookupTable)cloneable).valueTable;
                        int n4 = 0;
                        int n5 = ((Object[])object2).length;
                        while (n4 < n5) {
                            if (object2[n4] == object3) {
                                bl2 = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!bl2) {
                            if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                                Util.verbose("-> no indexing required (index is consistent with library) for " + zipFile.getName() + " (" + (System.currentTimeMillis() - l2) + "ms)");
                            }
                            this.manager.saveIndex(e2);
                            return true;
                        }
                    }
                }
                SearchParticipant searchParticipant = SearchEngine.getDefaultSearchParticipant();
                if (!this.manager.resetIndex(this.containerPath)) {
                    this.manager.removeIndex(this.containerPath);
                    return false;
                }
                string = null;
                object3 = zipFile.entries();
                while (object3.hasMoreElements()) {
                    if (this.isCancelled) {
                        if (!org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) return false;
                        Util.verbose("-> indexing of " + zipFile.getName() + " has been cancelled");
                        return false;
                    }
                    cloneable = (ZipEntry)object3.nextElement();
                    String string2 = ((ZipEntry)cloneable).getName();
                    if (!org.ccdt.jsdt.internal.compiler.util.Util.isClassFileName(string2)) continue;
                    object2 = org.ccdt.jsdt.internal.compiler.util.Util.getZipEntryByteContent((ZipEntry)cloneable, zipFile);
                    object = new char[((Object[])object2).length];
                    int n6 = 0;
                    while (n6 < ((Object)object).length) {
                        object[n6] = (char)object2[n6];
                        ++n6;
                    }
                    r r2 = new r((ZipEntry)cloneable, (IPath)path, (char[])object, searchParticipant);
                    this.manager.indexDocument(r2, searchParticipant, e2, (IPath)string);
                }
                this.manager.saveIndex(e2);
                if (!org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) return true;
                Util.verbose("-> done indexing of " + zipFile.getName() + " (" + (System.currentTimeMillis() - l2) + "ms)");
                return true;
            }
            finally {
                if (zipFile != null) {
                    if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Closing ZipFile " + zipFile);
                    }
                    zipFile.close();
                }
                readWriteMonitor.exitWrite();
            }
        }
        catch (IOException iOException) {
            if (org.ccdt.jsdt.internal.core.search.a.b.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                iOException.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    @Override
    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }
}

