/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core.search.indexing;

import org.ccdt.jsdt.core.search.SearchDocument;
import org.ccdt.jsdt.internal.core.Logger;
import org.ccdt.jsdt.internal.core.search.indexing.IIndexConstants;
import org.ccdt.jsdt.internal.core.search.matching.ConstructorPattern;
import org.ccdt.jsdt.internal.core.search.matching.FieldPattern;
import org.ccdt.jsdt.internal.core.search.matching.MethodPattern;
import org.ccdt.jsdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.ccdt.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.ccdt.jsdt.internal.core.search.matching.TypeSynonymsPattern;
import org.ccdt.jsdt.internal.core.util.QualificationHelpers;

public abstract class AbstractIndexer
implements IIndexConstants {
    SearchDocument a;

    public AbstractIndexer(SearchDocument searchDocument) {
        this.a = searchDocument;
    }

    public void addClassDeclaration(int n2, char[] cArray, char[] cArray2, char[][] cArray3, char[] cArray4, boolean bl2, char[][] cArray5) {
        this.addTypeDeclaration(n2, cArray, cArray2, cArray4);
        if (cArray4 != null) {
            this.addTypeReference(cArray4);
        }
        char[] cArray6 = QualificationHelpers.createFullyQualifiedName(cArray, cArray2);
        this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(cArray6, cArray4));
        if (cArray5 != null && cArray5.length > 0) {
            this.addIndexEntry(TYPE_SYNONYMS, TypeSynonymsPattern.createIndexKey(cArray6, cArray5));
        }
    }

    public void addConstructorDeclaration(char[] cArray, char[][] cArray2, char[][] cArray3, int n2) {
        this.addIndexEntry(CONSTRUCTOR_DECL, ConstructorPattern.createIndexKey(cArray, cArray2, cArray3, n2));
        if (cArray2 != null) {
            int n3 = 0;
            while (n3 < cArray2.length) {
                if (cArray2[n3] != null) {
                    this.addTypeReference(cArray2[n3]);
                }
                ++n3;
            }
        }
    }

    public void addConstructorReference(char[] cArray, int n2) {
        this.addTypeReference(cArray);
        this.addIndexEntry(CONSTRUCTOR_REF, ConstructorPattern.createIndexKey(cArray, null, null, 0));
    }

    public void addFieldDeclaration(char[] cArray, char[] cArray2, char[] cArray3, int n2, boolean bl2) {
        if (cArray2 != null && cArray2.length > 0) {
            char[] cArray4 = bl2 ? VAR_DECL : FIELD_DECL;
            this.addIndexEntry(cArray4, FieldPattern.createIndexKey(cArray2, cArray, cArray3 != null ? cArray3 : IIndexConstants.GLOBAL_SYMBOL, n2));
            if (cArray != null) {
                this.addTypeReference(cArray);
            }
        } else {
            String string = "JSDT AbstractIndexer attempted to index a field with no name, this should never happen.";
            if (cArray != null) {
                string = String.valueOf(string) + "\ntypeName: " + new String(cArray);
            }
            if (cArray3 != null) {
                string = String.valueOf(string) + "\ndeclaringType: " + new String(cArray3);
            }
            Logger.log(2, string);
        }
    }

    public void addFieldReference(char[] cArray) {
        this.addNameReference(cArray);
    }

    protected void addIndexEntry(char[] cArray, char[] cArray2) {
        this.a.addIndexEntry(cArray, cArray2);
    }

    public void addMethodDeclaration(char[] cArray, char[][] cArray2, char[][] cArray3, char[] cArray4, char[] cArray5, boolean bl2, int n2) {
        char[] cArray6 = MethodPattern.createIndexKey(cArray, cArray2, cArray3, cArray5 != null ? cArray5 : IIndexConstants.GLOBAL_SYMBOL, cArray4, n2);
        if (cArray6 != null) {
            this.addIndexEntry(bl2 ? FUNCTION_DECL : METHOD_DECL, cArray6);
        }
        if (cArray2 != null) {
            int n3 = 0;
            while (n3 < cArray2.length) {
                this.addTypeReference(cArray2[n3]);
                ++n3;
            }
        }
        if (cArray4 != null) {
            this.addTypeReference(cArray4);
        }
    }

    public void addMethodReference(char[] cArray) {
        char[] cArray2 = MethodPattern.createIndexKey(cArray);
        if (cArray2 != null) {
            this.addIndexEntry(METHOD_REF, cArray2);
        }
    }

    public void addNameReference(char[] cArray) {
        this.addIndexEntry(REF, cArray);
    }

    protected void addTypeDeclaration(int n2, char[] cArray, char[] cArray2, char[] cArray3) {
        char[] cArray4 = TypeDeclarationPattern.createIndexKey(cArray, cArray2, new char[][]{cArray3}, n2);
        this.addIndexEntry(TYPE_DECL, cArray4);
    }

    public void addTypeReference(char[] cArray) {
        if (cArray != null) {
            this.addNameReference(cArray);
        }
    }

    public abstract void indexDocument();
}

