/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import org.ccdt.jsdt.core.Flags;
import org.ccdt.jsdt.core.IFunction;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptUnit;
import org.ccdt.jsdt.core.IType;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.core.Signature;
import org.ccdt.jsdt.core.compiler.CharOperation;
import org.ccdt.jsdt.internal.compiler.lookup.Binding;
import org.ccdt.jsdt.internal.core.CompilationUnit;
import org.ccdt.jsdt.internal.core.JavaElement;
import org.ccdt.jsdt.internal.core.NamedMember;
import org.ccdt.jsdt.internal.core.ResolvedSourceMethod;
import org.ccdt.jsdt.internal.core.SourceMethodElementInfo;

public class SourceMethod
extends NamedMember
implements IFunction {
    protected String[] parameterTypes;

    protected SourceMethod(JavaElement javaElement, String string, String[] stringArray) {
        super(javaElement, string);
        this.parameterTypes = stringArray == null ? CharOperation.NO_STRINGS : stringArray;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SourceMethod)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int getElementType() {
        return 9;
    }

    @Override
    protected void getHandleMemento(StringBuffer stringBuffer) {
        ((JavaElement)this.getParent()).getHandleMemento(stringBuffer);
        char c2 = this.getHandleMementoDelimiter();
        stringBuffer.append(c2);
        this.escapeMementoName(stringBuffer, this.getElementName());
        if (this.occurrenceCount > 1) {
            stringBuffer.append('!');
            stringBuffer.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '~';
    }

    @Override
    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    @Override
    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    @Override
    public String[] getParameterNames() throws JavaScriptModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        char[][] cArray = sourceMethodElementInfo.getArgumentNames();
        return CharOperation.toStrings(cArray);
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public IJavaScriptElement getPrimaryElement(boolean bl2) {
        IJavaScriptElement iJavaScriptElement;
        if (bl2 && ((CompilationUnit)(iJavaScriptElement = (CompilationUnit)this.getAncestor(5))).isPrimary()) {
            return this;
        }
        iJavaScriptElement = this.parent.getPrimaryElement(false);
        if (iJavaScriptElement instanceof IType) {
            return ((IType)iJavaScriptElement).getFunction(this.name, this.parameterTypes);
        }
        return ((IJavaScriptUnit)iJavaScriptElement).getFunction(this.name, this.parameterTypes);
    }

    @Override
    public String[] getRawParameterNames() throws JavaScriptModelException {
        return this.getParameterNames();
    }

    @Override
    public String getReturnType() throws JavaScriptModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createTypeSignature(sourceMethodElementInfo.getReturnTypeName(), false);
    }

    @Override
    public String getSignature() throws JavaScriptModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createMethodSignature(this.parameterTypes, Signature.createTypeSignature(sourceMethodElementInfo.getReturnTypeName(), false));
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        return n2;
    }

    @Override
    public boolean isConstructor() throws JavaScriptModelException {
        SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)this.getElementInfo();
        return sourceMethodElementInfo.isConstructor();
    }

    public boolean isMainMethod() throws JavaScriptModelException {
        return this.isMainMethod(this);
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public boolean isSimilar(IFunction iFunction) {
        return SourceMethod.areSimilarMethods(this.getElementName(), this.getParameterTypes(), iFunction.getElementName(), iFunction.getParameterTypes(), null);
    }

    @Override
    public String readableName() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(super.readableName());
        stringBuffer.append('(');
        if (this.parameterTypes != null && (n2 = this.parameterTypes.length) > 0) {
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(Signature.toString(this.parameterTypes[n3]));
                if (n3 < n2 - 1) {
                    stringBuffer.append(", ");
                }
                ++n3;
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedSourceMethod resolvedSourceMethod = new ResolvedSourceMethod(this.parent, this.name, this.parameterTypes, new String(binding.computeUniqueKey()));
        resolvedSourceMethod.occurrenceCount = this.occurrenceCount;
        return resolvedSourceMethod;
    }

    @Override
    protected void toStringInfo(int n2, StringBuffer stringBuffer, Object object, boolean bl2) {
        stringBuffer.append(this.tabString(n2));
        if (object == null) {
            this.toStringName(stringBuffer);
            stringBuffer.append(" (not open)");
        } else if (object == NO_INFO) {
            this.toStringName(stringBuffer);
        } else {
            SourceMethodElementInfo sourceMethodElementInfo = (SourceMethodElementInfo)object;
            int n3 = sourceMethodElementInfo.getModifiers();
            if (Flags.isStatic(n3)) {
                stringBuffer.append("static ");
            }
            if (!sourceMethodElementInfo.isConstructor()) {
                stringBuffer.append("function ");
            }
            this.toStringName(stringBuffer, n3);
        }
    }

    @Override
    protected void toStringName(StringBuffer stringBuffer) {
        this.toStringName(stringBuffer, 0);
    }

    protected void toStringName(StringBuffer stringBuffer, int n2) {
        int n3;
        stringBuffer.append(this.getElementName());
        stringBuffer.append('(');
        String[] stringArray = this.getParameterTypes();
        if (stringArray != null && (n3 = stringArray.length) > 0) {
            boolean bl2 = Flags.isVarargs(n2);
            int n4 = 0;
            while (n4 < n3) {
                try {
                    if (n4 < n3 - 1) {
                        stringBuffer.append("p" + n4);
                        stringBuffer.append(", ");
                    } else if (bl2) {
                        String string = stringArray[n4].substring(1);
                        stringBuffer.append(Signature.toString(string));
                        stringBuffer.append(" ...");
                    } else {
                        stringBuffer.append("p" + n4);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    stringBuffer.append("*** invalid signature: ");
                    stringBuffer.append(stringArray[n4]);
                }
                ++n4;
            }
        }
        stringBuffer.append(')');
        if (this.occurrenceCount > 1) {
            stringBuffer.append("#");
            stringBuffer.append(this.occurrenceCount);
        }
    }

    @Override
    public IFunction getFunction(String string, String[] stringArray) {
        return new SourceMethod(this, string, stringArray);
    }

    @Override
    public String getDisplayName() {
        String string = super.getDisplayName();
        if (string.equals("___anonymous")) {
            string = "";
        }
        return string;
    }
}

