/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.ccdt.jsdt.internal.core.LRUCacheEnumerator;
import org.ccdt.jsdt.internal.core.LRUCacheEnumerator$LRUEnumeratorElement;
import org.ccdt.jsdt.internal.core.OverflowingLRUCache$1Temp;
import org.ccdt.jsdt.internal.core.util.LRUCache;
import org.ccdt.jsdt.internal.core.util.LRUCache$LRUCacheEntry;
import org.ccdt.jsdt.internal.core.util.Messages;

public abstract class OverflowingLRUCache
extends LRUCache {
    protected int fOverflow = 0;
    protected boolean fTimestampsOn = true;
    protected double fLoadFactor = 0.333;

    public OverflowingLRUCache(int n2) {
        this(n2, 0);
    }

    public OverflowingLRUCache(int n2, int n3) {
        super(n2);
        this.fOverflow = n3;
    }

    @Override
    public Object clone() {
        OverflowingLRUCache overflowingLRUCache = (OverflowingLRUCache)this.newInstance(this.fSpaceLimit, this.fOverflow);
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = this.fEntryQueueTail;
        while (lRUCache$LRUCacheEntry != null) {
            overflowingLRUCache.privateAdd(lRUCache$LRUCacheEntry._fKey, lRUCache$LRUCacheEntry._fValue, lRUCache$LRUCacheEntry._fSpace);
            lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fPrevious;
        }
        return overflowingLRUCache;
    }

    protected abstract boolean close(LRUCache$LRUCacheEntry var1);

    public Enumeration elements() {
        if (this.fEntryQueue == null) {
            return new LRUCacheEnumerator(null);
        }
        LRUCacheEnumerator$LRUEnumeratorElement lRUCacheEnumerator$LRUEnumeratorElement = new LRUCacheEnumerator$LRUEnumeratorElement(this.fEntryQueue._fValue);
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = this.fEntryQueue._fNext;
        LRUCacheEnumerator$LRUEnumeratorElement lRUCacheEnumerator$LRUEnumeratorElement2 = lRUCacheEnumerator$LRUEnumeratorElement;
        while (lRUCache$LRUCacheEntry != null) {
            lRUCacheEnumerator$LRUEnumeratorElement2 = lRUCacheEnumerator$LRUEnumeratorElement2.fNext = new LRUCacheEnumerator$LRUEnumeratorElement(lRUCache$LRUCacheEntry._fValue);
            lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fNext;
        }
        return new LRUCacheEnumerator(lRUCacheEnumerator$LRUEnumeratorElement);
    }

    @Override
    public double fillingRatio() {
        return (double)(this.fCurrentSpace + this.fOverflow) * 100.0 / (double)this.fSpaceLimit;
    }

    public Hashtable getEntryTable() {
        return this.fEntryTable;
    }

    public double getLoadFactor() {
        return this.fLoadFactor;
    }

    public int getOverflow() {
        return this.fOverflow;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean makeSpace(int n2) {
        int n3 = this.fSpaceLimit;
        if (this.fOverflow == 0 && this.fCurrentSpace + n2 <= n3) {
            return true;
        }
        int n4 = (int)((1.0 - this.fLoadFactor) * (double)n3);
        n4 = n4 > n2 ? n4 : n2;
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = this.fEntryQueueTail;
        try {
            this.fTimestampsOn = false;
            while (this.fCurrentSpace + n4 > n3 && lRUCache$LRUCacheEntry != null) {
                this.privateRemoveEntry(lRUCache$LRUCacheEntry, false, false);
                lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fPrevious;
            }
        }
        finally {
            this.fTimestampsOn = true;
        }
        if (this.fCurrentSpace + n2 <= n3) {
            this.fOverflow = 0;
            return true;
        }
        this.fOverflow = this.fCurrentSpace + n2 - n3;
        return false;
    }

    protected abstract LRUCache newInstance(int var1, int var2);

    public void printStats() {
        Class<?> clazz;
        int n2 = 0;
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = this.fEntryQueue;
        while (lRUCache$LRUCacheEntry != null) {
            ++n2;
            lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fNext;
        }
        System.out.println("Forward length: " + n2);
        int n3 = 0;
        lRUCache$LRUCacheEntry = this.fEntryQueueTail;
        while (lRUCache$LRUCacheEntry != null) {
            ++n3;
            lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fPrevious;
        }
        System.out.println("Backward length: " + n3);
        Enumeration enumeration = this.fEntryTable.keys();
        HashMap<Object, OverflowingLRUCache$1Temp> hashMap = new HashMap<Object, OverflowingLRUCache$1Temp>();
        while (enumeration.hasMoreElements()) {
            lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(enumeration.nextElement());
            clazz = lRUCache$LRUCacheEntry._fValue.getClass();
            OverflowingLRUCache$1Temp overflowingLRUCache$1Temp = (OverflowingLRUCache$1Temp)hashMap.get(clazz);
            if (overflowingLRUCache$1Temp == null) {
                hashMap.put(clazz, new OverflowingLRUCache$1Temp(this, clazz));
                continue;
            }
            ++overflowingLRUCache$1Temp.fCount;
        }
        clazz = hashMap.values().iterator();
        while (clazz.hasNext()) {
            System.out.println(clazz.next());
        }
    }

    @Override
    protected void privateRemoveEntry(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry, boolean bl2) {
        this.privateRemoveEntry(lRUCache$LRUCacheEntry, bl2, true);
    }

    protected void privateRemoveEntry(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry, boolean bl2, boolean bl3) {
        if (!bl2) {
            if (bl3) {
                this.fEntryTable.remove(lRUCache$LRUCacheEntry._fKey);
                this.fCurrentSpace -= lRUCache$LRUCacheEntry._fSpace;
            } else {
                if (!this.close(lRUCache$LRUCacheEntry)) {
                    return;
                }
                if (this.fEntryTable.get(lRUCache$LRUCacheEntry._fKey) == null) {
                    return;
                }
                this.fEntryTable.remove(lRUCache$LRUCacheEntry._fKey);
                this.fCurrentSpace -= lRUCache$LRUCacheEntry._fSpace;
            }
        }
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry2 = lRUCache$LRUCacheEntry._fPrevious;
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry3 = lRUCache$LRUCacheEntry._fNext;
        if (lRUCache$LRUCacheEntry2 == null) {
            this.fEntryQueue = lRUCache$LRUCacheEntry3;
        } else {
            lRUCache$LRUCacheEntry2._fNext = lRUCache$LRUCacheEntry3;
        }
        if (lRUCache$LRUCacheEntry3 == null) {
            this.fEntryQueueTail = lRUCache$LRUCacheEntry2;
        } else {
            lRUCache$LRUCacheEntry3._fPrevious = lRUCache$LRUCacheEntry2;
        }
    }

    @Override
    public Object put(Object object, Object object2) {
        if (this.fOverflow > 0) {
            this.shrink();
        }
        int n2 = this.spaceFor(object2);
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry != null) {
            int n3 = lRUCache$LRUCacheEntry._fSpace;
            int n4 = this.fCurrentSpace - n3 + n2;
            if (n4 <= this.fSpaceLimit) {
                this.updateTimestamp(lRUCache$LRUCacheEntry);
                lRUCache$LRUCacheEntry._fValue = object2;
                lRUCache$LRUCacheEntry._fSpace = n2;
                this.fCurrentSpace = n4;
                this.fOverflow = 0;
                return object2;
            }
            this.privateRemoveEntry(lRUCache$LRUCacheEntry, false, false);
        }
        this.makeSpace(n2);
        this.privateAdd(object, object2, n2);
        return object2;
    }

    public Object remove(Object object) {
        return this.removeKey(object);
    }

    public void setLoadFactor(double d2) throws IllegalArgumentException {
        if (!(d2 <= 1.0) || !(d2 > 0.0)) {
            throw new IllegalArgumentException(Messages.cache_invalidLoadFactor);
        }
        this.fLoadFactor = d2;
    }

    @Override
    public void setSpaceLimit(int n2) {
        if (n2 < this.fSpaceLimit) {
            this.makeSpace(this.fSpaceLimit - n2);
        }
        this.fSpaceLimit = n2;
    }

    public boolean shrink() {
        if (this.fOverflow > 0) {
            return this.makeSpace(0);
        }
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.toStringFillingRation("OverflowingLRUCache ")) + this.toStringContents();
    }

    @Override
    protected void updateTimestamp(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry) {
        if (this.fTimestampsOn) {
            lRUCache$LRUCacheEntry._fTimestamp = this.fTimestampCounter++;
            if (this.fEntryQueue != lRUCache$LRUCacheEntry) {
                this.privateRemoveEntry(lRUCache$LRUCacheEntry, true);
                this.privateAddEntry(lRUCache$LRUCacheEntry, true);
            }
        }
    }
}

