/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.ccdt.jsdt.core.BufferChangedEvent;
import org.ccdt.jsdt.core.CompletionRequestor;
import org.ccdt.jsdt.core.IBuffer;
import org.ccdt.jsdt.core.IBufferChangedListener;
import org.ccdt.jsdt.core.IBufferFactory;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IOpenable;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.core.WorkingCopyOwner;
import org.ccdt.jsdt.internal.codeassist.CompletionEngine;
import org.ccdt.jsdt.internal.codeassist.SelectionEngine;
import org.ccdt.jsdt.internal.compiler.env.ICompilationUnit;
import org.ccdt.jsdt.internal.core.BufferManager;
import org.ccdt.jsdt.internal.core.JavaElement;
import org.ccdt.jsdt.internal.core.JavaModel;
import org.ccdt.jsdt.internal.core.JavaModelCache;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.JavaModelStatus;
import org.ccdt.jsdt.internal.core.JavaProject;
import org.ccdt.jsdt.internal.core.NameLookup;
import org.ccdt.jsdt.internal.core.NullBuffer;
import org.ccdt.jsdt.internal.core.OpenableElementInfo;
import org.ccdt.jsdt.internal.core.PackageFragmentRoot;
import org.ccdt.jsdt.internal.core.SearchableEnvironment;
import org.ccdt.jsdt.internal.core.SelectionRequestor;
import org.ccdt.jsdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;

public abstract class Openable
extends JavaElement
implements IBufferChangedListener,
IOpenable {
    protected Openable(JavaElement javaElement) {
        super(javaElement);
    }

    @Override
    public void bufferChanged(BufferChangedEvent bufferChangedEvent) {
        if (bufferChangedEvent.getBuffer().isClosed()) {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(bufferChangedEvent.getBuffer());
        } else {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().add(this);
        }
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws JavaScriptModelException;

    public boolean canBeRemovedFromCache() {
        try {
            return !this.hasUnsavedChanges();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
    }

    public boolean canBufferBeRemovedFromCache(IBuffer iBuffer) {
        return !iBuffer.hasUnsavedChanges();
    }

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer iBuffer = this.getBufferManager().getBuffer(this);
        if (iBuffer != null) {
            iBuffer.close();
            iBuffer.removeBufferChangedListener(this);
        }
    }

    @Override
    protected void closing(Object object) {
        this.closeBuffer();
    }

    protected void codeComplete(ICompilationUnit iCompilationUnit, ICompilationUnit iCompilationUnit2, int n2, CompletionRequestor completionRequestor, WorkingCopyOwner workingCopyOwner) throws JavaScriptModelException {
        IBuffer iBuffer;
        PerformanceStats performanceStats;
        if (completionRequestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        PerformanceStats performanceStats2 = performanceStats = CompletionEngine.PERF ? PerformanceStats.getStats((String)"org.ccdt.jsdt.core/perf/completion", (Object)this) : null;
        if (performanceStats != null) {
            performanceStats.startRun(String.valueOf(new String(iCompilationUnit.getFileName())) + " at " + n2);
        }
        if ((iBuffer = this.getBuffer()) == null) {
            return;
        }
        if (n2 < -1 || n2 > iBuffer.getLength()) {
            throw new JavaScriptModelException(new JavaModelStatus(980));
        }
        JavaProject javaProject = (JavaProject)this.getJavaScriptProject();
        SearchableEnvironment searchableEnvironment = this.newSearchableNameEnvironment(workingCopyOwner);
        searchableEnvironment.unitToSkip = iCompilationUnit2;
        CompletionEngine completionEngine = new CompletionEngine(searchableEnvironment, completionRequestor, javaProject.getOptions(true), javaProject);
        completionEngine.complete(iCompilationUnit, n2, 0);
        if (performanceStats != null) {
            performanceStats.endRun();
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
    }

    protected IJavaScriptElement[] codeSelect(ICompilationUnit iCompilationUnit, int n2, int n3, WorkingCopyOwner workingCopyOwner) throws JavaScriptModelException {
        PerformanceStats performanceStats;
        PerformanceStats performanceStats2 = performanceStats = SelectionEngine.PERF ? PerformanceStats.getStats((String)"org.ccdt.jsdt.core/perf/selection", (Object)this) : null;
        if (performanceStats != null) {
            performanceStats.startRun(String.valueOf(new String(iCompilationUnit.getFileName())) + " at [" + n2 + "," + n3 + "]");
        }
        JavaProject javaProject = (JavaProject)this.getJavaScriptProject();
        SearchableEnvironment searchableEnvironment = this.newSearchableNameEnvironment(workingCopyOwner);
        SelectionRequestor selectionRequestor = new SelectionRequestor(searchableEnvironment.nameLookup, this);
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer == null) {
            return selectionRequestor.getElements();
        }
        int n4 = iBuffer.getLength();
        if (n2 < 0 || n3 < 0 || n2 + n3 > n4) {
            throw new JavaScriptModelException(new JavaModelStatus(980));
        }
        SelectionEngine selectionEngine = new SelectionEngine(searchableEnvironment, selectionRequestor, javaProject.getOptions(true));
        selectionEngine.select(iCompilationUnit, n2, n2 + n3 - 1);
        if (performanceStats != null) {
            performanceStats.endRun();
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + searchableEnvironment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
        return selectionRequestor.getElements();
    }

    @Override
    protected Object createElementInfo() {
        return new OpenableElementInfo();
    }

    @Override
    public boolean exists() {
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        if (javaModelManager.getInfo(this) != null) {
            return true;
        }
        if (!this.parentExists()) {
            return false;
        }
        PackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        if (!(packageFragmentRoot == null || packageFragmentRoot != this && packageFragmentRoot.isArchive())) {
            return this.resourceExists();
        }
        return super.exists();
    }

    @Override
    public String findRecommendedLineSeparator() throws JavaScriptModelException {
        IBuffer iBuffer = this.getBuffer();
        String string = iBuffer == null ? null : iBuffer.getContents();
        return Util.getLineSeparator(string, this.getJavaScriptProject());
    }

    @Override
    protected void generateInfos(Object object, HashMap hashMap, IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        Object object2;
        if (JavaModelCache.VERBOSE) {
            switch (this.getElementType()) {
                case 2: {
                    object2 = "project";
                    break;
                }
                case 3: {
                    object2 = "root";
                    break;
                }
                case 4: {
                    object2 = "package";
                    break;
                }
                case 6: {
                    object2 = "class file";
                    break;
                }
                case 5: {
                    object2 = "compilation unit";
                    break;
                }
                default: {
                    object2 = "element";
                }
            }
            System.out.println(Thread.currentThread() + " OPENING " + (String)object2 + " " + this.toStringWithAncestors());
        }
        this.openParent(object, hashMap, iProgressMonitor);
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        hashMap.put(this, object);
        try {
            object2 = (OpenableElementInfo)object;
            boolean bl2 = this.buildStructure((OpenableElementInfo)object2, iProgressMonitor, hashMap, this.getResource());
            ((OpenableElementInfo)object2).setIsStructureKnown(bl2);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            hashMap.remove(this);
            throw javaScriptModelException;
        }
        JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        if (JavaModelCache.VERBOSE) {
            System.out.println(JavaModelManager.getJavaModelManager().cacheToString("-> "));
        }
    }

    @Override
    public IBuffer getBuffer() throws JavaScriptModelException {
        if (this.hasBuffer()) {
            Object object = this.getElementInfo();
            IBuffer iBuffer = this.getBufferManager().getBuffer(this);
            if (iBuffer == null) {
                iBuffer = this.openBuffer(null, object);
            }
            if (iBuffer instanceof NullBuffer) {
                return null;
            }
            return iBuffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    @Override
    public IResource getCorrespondingResource() throws JavaScriptModelException {
        return this.getUnderlyingResource();
    }

    @Override
    public IOpenable getOpenable() {
        return this;
    }

    @Override
    public IResource getUnderlyingResource() throws JavaScriptModelException {
        IResource iResource = this.parent.getUnderlyingResource();
        if (iResource == null) {
            return null;
        }
        int n2 = iResource.getType();
        if (n2 == 2 || n2 == 4) {
            IContainer iContainer = (IContainer)iResource;
            IResource iResource2 = iContainer.findMember(this.getElementName());
            if (iResource2 == null) {
                throw this.newNotPresentException();
            }
            return iResource2;
        }
        return iResource;
    }

    protected boolean hasBuffer() {
        return false;
    }

    @Override
    public boolean hasUnsavedChanges() throws JavaScriptModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null && iBuffer.hasUnsavedChanges()) {
            return true;
        }
        int n2 = this.getElementType();
        if (n2 == 4 || n2 == 3 || n2 == 2 || n2 == 1) {
            Enumeration enumeration = this.getBufferManager().getOpenBuffers();
            while (enumeration.hasMoreElements()) {
                IJavaScriptElement iJavaScriptElement;
                IBuffer iBuffer2 = (IBuffer)enumeration.nextElement();
                if (!iBuffer2.hasUnsavedChanges() || !this.isAncestorOf(iJavaScriptElement = (IJavaScriptElement)((Object)iBuffer2.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return JavaModelManager.getJavaModelManager().getInfo(this) != null;
    }

    protected boolean isSourceElement() {
        return false;
    }

    @Override
    public boolean isStructureKnown() throws JavaScriptModelException {
        return ((OpenableElementInfo)this.getElementInfo()).isStructureKnown();
    }

    @Override
    public void makeConsistent(IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
    }

    @Override
    public void open(IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        this.getElementInfo(iProgressMonitor);
    }

    protected IBuffer openBuffer(IProgressMonitor iProgressMonitor, Object object) throws JavaScriptModelException {
        return null;
    }

    protected void openParent(Object object, HashMap hashMap, IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        Openable openable = (Openable)this.getOpenableParent();
        if (openable != null && !openable.isOpen()) {
            openable.generateInfos(openable.createElementInfo(), hashMap, iProgressMonitor);
        }
    }

    protected boolean parentExists() {
        IJavaScriptElement iJavaScriptElement = this.getParent();
        if (iJavaScriptElement == null) {
            return true;
        }
        return iJavaScriptElement.exists();
    }

    protected boolean resourceExists() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace == null) {
            return false;
        }
        return JavaModel.getTarget((IContainer)iWorkspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    @Override
    public void save(IProgressMonitor iProgressMonitor, boolean bl2) throws JavaScriptModelException {
        if (this.isReadOnly()) {
            throw new JavaScriptModelException(new JavaModelStatus(976, this));
        }
        IBuffer iBuffer = this.getBuffer();
        if (iBuffer != null) {
            iBuffer.save(iProgressMonitor, bl2);
            this.makeConsistent(iProgressMonitor);
        }
    }

    public PackageFragmentRoot getPackageFragmentRoot() {
        return (PackageFragmentRoot)this.getAncestor(3);
    }
}

