/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.ccdt.jsdt.core.IBuffer;
import org.ccdt.jsdt.core.IIncludePathEntry;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptElementDelta;
import org.ccdt.jsdt.core.IJavaScriptModel;
import org.ccdt.jsdt.core.IJavaScriptModelStatus;
import org.ccdt.jsdt.core.IJavaScriptUnit;
import org.ccdt.jsdt.core.IPackageFragment;
import org.ccdt.jsdt.core.IPackageFragmentRoot;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.core.CompilationUnit;
import org.ccdt.jsdt.internal.core.DeltaProcessor;
import org.ccdt.jsdt.internal.core.DocumentAdapter;
import org.ccdt.jsdt.internal.core.JavaElement;
import org.ccdt.jsdt.internal.core.JavaElementDelta;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.JavaModelOperation$IPostAction;
import org.ccdt.jsdt.internal.core.JavaModelStatus;
import org.ccdt.jsdt.internal.core.Openable;
import org.ccdt.jsdt.internal.core.util.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;

public abstract class JavaModelOperation
implements IWorkspaceRunnable,
IProgressMonitor {
    protected static final int APPEND = 1;
    protected static final int REMOVEALL_APPEND = 2;
    protected static final int KEEP_EXISTING = 3;
    protected static boolean POST_ACTION_VERBOSE;
    protected JavaModelOperation$IPostAction[] actions;
    protected int actionsStart = 0;
    protected int actionsEnd = -1;
    protected HashMap attributes;
    public static final String HAS_MODIFIED_RESOURCE_ATTR = "hasModifiedResource";
    public static final String TRUE = "true";
    protected IJavaScriptElement[] elementsToProcess;
    protected IJavaScriptElement[] parentElements;
    protected static IJavaScriptElement[] NO_ELEMENTS;
    protected IJavaScriptElement[] resultElements = NO_ELEMENTS;
    public IProgressMonitor progressMonitor = null;
    protected boolean isNested = false;
    protected boolean force = false;
    protected static ThreadLocal operationStacks;

    static {
        NO_ELEMENTS = new IJavaScriptElement[0];
        operationStacks = new ThreadLocal();
    }

    protected JavaModelOperation() {
    }

    protected JavaModelOperation(IJavaScriptElement[] iJavaScriptElementArray) {
        this.elementsToProcess = iJavaScriptElementArray;
    }

    protected JavaModelOperation(IJavaScriptElement[] iJavaScriptElementArray, IJavaScriptElement[] iJavaScriptElementArray2) {
        this.elementsToProcess = iJavaScriptElementArray;
        this.parentElements = iJavaScriptElementArray2;
    }

    protected JavaModelOperation(IJavaScriptElement[] iJavaScriptElementArray, IJavaScriptElement[] iJavaScriptElementArray2, boolean bl2) {
        this.elementsToProcess = iJavaScriptElementArray;
        this.parentElements = iJavaScriptElementArray2;
        this.force = bl2;
    }

    protected JavaModelOperation(IJavaScriptElement[] iJavaScriptElementArray, boolean bl2) {
        this.elementsToProcess = iJavaScriptElementArray;
        this.force = bl2;
    }

    protected JavaModelOperation(IJavaScriptElement iJavaScriptElement) {
        this.elementsToProcess = new IJavaScriptElement[]{iJavaScriptElement};
    }

    protected JavaModelOperation(IJavaScriptElement iJavaScriptElement, boolean bl2) {
        this.elementsToProcess = new IJavaScriptElement[]{iJavaScriptElement};
        this.force = bl2;
    }

    protected void addAction(JavaModelOperation$IPostAction javaModelOperation$IPostAction) {
        int n2 = this.actions.length;
        if (n2 == ++this.actionsEnd) {
            this.actions = new JavaModelOperation$IPostAction[n2 * 2];
            System.arraycopy(this.actions, 0, this.actions, 0, n2);
        }
        this.actions[this.actionsEnd] = javaModelOperation$IPostAction;
    }

    protected void addDelta(IJavaScriptElementDelta iJavaScriptElementDelta) {
        JavaModelManager.getJavaModelManager().getDeltaProcessor().registerJavaModelDelta(iJavaScriptElementDelta);
    }

    protected void addReconcileDelta(IJavaScriptUnit iJavaScriptUnit, IJavaScriptElementDelta iJavaScriptElementDelta) {
        HashMap hashMap = JavaModelManager.getJavaModelManager().getDeltaProcessor().reconcileDeltas;
        JavaElementDelta javaElementDelta = (JavaElementDelta)hashMap.get(iJavaScriptUnit);
        if (javaElementDelta != null) {
            IJavaScriptElementDelta[] iJavaScriptElementDeltaArray = iJavaScriptElementDelta.getAffectedChildren();
            int n2 = 0;
            int n3 = iJavaScriptElementDeltaArray.length;
            while (n2 < n3) {
                JavaElementDelta javaElementDelta2 = (JavaElementDelta)iJavaScriptElementDeltaArray[n2];
                javaElementDelta.insertDeltaTree(javaElementDelta2.getElement(), javaElementDelta2);
                ++n2;
            }
            if ((iJavaScriptElementDelta.getFlags() & 0x80000) != 0) {
                javaElementDelta.changedAST(iJavaScriptElementDelta.getJavaScriptUnitAST());
            }
        } else {
            hashMap.put(iJavaScriptUnit, iJavaScriptElementDelta);
        }
    }

    protected void removeReconcileDelta(IJavaScriptUnit iJavaScriptUnit) {
        JavaModelManager.getJavaModelManager().getDeltaProcessor().reconcileDeltas.remove(iJavaScriptUnit);
    }

    public void beginTask(String string, int n2) {
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask(string, n2);
        }
    }

    protected boolean canModifyRoots() {
        return false;
    }

    protected void checkCanceled() {
        if (this.isCanceled()) {
            throw new OperationCanceledException(Messages.operation_cancelled);
        }
    }

    protected IJavaScriptModelStatus commonVerify() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return new JavaModelStatus(968);
        }
        int n2 = 0;
        while (n2 < this.elementsToProcess.length) {
            if (this.elementsToProcess[n2] == null) {
                return new JavaModelStatus(968);
            }
            ++n2;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void copyResources(IResource[] iResourceArray, IPath iPath) throws JavaScriptModelException {
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(iResourceArray.length);
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.copy(iResourceArray, iPath, false, iProgressMonitor);
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaScriptModelException(coreException);
        }
    }

    protected void createFile(IContainer iContainer, String string, InputStream inputStream, boolean bl2) throws JavaScriptModelException {
        IFile iFile = iContainer.getFile((IPath)new Path(string));
        try {
            iFile.create(inputStream, bl2 ? 3 : 2, this.getSubProgressMonitor(1));
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaScriptModelException(coreException);
        }
    }

    protected void createFolder(IContainer iContainer, String string, boolean bl2) throws JavaScriptModelException {
        IFolder iFolder = iContainer.getFolder((IPath)new Path(string));
        try {
            iFolder.create(bl2 ? 3 : 2, true, this.getSubProgressMonitor(1));
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaScriptModelException(coreException);
        }
    }

    protected void deleteEmptyPackageFragment(IPackageFragment iPackageFragment, boolean bl2, IResource iResource) throws JavaScriptModelException {
        IContainer iContainer = (IContainer)iPackageFragment.getResource();
        try {
            iContainer.delete(bl2 ? 3 : 2, this.getSubProgressMonitor(1));
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            while (iContainer instanceof IFolder) {
                if ((iContainer = iContainer.getParent()).equals((Object)iResource) || iContainer.members().length != 0) continue;
                iContainer.delete(bl2 ? 3 : 2, this.getSubProgressMonitor(1));
                JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
            }
        }
        catch (CoreException coreException) {
            throw new JavaScriptModelException(coreException);
        }
    }

    protected void deleteResource(IResource iResource, int n2) throws JavaScriptModelException {
        try {
            iResource.delete(n2, this.getSubProgressMonitor(1));
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaScriptModelException(coreException);
        }
    }

    protected void deleteResources(IResource[] iResourceArray, boolean bl2) throws JavaScriptModelException {
        if (iResourceArray == null || iResourceArray.length == 0) {
            return;
        }
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(iResourceArray.length);
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.delete(iResourceArray, bl2 ? 3 : 2, iProgressMonitor);
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaScriptModelException(coreException);
        }
    }

    public void done() {
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    protected boolean equalsOneOf(IPath iPath, IPath[] iPathArray) {
        int n2 = 0;
        int n3 = iPathArray.length;
        while (n2 < n3) {
            if (iPath.equals((Object)iPathArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void executeNestedOperation(JavaModelOperation javaModelOperation, int n2) throws JavaScriptModelException {
        IJavaScriptModelStatus iJavaScriptModelStatus = javaModelOperation.verify();
        if (!iJavaScriptModelStatus.isOK()) {
            throw new JavaScriptModelException(iJavaScriptModelStatus);
        }
        IProgressMonitor iProgressMonitor = this.getSubProgressMonitor(n2);
        try {
            javaModelOperation.setNested(true);
            javaModelOperation.run(iProgressMonitor);
        }
        catch (CoreException coreException) {
            Throwable throwable;
            if (coreException instanceof JavaScriptModelException) {
                throw (JavaScriptModelException)coreException;
            }
            if (coreException.getStatus().getCode() == 76 && (throwable = coreException.getStatus().getException()) instanceof JavaScriptModelException) {
                throw (JavaScriptModelException)((Object)throwable);
            }
            throw new JavaScriptModelException(coreException);
        }
    }

    protected abstract void executeOperation() throws JavaScriptModelException;

    protected static Object getAttribute(Object object) {
        ArrayList arrayList = JavaModelOperation.getCurrentOperationStack();
        if (arrayList.size() == 0) {
            return null;
        }
        JavaModelOperation javaModelOperation = (JavaModelOperation)arrayList.get(0);
        if (javaModelOperation.attributes == null) {
            return null;
        }
        return javaModelOperation.attributes.get(object);
    }

    protected IJavaScriptUnit getCompilationUnitFor(IJavaScriptElement iJavaScriptElement) {
        return ((JavaElement)iJavaScriptElement).getJavaScriptUnit();
    }

    protected static ArrayList getCurrentOperationStack() {
        ArrayList arrayList = (ArrayList)operationStacks.get();
        if (arrayList == null) {
            arrayList = new ArrayList();
            operationStacks.set(arrayList);
        }
        return arrayList;
    }

    protected IDocument getDocument(IJavaScriptUnit iJavaScriptUnit) throws JavaScriptModelException {
        IBuffer iBuffer = iJavaScriptUnit.getBuffer();
        if (iBuffer instanceof IDocument) {
            return (IDocument)iBuffer;
        }
        return new DocumentAdapter(iBuffer);
    }

    protected IJavaScriptElement[] getElementsToProcess() {
        return this.elementsToProcess;
    }

    protected IJavaScriptElement getElementToProcess() {
        if (this.elementsToProcess == null || this.elementsToProcess.length == 0) {
            return null;
        }
        return this.elementsToProcess[0];
    }

    public IJavaScriptModel getJavaModel() {
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    protected IPath[] getNestedFolders(IPackageFragmentRoot iPackageFragmentRoot) throws JavaScriptModelException {
        IPath iPath = iPackageFragmentRoot.getPath();
        IIncludePathEntry[] iIncludePathEntryArray = iPackageFragmentRoot.getJavaScriptProject().getRawIncludepath();
        int n2 = iIncludePathEntryArray.length;
        IPath[] iPathArray = new IPath[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            IPath iPath2 = iIncludePathEntryArray[n4].getPath();
            if (iPath.isPrefixOf(iPath2) && !iPath.equals((Object)iPath2)) {
                iPathArray[n3++] = iPath2;
            }
            ++n4;
        }
        if (n3 < n2) {
            IPath[] iPathArray2 = iPathArray;
            iPathArray = new IPath[n3];
            System.arraycopy(iPathArray2, 0, iPathArray, 0, n3);
        }
        return iPathArray;
    }

    protected IJavaScriptElement getParentElement() {
        if (this.parentElements == null || this.parentElements.length == 0) {
            return null;
        }
        return this.parentElements[0];
    }

    protected IJavaScriptElement[] getParentElements() {
        return this.parentElements;
    }

    public IJavaScriptElement[] getResultElements() {
        return this.resultElements;
    }

    protected ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IProgressMonitor getSubProgressMonitor(int n2) {
        SubProgressMonitor subProgressMonitor = null;
        if (this.progressMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.progressMonitor, n2, 4);
        }
        return subProgressMonitor;
    }

    public boolean hasModifiedResource() {
        return !this.isReadOnly() && JavaModelOperation.getAttribute(HAS_MODIFIED_RESOURCE_ATTR) == TRUE;
    }

    public void internalWorked(double d2) {
        if (this.progressMonitor != null) {
            this.progressMonitor.internalWorked(d2);
        }
    }

    public boolean isCanceled() {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isCanceled();
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean isTopLevelOperation() {
        ArrayList arrayList = JavaModelOperation.getCurrentOperationStack();
        return arrayList.size() > 0 && arrayList.get(0) == this;
    }

    protected int firstActionWithID(String string, int n2) {
        int n3 = n2;
        while (n3 <= this.actionsEnd) {
            if (this.actions[n3].getID().equals(string)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    protected void moveResources(IResource[] iResourceArray, IPath iPath) throws JavaScriptModelException {
        SubProgressMonitor subProgressMonitor = null;
        if (this.progressMonitor != null) {
            subProgressMonitor = new SubProgressMonitor(this.progressMonitor, iResourceArray.length, 4);
        }
        IWorkspace iWorkspace = iResourceArray[0].getWorkspace();
        try {
            iWorkspace.move(iResourceArray, iPath, false, (IProgressMonitor)subProgressMonitor);
            JavaModelOperation.setAttribute(HAS_MODIFIED_RESOURCE_ATTR, TRUE);
        }
        catch (CoreException coreException) {
            throw new JavaScriptModelException(coreException);
        }
    }

    public JavaElementDelta newJavaElementDelta() {
        return new JavaElementDelta(this.getJavaModel());
    }

    protected JavaModelOperation popOperation() {
        ArrayList arrayList = JavaModelOperation.getCurrentOperationStack();
        int n2 = arrayList.size();
        if (n2 > 0) {
            if (n2 == 1) {
                operationStacks.set(null);
            }
            return (JavaModelOperation)arrayList.remove(n2 - 1);
        }
        return null;
    }

    protected void postAction(JavaModelOperation$IPostAction javaModelOperation$IPostAction, int n2) {
        if (POST_ACTION_VERBOSE) {
            System.out.print("(" + Thread.currentThread() + ") [JavaModelOperation.postAction(IPostAction, int)] Posting action " + javaModelOperation$IPostAction.getID());
            switch (n2) {
                case 2: {
                    System.out.println(" (REMOVEALL_APPEND)");
                    break;
                }
                case 3: {
                    System.out.println(" (KEEP_EXISTING)");
                    break;
                }
                case 1: {
                    System.out.println(" (APPEND)");
                }
            }
        }
        JavaModelOperation javaModelOperation = (JavaModelOperation)JavaModelOperation.getCurrentOperationStack().get(0);
        JavaModelOperation$IPostAction[] javaModelOperation$IPostActionArray = javaModelOperation.actions;
        if (javaModelOperation$IPostActionArray == null) {
            javaModelOperation.actions = javaModelOperation$IPostActionArray = new JavaModelOperation$IPostAction[1];
            javaModelOperation$IPostActionArray[0] = javaModelOperation$IPostAction;
            javaModelOperation.actionsEnd = 0;
        } else {
            String string = javaModelOperation$IPostAction.getID();
            switch (n2) {
                case 2: {
                    int n3 = this.actionsStart - 1;
                    while ((n3 = javaModelOperation.firstActionWithID(string, n3 + 1)) >= 0) {
                        System.arraycopy(javaModelOperation$IPostActionArray, n3 + 1, javaModelOperation$IPostActionArray, n3, javaModelOperation.actionsEnd - n3);
                        javaModelOperation$IPostActionArray[javaModelOperation.actionsEnd--] = null;
                    }
                    javaModelOperation.addAction(javaModelOperation$IPostAction);
                    break;
                }
                case 3: {
                    if (javaModelOperation.firstActionWithID(string, 0) >= 0) break;
                    javaModelOperation.addAction(javaModelOperation$IPostAction);
                    break;
                }
                case 1: {
                    javaModelOperation.addAction(javaModelOperation$IPostAction);
                }
            }
        }
    }

    protected boolean prefixesOneOf(IPath iPath, IPath[] iPathArray) {
        int n2 = 0;
        int n3 = iPathArray.length;
        while (n2 < n3) {
            if (iPath.isPrefixOf(iPathArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void pushOperation(JavaModelOperation javaModelOperation) {
        JavaModelOperation.getCurrentOperationStack().add(javaModelOperation);
    }

    protected void removeAllPostAction(String string) {
        if (POST_ACTION_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [JavaModelOperation.removeAllPostAction(String)] Removing actions " + string);
        }
        JavaModelOperation javaModelOperation = (JavaModelOperation)JavaModelOperation.getCurrentOperationStack().get(0);
        JavaModelOperation$IPostAction[] javaModelOperation$IPostActionArray = javaModelOperation.actions;
        if (javaModelOperation$IPostActionArray == null) {
            return;
        }
        int n2 = this.actionsStart - 1;
        while ((n2 = javaModelOperation.firstActionWithID(string, n2 + 1)) >= 0) {
            System.arraycopy(javaModelOperation$IPostActionArray, n2 + 1, javaModelOperation$IPostActionArray, n2, javaModelOperation.actionsEnd - n2);
            javaModelOperation$IPostActionArray[javaModelOperation.actionsEnd--] = null;
        }
    }

    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
        block23: {
            JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
            DeltaProcessor deltaProcessor = javaModelManager.getDeltaProcessor();
            int n2 = deltaProcessor.javaModelDeltas.size();
            try {
                this.progressMonitor = iProgressMonitor;
                this.pushOperation(this);
                try {
                    if (this.canModifyRoots()) {
                        JavaModelManager.getJavaModelManager().deltaState.initializeRoots();
                    }
                    this.executeOperation();
                }
                catch (Throwable throwable) {
                    if (this.isTopLevelOperation()) {
                        this.runPostActions();
                    }
                    throw throwable;
                }
                if (this.isTopLevelOperation()) {
                    this.runPostActions();
                }
            }
            finally {
                try {
                    deltaProcessor = javaModelManager.getDeltaProcessor();
                    int n3 = n2;
                    int n4 = deltaProcessor.javaModelDeltas.size();
                    while (n3 < n4) {
                        deltaProcessor.updateJavaModel((IJavaScriptElementDelta)deltaProcessor.javaModelDeltas.get(n3));
                        ++n3;
                    }
                    n3 = 0;
                    n4 = this.resultElements.length;
                    while (n3 < n4) {
                        IJavaScriptElement iJavaScriptElement = this.resultElements[n3];
                        Openable openable = (Openable)iJavaScriptElement.getOpenable();
                        if (!(openable instanceof CompilationUnit) || !((CompilationUnit)openable).isWorkingCopy()) {
                            ((JavaElement)openable.getParent()).close();
                        }
                        switch (iJavaScriptElement.getElementType()) {
                            case 3: 
                            case 4: {
                                deltaProcessor.projectCachesToReset.add(iJavaScriptElement.getJavaScriptProject());
                            }
                        }
                        ++n3;
                    }
                    deltaProcessor.resetProjectCaches();
                    if (!(!this.isTopLevelOperation() || deltaProcessor.javaModelDeltas.size() <= n2 && deltaProcessor.reconcileDeltas.isEmpty() || this.hasModifiedResource())) {
                        deltaProcessor.fire(null, 0);
                    }
                    break block23;
                }
                finally {
                    this.popOperation();
                }
            }
            {
            }
        }
    }

    public void runOperation(IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        IJavaScriptModelStatus iJavaScriptModelStatus = this.verify();
        if (!iJavaScriptModelStatus.isOK()) {
            throw new JavaScriptModelException(iJavaScriptModelStatus);
        }
        try {
            if (this.isReadOnly()) {
                this.run(iProgressMonitor);
            } else {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this, this.getSchedulingRule(), 1, iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            Throwable throwable;
            if (coreException instanceof JavaScriptModelException) {
                throw (JavaScriptModelException)coreException;
            }
            if (coreException.getStatus().getCode() == 76 && (throwable = coreException.getStatus().getException()) instanceof JavaScriptModelException) {
                throw (JavaScriptModelException)((Object)throwable);
            }
            throw new JavaScriptModelException(coreException);
        }
    }

    protected void runPostActions() throws JavaScriptModelException {
        while (this.actionsStart <= this.actionsEnd) {
            JavaModelOperation$IPostAction javaModelOperation$IPostAction = this.actions[this.actionsStart++];
            if (POST_ACTION_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JavaModelOperation.runPostActions()] Running action " + javaModelOperation$IPostAction.getID());
            }
            javaModelOperation$IPostAction.run();
        }
    }

    protected static void setAttribute(Object object, Object object2) {
        ArrayList arrayList = JavaModelOperation.getCurrentOperationStack();
        if (arrayList.size() == 0) {
            return;
        }
        JavaModelOperation javaModelOperation = (JavaModelOperation)arrayList.get(0);
        if (javaModelOperation.attributes == null) {
            javaModelOperation.attributes = new HashMap();
        }
        javaModelOperation.attributes.put(object, object2);
    }

    public void setCanceled(boolean bl2) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setCanceled(bl2);
        }
    }

    protected void setNested(boolean bl2) {
        this.isNested = bl2;
    }

    public void setTaskName(String string) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTaskName(string);
        }
    }

    public void subTask(String string) {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(string);
        }
    }

    protected IJavaScriptModelStatus verify() {
        return this.commonVerify();
    }

    public void worked(int n2) {
        if (this.progressMonitor != null) {
            this.progressMonitor.worked(n2);
            this.checkCanceled();
        }
    }
}

