/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.ccdt.jsdt.core.IIncludePathEntry;
import org.ccdt.jsdt.core.IJavaScriptModelStatus;
import org.ccdt.jsdt.internal.core.DeltaProcessor;
import org.ccdt.jsdt.internal.core.JavaModel;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.JavaModelStatus;
import org.ccdt.jsdt.internal.core.JavaProject;
import org.ccdt.jsdt.internal.core.util.LRUCache;
import org.ccdt.jsdt.internal.core.util.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class JavaModelManager$PerProjectInfo {
    public IProject project;
    public Object savedState = null;
    public boolean triedRead = false;
    public IIncludePathEntry[] rawClasspath;
    public IJavaScriptModelStatus rawClasspathStatus;
    public IIncludePathEntry[] resolvedClasspath;
    public IJavaScriptModelStatus unresolvedEntryStatus;
    public Map rootPathToRawEntries;
    public Map rootPathToResolvedEntries;
    public IPath outputLocation;
    public IEclipsePreferences preferences;
    public Hashtable options;
    public Hashtable secondaryTypes;
    public LRUCache javadocCache;

    public JavaModelManager$PerProjectInfo(IProject iProject) {
        this.project = iProject;
        this.javadocCache = new LRUCache(10);
    }

    public void rememberExternalLibTimestamps() {
        IIncludePathEntry[] iIncludePathEntryArray = this.resolvedClasspath;
        if (iIncludePathEntryArray == null) {
            return;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Hashtable hashtable = JavaModelManager.getJavaModelManager().deltaState.getExternalLibTimeStamps();
        int n2 = 0;
        int n3 = iIncludePathEntryArray.length;
        while (n2 < n3) {
            Object object;
            IPath iPath;
            IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray[n2];
            if (iIncludePathEntry.getEntryKind() == 1 && hashtable.get(iPath = iIncludePathEntry.getPath()) == null && (object = JavaModel.getTarget((IContainer)iWorkspaceRoot, iPath, true)) instanceof File) {
                long l2 = DeltaProcessor.getTimeStamp((File)object);
                hashtable.put(iPath, new Long(l2));
            }
            ++n2;
        }
    }

    public synchronized void resetResolvedClasspath() {
        this.setClasspath(this.rawClasspath, this.outputLocation, this.rawClasspathStatus, null, null, null, null);
    }

    public synchronized void setClasspath(IIncludePathEntry[] iIncludePathEntryArray, IPath iPath, IJavaScriptModelStatus iJavaScriptModelStatus, IIncludePathEntry[] iIncludePathEntryArray2, Map map, Map map2, IJavaScriptModelStatus iJavaScriptModelStatus2) {
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        DeltaProcessor deltaProcessor = javaModelManager.deltaState.getDeltaProcessor();
        deltaProcessor.addClasspathChange(this.project, this.rawClasspath, this.outputLocation, this.resolvedClasspath);
        this.rawClasspath = iIncludePathEntryArray;
        this.outputLocation = iPath;
        this.rawClasspathStatus = iJavaScriptModelStatus;
        this.resolvedClasspath = iIncludePathEntryArray2;
        this.rootPathToRawEntries = map;
        this.rootPathToResolvedEntries = map2;
        this.unresolvedEntryStatus = iJavaScriptModelStatus2;
        this.javadocCache = new LRUCache(10);
    }

    public synchronized IIncludePathEntry[] readAndCacheClasspath(JavaProject javaProject) {
        IIncludePathEntry iIncludePathEntry;
        IJavaScriptModelStatus iJavaScriptModelStatus;
        IIncludePathEntry[] iIncludePathEntryArray;
        try {
            iIncludePathEntryArray = javaProject.readFileEntriesWithException(null);
            iJavaScriptModelStatus = JavaModelStatus.VERIFIED_OK;
        }
        catch (CoreException coreException) {
            iIncludePathEntryArray = JavaProject.INVALID_CLASSPATH;
            iJavaScriptModelStatus = new JavaModelStatus(1000, Messages.bind(Messages.classpath_cannotReadClasspathFile, javaProject.getElementName()));
        }
        catch (IOException iOException) {
            iIncludePathEntryArray = JavaProject.INVALID_CLASSPATH;
            iJavaScriptModelStatus = Messages.file_badFormat.equals(iOException.getMessage()) ? new JavaModelStatus(1000, Messages.bind(Messages.classpath_xmlFormatError, javaProject.getElementName(), Messages.file_badFormat)) : new JavaModelStatus(1000, Messages.bind(Messages.classpath_cannotReadClasspathFile, javaProject.getElementName()));
        }
        catch (AssertionFailedException assertionFailedException) {
            iIncludePathEntryArray = JavaProject.INVALID_CLASSPATH;
            iJavaScriptModelStatus = new JavaModelStatus(1000, Messages.bind(Messages.classpath_illegalEntryInClasspathFile, new String[]{javaProject.getElementName(), assertionFailedException.getMessage()}));
        }
        IPath iPath = null;
        if (iIncludePathEntryArray.length > 0 && (iIncludePathEntry = iIncludePathEntryArray[iIncludePathEntryArray.length - 1]).getContentKind() == 10) {
            iPath = iIncludePathEntry.getPath();
            IIncludePathEntry[] iIncludePathEntryArray2 = new IIncludePathEntry[iIncludePathEntryArray.length - 1];
            System.arraycopy(iIncludePathEntryArray, 0, iIncludePathEntryArray2, 0, iIncludePathEntryArray2.length);
            iIncludePathEntryArray = iIncludePathEntryArray2;
        }
        this.setClasspath(iIncludePathEntryArray, iPath, iJavaScriptModelStatus, null, null, null, null);
        return iIncludePathEntryArray;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Info for ");
        stringBuffer.append(this.project.getFullPath());
        stringBuffer.append("\nRaw classpath:\n");
        if (this.rawClasspath == null) {
            stringBuffer.append("  <null>\n");
        } else {
            int n3 = 0;
            n2 = this.rawClasspath.length;
            while (n3 < n2) {
                stringBuffer.append("  ");
                stringBuffer.append(this.rawClasspath[n3]);
                stringBuffer.append('\n');
                ++n3;
            }
        }
        stringBuffer.append("Resolved classpath:\n");
        IIncludePathEntry[] iIncludePathEntryArray = this.resolvedClasspath;
        if (iIncludePathEntryArray == null) {
            stringBuffer.append("  <null>\n");
        } else {
            n2 = 0;
            int n4 = iIncludePathEntryArray.length;
            while (n2 < n4) {
                stringBuffer.append("  ");
                stringBuffer.append(iIncludePathEntryArray[n2]);
                stringBuffer.append('\n');
                ++n2;
            }
        }
        stringBuffer.append("Output location:\n  ");
        if (this.outputLocation == null) {
            stringBuffer.append("<null>");
        } else {
            stringBuffer.append(this.outputLocation);
        }
        return stringBuffer.toString();
    }
}

