/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.internal.core.ElementCache;
import org.ccdt.jsdt.internal.core.JavaElement;
import org.ccdt.jsdt.internal.core.JavaElementInfo;
import org.ccdt.jsdt.internal.core.JavaModelInfo;
import org.ccdt.jsdt.internal.core.VerboseElementCache;
import org.ccdt.jsdt.internal.core.util.LRUCache;

public class JavaModelCache {
    public static boolean VERBOSE = false;
    public static final int DEFAULT_PROJECT_SIZE = 5;
    public static final int DEFAULT_ROOT_SIZE = 50;
    public static final int DEFAULT_PKG_SIZE = 500;
    public static final int DEFAULT_OPENABLE_SIZE = 500;
    public static final int DEFAULT_CHILDREN_SIZE = 10000;
    public static final Object NON_EXISTING_JAR_TYPE_INFO = new Object();
    protected double memoryRatio = -1.0;
    protected JavaModelInfo modelInfo;
    protected HashMap projectCache;
    protected ElementCache rootCache;
    protected ElementCache pkgCache;
    protected ElementCache openableCache;
    protected Map childrenCache;
    protected LRUCache jarTypeCache;

    public JavaModelCache() {
        double d2 = this.getMemoryRatio();
        this.projectCache = new HashMap(5);
        if (VERBOSE) {
            this.rootCache = new VerboseElementCache((int)(50.0 * d2), "Root cache");
            this.pkgCache = new VerboseElementCache((int)(500.0 * d2), "Package cache");
            this.openableCache = new VerboseElementCache((int)(500.0 * d2), "Openable cache");
        } else {
            this.rootCache = new ElementCache((int)(50.0 * d2));
            this.pkgCache = new ElementCache((int)(500.0 * d2));
            this.openableCache = new ElementCache((int)(500.0 * d2));
        }
        this.childrenCache = new HashMap((int)(10000.0 * d2));
        this.resetJarTypeCache();
    }

    public Object getInfo(IJavaScriptElement iJavaScriptElement) {
        switch (iJavaScriptElement.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(iJavaScriptElement);
            }
            case 3: {
                return this.rootCache.get(iJavaScriptElement);
            }
            case 4: {
                return this.pkgCache.get(iJavaScriptElement);
            }
            case 5: 
            case 6: {
                return this.openableCache.get(iJavaScriptElement);
            }
            case 7: {
                Object object = this.jarTypeCache.get(iJavaScriptElement);
                if (object != null) {
                    return object;
                }
                return this.childrenCache.get(iJavaScriptElement);
            }
        }
        return this.childrenCache.get(iJavaScriptElement);
    }

    protected double getMemoryRatio() {
        if (this.memoryRatio == -1.0) {
            long l2 = Runtime.getRuntime().maxMemory();
            this.memoryRatio = l2 == Long.MAX_VALUE ? 4.0 : (double)l2 / 6.7108864E7;
        }
        return this.memoryRatio;
    }

    protected Object peekAtInfo(IJavaScriptElement iJavaScriptElement) {
        switch (iJavaScriptElement.getElementType()) {
            case 1: {
                return this.modelInfo;
            }
            case 2: {
                return this.projectCache.get(iJavaScriptElement);
            }
            case 3: {
                return this.rootCache.peek(iJavaScriptElement);
            }
            case 4: {
                return this.pkgCache.peek(iJavaScriptElement);
            }
            case 5: 
            case 6: {
                return this.openableCache.peek(iJavaScriptElement);
            }
            case 7: {
                Object object = this.jarTypeCache.peek(iJavaScriptElement);
                if (object != null) {
                    return object;
                }
                return this.childrenCache.get(iJavaScriptElement);
            }
        }
        return this.childrenCache.get(iJavaScriptElement);
    }

    protected void putInfo(IJavaScriptElement iJavaScriptElement, Object object) {
        switch (iJavaScriptElement.getElementType()) {
            case 1: {
                this.modelInfo = (JavaModelInfo)object;
                break;
            }
            case 2: {
                this.projectCache.put(iJavaScriptElement, object);
                this.rootCache.ensureSpaceLimit(((JavaElementInfo)object).children.length, iJavaScriptElement);
                break;
            }
            case 3: {
                this.rootCache.put(iJavaScriptElement, object);
                this.pkgCache.ensureSpaceLimit(((JavaElementInfo)object).children.length, iJavaScriptElement);
                break;
            }
            case 4: {
                this.pkgCache.put(iJavaScriptElement, object);
                this.openableCache.ensureSpaceLimit(((JavaElementInfo)object).children.length, iJavaScriptElement);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.put(iJavaScriptElement, object);
                break;
            }
            default: {
                this.childrenCache.put(iJavaScriptElement, object);
            }
        }
    }

    protected void removeInfo(JavaElement javaElement) {
        switch (javaElement.getElementType()) {
            case 1: {
                this.modelInfo = null;
                break;
            }
            case 2: {
                this.projectCache.remove(javaElement);
                this.rootCache.resetSpaceLimit((int)(50.0 * this.getMemoryRatio()), javaElement);
                break;
            }
            case 3: {
                this.rootCache.remove(javaElement);
                this.pkgCache.resetSpaceLimit((int)(500.0 * this.getMemoryRatio()), javaElement);
                break;
            }
            case 4: {
                this.pkgCache.remove(javaElement);
                this.openableCache.resetSpaceLimit((int)(500.0 * this.getMemoryRatio()), javaElement);
                break;
            }
            case 5: 
            case 6: {
                this.openableCache.remove(javaElement);
                break;
            }
            default: {
                this.childrenCache.remove(javaElement);
            }
        }
    }

    protected void resetJarTypeCache() {
        this.jarTypeCache = new LRUCache((int)(500.0 * this.getMemoryRatio()));
    }

    public String toString() {
        return this.toStringFillingRation("");
    }

    public String toStringFillingRation(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("Project cache: ");
        stringBuffer.append(this.projectCache.size());
        stringBuffer.append(" projects\n");
        stringBuffer.append(string);
        stringBuffer.append(this.rootCache.toStringFillingRation("Root cache"));
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append(this.pkgCache.toStringFillingRation("Package cache"));
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append(this.openableCache.toStringFillingRation("Openable cache"));
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append(this.jarTypeCache.toStringFillingRation("Jar type cache"));
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

