/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptModel;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.core.WorkingCopyOwner;
import org.ccdt.jsdt.internal.core.CopyElementsOperation;
import org.ccdt.jsdt.internal.core.CopyResourceElementsOperation;
import org.ccdt.jsdt.internal.core.DeleteElementsOperation;
import org.ccdt.jsdt.internal.core.DeleteResourceElementsOperation;
import org.ccdt.jsdt.internal.core.JavaElement;
import org.ccdt.jsdt.internal.core.JavaModelInfo;
import org.ccdt.jsdt.internal.core.JavaModelManager;
import org.ccdt.jsdt.internal.core.JavaProject;
import org.ccdt.jsdt.internal.core.MoveElementsOperation;
import org.ccdt.jsdt.internal.core.MoveResourceElementsOperation;
import org.ccdt.jsdt.internal.core.MultiOperation;
import org.ccdt.jsdt.internal.core.Openable;
import org.ccdt.jsdt.internal.core.OpenableElementInfo;
import org.ccdt.jsdt.internal.core.RenameElementsOperation;
import org.ccdt.jsdt.internal.core.RenameResourceElementsOperation;
import org.ccdt.jsdt.internal.core.util.MementoTokenizer;
import org.ccdt.jsdt.internal.core.util.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class JavaModel
extends Openable
implements IJavaScriptModel {
    public static HashSet existingExternalFiles = new HashSet();
    public static HashSet existingExternalConfirmedFiles = new HashSet();

    protected JavaModel() throws Error {
        super(null);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo openableElementInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n2 = iProjectArray.length;
        IJavaScriptElement[] iJavaScriptElementArray = new IJavaScriptElement[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            IProject iProject = iProjectArray[n4];
            if (JavaProject.hasJavaNature(iProject)) {
                iJavaScriptElementArray[n3++] = this.getJavaProject((IResource)iProject);
            }
            ++n4;
        }
        if (n3 < n2) {
            IJavaScriptElement[] iJavaScriptElementArray2 = iJavaScriptElementArray;
            iJavaScriptElementArray = new IJavaScriptElement[n3];
            System.arraycopy(iJavaScriptElementArray2, 0, iJavaScriptElementArray, 0, n3);
        }
        openableElementInfo.setChildren(iJavaScriptElementArray);
        map.put(this, openableElementInfo);
        return true;
    }

    @Override
    public boolean contains(IResource iResource) {
        IJavaScriptProject[] iJavaScriptProjectArray;
        switch (iResource.getType()) {
            case 4: 
            case 8: {
                return true;
            }
        }
        try {
            iJavaScriptProjectArray = this.getJavaScriptProjects();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
        int n2 = 0;
        int n3 = iJavaScriptProjectArray.length;
        while (n2 < n3) {
            JavaProject javaProject = (JavaProject)iJavaScriptProjectArray[n2];
            if (!javaProject.contains(iResource)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void copy(IJavaScriptElement[] iJavaScriptElementArray, IJavaScriptElement[] iJavaScriptElementArray2, IJavaScriptElement[] iJavaScriptElementArray3, String[] stringArray, boolean bl2, IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        if (iJavaScriptElementArray != null && iJavaScriptElementArray.length > 0 && iJavaScriptElementArray[0] != null && iJavaScriptElementArray[0].getElementType() < 7) {
            this.runOperation(new CopyResourceElementsOperation(iJavaScriptElementArray, iJavaScriptElementArray2, bl2), iJavaScriptElementArray, iJavaScriptElementArray3, stringArray, iProgressMonitor);
        } else {
            this.runOperation(new CopyElementsOperation(iJavaScriptElementArray, iJavaScriptElementArray2, bl2), iJavaScriptElementArray, iJavaScriptElementArray3, stringArray, iProgressMonitor);
        }
    }

    @Override
    protected Object createElementInfo() {
        return new JavaModelInfo();
    }

    @Override
    public void delete(IJavaScriptElement[] iJavaScriptElementArray, boolean bl2, IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        if (iJavaScriptElementArray != null && iJavaScriptElementArray.length > 0 && iJavaScriptElementArray[0] != null && iJavaScriptElementArray[0].getElementType() < 7) {
            new DeleteResourceElementsOperation(iJavaScriptElementArray, bl2).runOperation(iProgressMonitor);
        } else {
            new DeleteElementsOperation(iJavaScriptElementArray, bl2).runOperation(iProgressMonitor);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof JavaModel)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int getElementType() {
        return 1;
    }

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
        existingExternalConfirmedFiles = new HashSet();
    }

    @Override
    public IJavaScriptElement getHandleFromMemento(String string, MementoTokenizer mementoTokenizer, WorkingCopyOwner workingCopyOwner) {
        switch (string.charAt(0)) {
            case '=': {
                if (!mementoTokenizer.hasMoreTokens()) {
                    return this;
                }
                String string2 = mementoTokenizer.nextToken();
                JavaElement javaElement = (JavaElement)((Object)this.getJavaScriptProject(string2));
                return javaElement.getHandleFromMemento(mementoTokenizer, workingCopyOwner);
            }
        }
        return null;
    }

    @Override
    protected void getHandleMemento(StringBuffer stringBuffer) {
        stringBuffer.append(this.getElementName());
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    @Override
    public IJavaScriptProject getJavaScriptProject(String string) {
        return new JavaProject(ResourcesPlugin.getWorkspace().getRoot().getProject(string), this);
    }

    public IJavaScriptProject getJavaProject(IResource iResource) {
        switch (iResource.getType()) {
            case 2: {
                return new JavaProject(((IFolder)iResource).getProject(), this);
            }
            case 1: {
                return new JavaProject(((IFile)iResource).getProject(), this);
            }
            case 4: {
                return new JavaProject((IProject)iResource, this);
            }
        }
        throw new IllegalArgumentException(Messages.element_invalidResourceForProject);
    }

    @Override
    public IJavaScriptProject[] getJavaScriptProjects() throws JavaScriptModelException {
        ArrayList arrayList = this.getChildrenOfType(2);
        IJavaScriptProject[] iJavaScriptProjectArray = new IJavaScriptProject[arrayList.size()];
        arrayList.toArray(iJavaScriptProjectArray);
        return iJavaScriptProjectArray;
    }

    @Override
    public Object[] getNonJavaScriptResources() throws JavaScriptModelException {
        return ((JavaModelInfo)this.getElementInfo()).a();
    }

    @Override
    public IPath getPath() {
        return Path.ROOT;
    }

    @Override
    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public IResource getUnderlyingResource() {
        return null;
    }

    @Override
    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    @Override
    public void move(IJavaScriptElement[] iJavaScriptElementArray, IJavaScriptElement[] iJavaScriptElementArray2, IJavaScriptElement[] iJavaScriptElementArray3, String[] stringArray, boolean bl2, IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        if (iJavaScriptElementArray != null && iJavaScriptElementArray.length > 0 && iJavaScriptElementArray[0] != null && iJavaScriptElementArray[0].getElementType() < 7) {
            this.runOperation(new MoveResourceElementsOperation(iJavaScriptElementArray, iJavaScriptElementArray2, bl2), iJavaScriptElementArray, iJavaScriptElementArray3, stringArray, iProgressMonitor);
        } else {
            this.runOperation(new MoveElementsOperation(iJavaScriptElementArray, iJavaScriptElementArray2, bl2), iJavaScriptElementArray, iJavaScriptElementArray3, stringArray, iProgressMonitor);
        }
    }

    @Override
    public void refreshExternalArchives(IJavaScriptElement[] iJavaScriptElementArray, IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        if (iJavaScriptElementArray == null) {
            iJavaScriptElementArray = new IJavaScriptElement[]{this};
        }
        JavaModelManager.getJavaModelManager().getDeltaProcessor().checkExternalArchiveChanges(iJavaScriptElementArray, iProgressMonitor);
    }

    @Override
    public void rename(IJavaScriptElement[] iJavaScriptElementArray, IJavaScriptElement[] iJavaScriptElementArray2, String[] stringArray, boolean bl2, IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        MultiOperation multiOperation = iJavaScriptElementArray != null && iJavaScriptElementArray.length > 0 && iJavaScriptElementArray[0] != null && iJavaScriptElementArray[0].getElementType() < 7 ? new RenameResourceElementsOperation(iJavaScriptElementArray, iJavaScriptElementArray2, stringArray, bl2) : new RenameElementsOperation(iJavaScriptElementArray, iJavaScriptElementArray2, stringArray, bl2);
        multiOperation.runOperation(iProgressMonitor);
    }

    protected void runOperation(MultiOperation multiOperation, IJavaScriptElement[] iJavaScriptElementArray, IJavaScriptElement[] iJavaScriptElementArray2, String[] stringArray, IProgressMonitor iProgressMonitor) throws JavaScriptModelException {
        multiOperation.setRenamings(stringArray);
        if (iJavaScriptElementArray2 != null) {
            int n2 = 0;
            while (n2 < iJavaScriptElementArray.length) {
                multiOperation.setInsertBefore(iJavaScriptElementArray[n2], iJavaScriptElementArray2[n2]);
                ++n2;
            }
        }
        multiOperation.runOperation(iProgressMonitor);
    }

    @Override
    protected void toStringInfo(int n2, StringBuffer stringBuffer, Object object, boolean bl2) {
        stringBuffer.append(this.tabString(n2));
        stringBuffer.append("Java Model");
        if (object == null) {
            stringBuffer.append(" (not open)");
        }
    }

    public static Object getTarget(IContainer iContainer, IPath iPath, boolean bl2) {
        IResource iResource;
        if (iPath == null) {
            return null;
        }
        if (iPath.getDevice() == null && (iResource = iContainer.findMember(iPath)) != null) {
            if (!bl2 || iResource.exists()) {
                return iResource;
            }
            return null;
        }
        if (!iPath.isAbsolute()) {
            return null;
        }
        return JavaModel.a(iPath, bl2);
    }

    private static synchronized Object a(IPath iPath, boolean bl2) {
        File file = new File(iPath.toOSString());
        if (!bl2) {
            return file;
        }
        if (existingExternalFiles.contains(file)) {
            return file;
        }
        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [JavaModel.getTarget(...)] Checking existence of " + iPath.toString());
        }
        if (file.exists()) {
            existingExternalFiles.add(file);
            return file;
        }
        return null;
    }

    public static boolean isFile(Object object) {
        File file = JavaModel.getFile(object);
        return file != null && file.isFile();
    }

    public static synchronized File getFile(Object object) {
        File file;
        if (existingExternalConfirmedFiles.contains(object)) {
            return (File)object;
        }
        if (object instanceof File && (file = (File)object).exists()) {
            existingExternalConfirmedFiles.add(file);
            return file;
        }
        return null;
    }
}

